/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.entities;

import com.lightningcraft.achievements.LCAchievements;
import com.lightningcraft.ref.RefMisc;
import com.lightningcraft.util.WorldUtils;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public class EntityLCZombie
extends EntityZombie {
    private EntityLivingBase target;
    private EntityLivingBase owner;
    private UUID targetID;
    private UUID ownerID;
    private boolean isTargetPlayer;
    private boolean isOwnerPlayer;
    private static final int stateREADNBT = 1;
    private static final int stateTRIED = 2;
    private static final int stateDONE = 3;
    private int loadstate = 0;
    private int targetTries = 0;
    private int ownerTries = 0;
    private int tries = 0;
    private static final int tryLimit = 32;

    public EntityLCZombie(World world) {
        super(world);
    }

    public EntityLCZombie(World world, EntityLivingBase target, EntityLivingBase owner) {
        super(world);
        this.target = target;
        this.targetID = target.getPersistentID();
        this.owner = owner;
        this.ownerID = owner.getPersistentID();
        this.isTargetPlayer = target instanceof EntityPlayer;
        this.isOwnerPlayer = owner instanceof EntityPlayer;
        this.removeTargetTasks();
        this.setTargetTask();
        this.loadstate = 3;
    }

    private void removeTargetTasks() {
        List entries = this.field_70715_bh.field_75782_a;
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            EntityAITasks.EntityAITaskEntry e = (EntityAITasks.EntityAITaskEntry)iter.next();
            iter.remove();
        }
    }

    private void setTargetTask() {
        if (this.target != null) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, this.target.getClass(), 1.0, false));
        }
    }

    private void getData() {
        if (this.loadstate == 1) {
            this.removeTargetTasks();
        }
        if (this.targetID == null && this.ownerID == null) {
            this.loadstate = 3;
            return;
        }
        if (this.target == null) {
            EntityLivingBase entityLivingBase = this.target = this.targetID != null ? WorldUtils.getEntityLivingBaseFromUUID(this.field_70170_p, this.targetID, this.isTargetPlayer) : null;
        }
        if (this.owner == null) {
            EntityLivingBase entityLivingBase = this.owner = this.ownerID != null ? WorldUtils.getEntityLivingBaseFromUUID(this.field_70170_p, this.ownerID, this.isOwnerPlayer) : null;
        }
        if (this.target == null && this.owner == null) {
            this.loadstate = 2;
            ++this.tries;
            if (this.tries >= 32) {
                this.loadstate = 3;
            }
        } else {
            if (this.isTargetPlayer && this.target == null && this.targetTries < 32) {
                ++this.targetTries;
                this.loadstate = 2;
                return;
            }
            if (this.isOwnerPlayer && this.owner == null && this.ownerTries < 32) {
                ++this.ownerTries;
                this.loadstate = 2;
                return;
            }
            this.loadstate = 3;
            this.setTargetTask();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if ((this.loadstate == 1 || this.loadstate == 2) && this.target == null || this.owner == null) {
                this.getData();
            }
            if (this.target != null && this.isTargetPlayer && ((EntityPlayer)this.target).field_71075_bZ.field_75098_d) {
                this.target = null;
            }
            if (this.target != null && !this.target.field_70128_L) {
                this.func_70624_b(this.target);
                this.func_70604_c(this.target);
            } else if (this.loadstate == 3) {
                if (this.owner != null && this.target != null && this.target.field_70128_L && this.isOwnerPlayer && this.func_110143_aJ() > 0.0f) {
                    ((EntityPlayer)this.owner).func_71064_a((StatBase)LCAchievements.specialSwordKill, 1);
                }
                this.die();
            }
        }
    }

    public boolean func_70652_k(Entity victim) {
        if (!victim.field_70170_p.field_72995_K && victim instanceof EntityLivingBase) {
            Class<EntityLivingBase> t = EntityLivingBase.class;
            String recentlyHit = RefMisc.DEV != false ? "recentlyHit" : "field_70718_bc";
            try {
                Field playerHit = t.getDeclaredField(recentlyHit);
                playerHit.setAccessible(true);
                playerHit.setInt(victim, 60);
            }
            catch (NoSuchFieldException e) {
                System.out.println("Could not set recentlyHit on attacked entity: field does not exist");
            }
            catch (IllegalAccessException e) {
                System.out.println("Could not set recentlyHit on attacked entity: field is not accessible");
            }
        }
        return super.func_70652_k(victim);
    }

    public EntityLivingBase getOwner() {
        return this.owner;
    }

    private void die() {
        if (this.func_110143_aJ() > 0.0f) {
            this.func_85030_a("mob.zombie.death", 1.0f, 1.0f);
        }
        this.func_70606_j(0.0f);
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected Item func_146068_u() {
        return null;
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        String targetStr = tag.func_74779_i("target");
        String ownerStr = tag.func_74779_i("owner");
        this.targetID = UUID.fromString(targetStr);
        this.ownerID = UUID.fromString(ownerStr);
        this.isTargetPlayer = tag.func_74767_n("isTargetPlayer");
        this.isOwnerPlayer = tag.func_74767_n("isOwnerPlayer");
        this.target = null;
        this.owner = null;
        this.loadstate = 1;
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        if (this.target != null) {
            tag.func_74778_a("target", this.targetID.toString());
            tag.func_74757_a("isTargetPlayer", this.isTargetPlayer);
        }
        if (this.owner != null) {
            tag.func_74778_a("owner", this.ownerID.toString());
            tag.func_74757_a("isOwnerPlayer", this.isOwnerPlayer);
        }
    }
}

