/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.integration.jei;

import com.lightningcraft.config.LCConfig;
import com.lightningcraft.gui.client.GuiLightningCrusher;
import com.lightningcraft.gui.client.GuiLightningFurnace;
import com.lightningcraft.gui.client.GuiLightningInfuser;
import com.lightningcraft.integration.jei.crusher.LightningCrusherRecipeCategory;
import com.lightningcraft.integration.jei.crusher.LightningCrusherRecipeHandler;
import com.lightningcraft.integration.jei.infusion.LightningInfusionRecipeCategory;
import com.lightningcraft.integration.jei.infusion.LightningInfusionRecipeHandler;
import com.lightningcraft.recipes.LightningCrusherRecipes;
import com.lightningcraft.recipes.LightningInfusionRecipes;
import com.lightningcraft.ref.Log;
import mezz.jei.api.IItemRegistry;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;

    public void onJeiHelpersAvailable(IJeiHelpers helpers) {
        jeiHelpers = helpers;
    }

    public void register(IModRegistry reg) {
        if (LCConfig.JEIIntegration) {
            reg.addRecipeCategories(new IRecipeCategory[]{new LightningInfusionRecipeCategory(jeiHelpers.getGuiHelper()), new LightningCrusherRecipeCategory(jeiHelpers.getGuiHelper())});
            reg.addRecipeHandlers(new IRecipeHandler[]{new LightningInfusionRecipeHandler(), new LightningCrusherRecipeHandler()});
            reg.addRecipes(LightningInfusionRecipes.instance().getRecipeList());
            reg.addRecipes(LightningCrusherRecipes.instance().getRecipeList());
            reg.addRecipeClickArea(GuiLightningInfuser.class, 75, 40, 24, 16, new String[]{"lightningcraft.infusionRecipeCategory"});
            reg.addRecipeClickArea(GuiLightningCrusher.class, 79, 34, 24, 16, new String[]{"lightningcraft.crusherRecipeCategory"});
            reg.addRecipeClickArea(GuiLightningFurnace.class, 79, 34, 24, 16, new String[]{"minecraft.smelting"});
            Log.logger.info("JEI integration complete.");
        } else {
            Log.logger.info("JEI integration disabled.");
        }
    }

    public void onItemRegistryAvailable(IItemRegistry arg0) {
    }

    public void onRecipeRegistryAvailable(IRecipeRegistry arg0) {
    }

    public void onRuntimeAvailable(IJeiRuntime arg0) {
    }
}

