/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lightningcraft.items.ItemLC;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ItemPotionImitator
extends ItemLC {
    private Map<Integer, List<PotionEffect>> effectCache = Maps.newHashMap();
    private static final Map<List<PotionEffect>, Integer> SUB_ITEMS_CACHE = Maps.newLinkedHashMap();

    public ItemPotionImitator() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public List<PotionEffect> getEffects(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("CustomPotionEffects", 9)) {
            ArrayList list1 = Lists.newArrayList();
            NBTTagList nbttaglist = stack.func_77978_p().func_150295_c("CustomPotionEffects", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                PotionEffect potioneffect = PotionEffect.func_82722_b((NBTTagCompound)nbttagcompound);
                if (potioneffect == null) continue;
                list1.add(potioneffect);
            }
            return list1;
        }
        List list = this.effectCache.get(stack.func_77960_j());
        if (list == null) {
            list = PotionHelper.func_77917_b((int)stack.func_77960_j(), (boolean)false);
            this.effectCache.put(stack.func_77960_j(), list);
        }
        return list;
    }

    public List<PotionEffect> getEffects(int meta) {
        List list = this.effectCache.get(meta);
        if (list == null) {
            list = PotionHelper.func_77917_b((int)meta, (boolean)false);
            this.effectCache.put(meta, list);
        }
        return list;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        List<PotionEffect> list;
        if (!playerIn.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if (!worldIn.field_72995_K && (list = this.getEffects(stack)) != null) {
            for (PotionEffect potioneffect : list) {
                playerIn.func_70690_d(new PotionEffect(potioneffect));
            }
        }
        playerIn.func_71029_a(StatList.field_75929_E[Item.func_150891_b((Item)this)]);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            if (stack.field_77994_a <= 0) {
                return new ItemStack(Items.field_151069_bo);
            }
            playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        if (ItemPotionImitator.isSplash(itemStackIn.func_77960_j())) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --itemStackIn.field_77994_a;
            }
            worldIn.func_72956_a((Entity)playerIn, "random.bow", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                worldIn.func_72838_d((Entity)new EntityPotion(worldIn, (EntityLivingBase)playerIn, itemStackIn));
            }
            playerIn.func_71029_a(StatList.field_75929_E[Item.func_150891_b((Item)this)]);
            return itemStackIn;
        }
        playerIn.func_71008_a(itemStackIn, this.func_77626_a(itemStackIn));
        return itemStackIn;
    }

    public static boolean isSplash(int meta) {
        return (meta & 0x4000) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromDamage(int meta) {
        return PotionHelper.func_77915_a((int)meta, (boolean)false);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        return renderPass > 0 ? 0xFFFFFF : this.getColorFromDamage(stack.func_77960_j());
    }

    public String func_77653_i(ItemStack stack) {
        List list;
        if (stack.func_77960_j() == 0) {
            return StatCollector.func_74838_a((String)"item.emptyPotion.name").trim();
        }
        String s = "";
        if (ItemPotionImitator.isSplash(stack.func_77960_j())) {
            s = StatCollector.func_74838_a((String)"potion.prefix.grenade").trim() + " ";
        }
        if ((list = Items.field_151068_bn.func_77832_l(stack)) != null && !list.isEmpty()) {
            String s2 = ((PotionEffect)list.get(0)).func_76453_d();
            s2 = s2 + ".postfix";
            return s + StatCollector.func_74838_a((String)s2).trim();
        }
        String s1 = PotionHelper.func_77905_c((int)stack.func_77960_j());
        return StatCollector.func_74838_a((String)s1).trim() + " " + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isEffectInstant(int meta) {
        List<PotionEffect> list = this.getEffects(meta);
        if (list != null && !list.isEmpty()) {
            for (PotionEffect potioneffect : list) {
                if (!Potion.field_76425_a[potioneffect.func_76456_a()].func_76403_b()) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (stack.func_77960_j() != 0) {
            List list = Items.field_151068_bn.func_77832_l(stack);
            HashMultimap multimap = HashMultimap.create();
            if (list != null && !list.isEmpty()) {
                for (PotionEffect potioneffect : list) {
                    String s1 = StatCollector.func_74838_a((String)potioneffect.func_76453_d()).trim();
                    Potion potion = Potion.field_76425_a[potioneffect.func_76456_a()];
                    Map map = potion.func_111186_k();
                    if (map != null && map.size() > 0) {
                        for (Map.Entry entry : map.entrySet()) {
                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                            AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(potioneffect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                            multimap.put((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1);
                        }
                    }
                    if (potioneffect.func_76458_c() > 0) {
                        s1 = s1 + " " + StatCollector.func_74838_a((String)("potion.potency." + potioneffect.func_76458_c())).trim();
                    }
                    if (potioneffect.func_76459_b() > 20) {
                        s1 = s1 + " (" + Potion.func_76389_a((PotionEffect)potioneffect) + ")";
                    }
                    if (potion.func_76398_f()) {
                        tooltip.add(EnumChatFormatting.RED + s1);
                        continue;
                    }
                    tooltip.add(EnumChatFormatting.GRAY + s1);
                }
            } else {
                String s = StatCollector.func_74838_a((String)"potion.empty").trim();
                tooltip.add(EnumChatFormatting.GRAY + s);
            }
            if (!multimap.isEmpty()) {
                tooltip.add("");
                tooltip.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"potion.effects.whenDrank"));
                for (Map.Entry entry1 : multimap.entries()) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)entry1.getValue();
                    double d0 = attributemodifier2.func_111164_d();
                    double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)("attribute.modifier.plus." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    tooltip.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)("attribute.modifier.take." + attributemodifier2.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), StatCollector.func_74838_a((String)("attribute.name." + (String)entry1.getKey()))}));
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        List<PotionEffect> list = this.getEffects(stack);
        return list != null && !list.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        super.func_150895_a(itemIn, tab, subItems);
        if (SUB_ITEMS_CACHE.isEmpty()) {
            for (int i = 0; i <= 15; ++i) {
                for (int j = 0; j <= 1; ++j) {
                    int lvt_6_1_ = j == 0 ? i | 0x2000 : i | 0x4000;
                    for (int l = 0; l <= 2; ++l) {
                        List list;
                        int i1 = lvt_6_1_;
                        if (l != 0) {
                            if (l == 1) {
                                i1 = lvt_6_1_ | 0x20;
                            } else if (l == 2) {
                                i1 = lvt_6_1_ | 0x40;
                            }
                        }
                        if ((list = PotionHelper.func_77917_b((int)i1, (boolean)false)) == null || list.isEmpty()) continue;
                        SUB_ITEMS_CACHE.put(list, i1);
                    }
                }
            }
        }
        for (int j1 : SUB_ITEMS_CACHE.values()) {
            subItems.add(new ItemStack(itemIn, 1, j1));
        }
    }
}

