/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import com.lightningcraft.achievements.LCAchievements;
import com.lightningcraft.blocks.BlockAirTerminal;
import com.lightningcraft.tiles.TileEntityBase;
import com.lightningcraft.util.Effect;
import com.lightningcraft.util.WeatherUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityLightningCell
extends TileEntityBase {
    public double storedPower;
    public double maxPower;
    public double efficiency;
    public int cooldownTime;
    public boolean isUpgraded;
    public String cellName;
    private boolean topTierTerminal = false;
    private boolean didCheck = false;

    public TileEntityLightningCell(double mp, String name) {
        this.maxPower = mp;
        this.cellName = name;
    }

    public TileEntityLightningCell() {
    }

    public void func_73660_a() {
        EntityPlayerMP player;
        boolean dosave = false;
        if (this.field_145850_b.field_72995_K) {
            this.isAirTerminalPresent();
            return;
        }
        if (this.storedPower > this.maxPower) {
            this.storedPower = this.maxPower;
        }
        if (this.storedPower < 0.0) {
            this.storedPower = 0.0;
        }
        if (!this.didCheck && this.maxPower == 30000.0 && this.topTierTerminal && (player = (EntityPlayerMP)this.field_145850_b.func_72977_a((double)this.getX(), (double)this.getY(), (double)this.getZ(), 16.0)) != null && player.func_147099_x().func_77442_b(LCAchievements.perfectCell)) {
            player.func_71064_a((StatBase)LCAchievements.perfectCell, 1);
            this.didCheck = true;
        }
        if (this.cooldownTime > 0) {
            --this.cooldownTime;
            dosave = true;
        }
        if (this.isAirTerminalPresent()) {
            AxisAlignedBB box;
            List<EntityLightningBolt> bolts;
            double chance = 1.0E-5;
            if (this.field_145850_b.func_72911_I()) {
                chance = 0.001;
            }
            if (this.random.nextDouble() <= chance && this.storedPower < this.maxPower - 100.0 * this.efficiency) {
                Effect.lightningGen(this.field_145850_b, this.field_174879_c.func_177984_a());
            }
            if (!(bolts = WeatherUtils.getLightningBoltsWithinAABB(this.field_145850_b, box = new AxisAlignedBB((double)(this.getX() - 5), (double)(this.getY() - 2), (double)(this.getZ() - 5), (double)(this.getX() + 5), (double)(this.getY() + 4), (double)(this.getZ() + 5)))).isEmpty() && this.cooldownTime <= 0 && this.storedPower < this.maxPower - 100.0 * this.efficiency) {
                for (EntityLightningBolt bolt : bolts) {
                    if (bolt.field_70128_L) {
                        return;
                    }
                    this.field_145850_b.func_72900_e((Entity)bolt);
                }
                this.storedPower += 100.0 * this.efficiency;
                this.cooldownTime = 40;
                dosave = true;
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        par1.func_74780_a("storedPower", this.storedPower);
        par1.func_74780_a("maxPower", this.maxPower);
        par1.func_74768_a("cooldownTime", this.cooldownTime);
        par1.func_74757_a("isUpgraded", this.isUpgraded);
        par1.func_74757_a("topTierCheck", this.didCheck);
        par1.func_74778_a("customName", this.cellName);
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.storedPower = par1.func_74769_h("storedPower");
        this.maxPower = par1.func_74769_h("maxPower");
        this.cooldownTime = par1.func_74762_e("cooldownTime");
        this.isUpgraded = par1.func_74767_n("isUpgraded");
        this.didCheck = par1.func_74767_n("topTierCheck");
        this.cellName = par1.func_74779_i("customName");
    }

    public boolean isAirTerminalPresent() {
        boolean flag;
        this.topTierTerminal = false;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, 1, 0));
        Block test = state.func_177230_c();
        int meta = test.func_176201_c(state);
        if (test instanceof BlockAirTerminal) {
            flag = true;
            this.efficiency = ((BlockAirTerminal)test).getEfficiency(state);
            if (meta == 9) {
                this.topTierTerminal = true;
            }
        } else {
            flag = false;
            this.efficiency = 0.0;
        }
        return flag;
    }
}

