/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.util;

import com.lightningcraft.util.JointList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class StackHelper {
    private static Map<String, Integer> oreMap = new HashMap<String, Integer>();
    private static Map<String, Integer> subMap = new HashMap<String, Integer>();
    public static Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    public static ItemStack animateItemStackFromString(String stackString, boolean change) {
        ItemStack result;
        ItemStack primary;
        int ores = OreDictionary.doesOreNameExist((String)stackString) ? OreDictionary.getOres((String)stackString).size() : 1;
        int oreIndex = 0;
        int subIndex = 0;
        if (oreMap.containsKey(stackString)) {
            oreIndex = oreMap.get(stackString);
        }
        if (change) {
            oreIndex = ores > 0 ? rand.nextInt(ores) : 0;
            oreMap.put(stackString, oreIndex);
        }
        if ((primary = StackHelper.makeItemStackFromString(stackString, oreIndex)) == null) {
            return null;
        }
        JointList subItems = new JointList();
        primary.func_77973_b().func_150895_a(primary.func_77973_b(), null, subItems);
        if (subMap.containsKey(stackString)) {
            subIndex = subMap.get(stackString);
        }
        if (primary.func_77952_i() == Short.MAX_VALUE && !subItems.isEmpty()) {
            if (change) {
                subIndex = rand.nextInt(subItems.size());
                subMap.put(stackString, subIndex);
            }
            result = (ItemStack)subItems.get(subIndex);
        } else {
            result = primary;
        }
        return result;
    }

    public static ItemStack makeItemStackFromString(String stackString, int oreIndex) {
        List list;
        if (stackString == "NULL") {
            return null;
        }
        if (stackString.contains("@")) {
            try {
                String[] a = stackString.split("#");
                int stackSize = Integer.parseInt(a[0]);
                String[] b = a[1].split("@");
                String name = b[0];
                int meta = Integer.parseInt(b[1]);
                ItemStack output = GameRegistry.makeItemStack((String)name, (int)meta, (int)stackSize, null);
                return output;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (OreDictionary.doesOreNameExist((String)stackString) && oreIndex < (list = OreDictionary.getOres((String)stackString)).size()) {
            return (ItemStack)list.get(oreIndex);
        }
        return null;
    }

    public static ItemStack makeItemStackFromString(String stackString) {
        return StackHelper.makeItemStackFromString(stackString, 0);
    }

    public static int getMetaFromString(String stackString) {
        if (stackString.contains("@")) {
            String[] a = stackString.split("@");
            return Integer.parseInt(a[1]);
        }
        return -1;
    }

    public static String stripMetaFromString(String stackString) {
        if (stackString.contains("@")) {
            String[] a = stackString.split("@");
            return a[0];
        }
        return stackString;
    }

    public static String changeStringMeta(String stackString, int newMeta) {
        if (StackHelper.getMetaFromString(stackString) > -1) {
            return StackHelper.stripMetaFromString(stackString) + "@" + newMeta;
        }
        return stackString;
    }

    public static String makeStringFromItemStack(Object stack) {
        if (stack instanceof ItemStack) {
            ItemStack s = (ItemStack)stack;
            return s.field_77994_a + "#" + s.func_77973_b().getRegistryName() + "@" + s.func_77952_i();
        }
        if (stack instanceof String) {
            return (String)stack;
        }
        throw new IllegalArgumentException("Parameter must be a String or an ItemStack, was given " + stack.getClass());
    }

    public static boolean areItemStacksEqualForCrafting(ItemStack ... stacks) {
        ItemStack comp = stacks[0];
        if (comp == null) {
            return false;
        }
        ItemStack comp1 = comp.func_77946_l();
        comp1.field_77994_a = 1;
        for (int n = 1; n < stacks.length; ++n) {
            if (stacks[n] == null) {
                return false;
            }
            ItemStack comp2 = stacks[n].func_77946_l();
            comp2.field_77994_a = 1;
            if (ItemStack.func_77989_b((ItemStack)comp1, (ItemStack)comp2)) continue;
            if (comp1.func_77952_i() == Short.MAX_VALUE) {
                comp2.func_77964_b(Short.MAX_VALUE);
                if (ItemStack.func_77989_b((ItemStack)comp1, (ItemStack)comp2)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean setStackColor(ItemStack stack, Color color) {
        if (!(stack.func_77973_b() instanceof ItemArmor)) {
            return false;
        }
        Item armor = stack.func_77973_b();
        if (armor != Items.field_151021_T && armor != Items.field_151026_S && armor != Items.field_151027_R && armor != Items.field_151024_Q) {
            return false;
        }
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
        }
        NBTTagCompound disp = new NBTTagCompound();
        disp.func_74768_a("color", color.getRGB());
        nbttagcompound.func_74782_a("display", (NBTBase)disp);
        stack.func_77982_d(nbttagcompound);
        return true;
    }

    public static List<NBTTagCompound> getEnchantments(ItemStack s) {
        ArrayList<NBTTagCompound> enchList = new ArrayList<NBTTagCompound>();
        if (s != null && s.func_77942_o()) {
            String ench = s.func_77973_b() == Items.field_151134_bR ? "StoredEnchantments" : "ench";
            NBTTagList enchants = (NBTTagList)s.func_77978_p().func_74781_a(ench);
            if (enchants != null && enchants.func_74745_c() > 0) {
                for (int i = 0; i < enchants.func_74745_c(); ++i) {
                    NBTTagCompound enchant = enchants.func_150305_b(i);
                    enchList.add(enchant);
                }
            }
        }
        return enchList;
    }

    public static boolean addEnchantments(ItemStack s, List<NBTTagCompound> enchList) {
        if (s != null) {
            NBTTagList currentEnchants;
            String ench;
            String string = ench = s.func_77973_b() == Items.field_151134_bR ? "StoredEnchantments" : "ench";
            if (!s.func_77942_o()) {
                s.func_77982_d(new NBTTagCompound());
            }
            if ((currentEnchants = (NBTTagList)s.func_77978_p().func_74781_a(ench)) == null) {
                currentEnchants = new NBTTagList();
            }
            for (int i = 0; i < enchList.size(); ++i) {
                currentEnchants.func_74742_a((NBTBase)enchList.get(i));
            }
            s.func_77978_p().func_74782_a(ench, (NBTBase)currentEnchants);
            return true;
        }
        return false;
    }
}

