/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.util;

import com.lightningcraft.util.LCMisc;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class WorldUtils {
    private static final Block[] blacklist = new Block[]{Blocks.field_150353_l, Blocks.field_150480_ab, Blocks.field_150356_k, Blocks.field_150434_aF};
    static final Random random = new Random();

    public static boolean checkChunksExist(World world, int xFrom, int yFrom, int zFrom, int xTo, int yTo, int zTo) {
        if (yFrom >= 0 && yTo < 256) {
            for (int k1 = xFrom; k1 <= xTo; k1 += 4) {
                for (int l1 = zFrom; l1 <= zTo; l1 += 4) {
                    if (world.func_175667_e(new BlockPos(k1, (yFrom + yTo) / 2, l1))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void primeChunk(ChunkPrimer primer, IBlockState[] state) {
        for (int i = 0; i < state.length; ++i) {
            primer.func_177857_a(i, state[i]);
        }
    }

    public static boolean blockMatches(World world, BlockPos pos, Block block, int meta) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == block && block.func_176201_c(state) == meta;
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    public static EntityPlayer getClosestVulnerablePlayer(World world, double x, double y, double z, double dist, List<UUID> excludePlayers) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = (EntityPlayer)world.field_73010_i.get(i);
            if (entityplayer1 == null || excludePlayers.contains(entityplayer1.func_110124_au()) || entityplayer1.field_71075_bZ.field_75102_a || !entityplayer1.func_70089_S()) continue;
            double d5 = entityplayer1.func_70092_e(x, y, z);
            double d6 = dist;
            if (entityplayer1.func_70093_af()) {
                d6 = dist * (double)0.8f;
            }
            if (entityplayer1.func_82150_aj()) {
                float f = entityplayer1.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(dist < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public static Entity getClosestVulnerableEntityOfType(World world, double x, double y, double z, double dist, Class type, Class ... excludes) {
        double d4 = -1.0;
        Entity entity = null;
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity1 = (Entity)world.field_72996_f.get(i);
            if (entity1 == null || !type.isInstance(entity1) || entity1.func_180431_b(DamageSource.field_76377_j) || !entity1.func_70089_S()) continue;
            boolean skip = false;
            for (Class c : excludes) {
                if (!c.isInstance(entity1)) continue;
                skip = true;
            }
            if (skip) continue;
            double d5 = entity1.func_70092_e(x, y, z);
            double d6 = dist;
            if (entity1.func_70093_af()) {
                d6 = dist * (double)0.8f;
            }
            if (entity1.func_82150_aj()) {
                float f = entity1 instanceof EntityPlayer ? ((EntityPlayer)entity1).func_82243_bO() : 0.0f;
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d6 *= (double)(0.7f * f);
            }
            if (!(dist < 0.0) && !(d5 < d6 * d6) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entity = entity1;
        }
        return entity;
    }

    public static Integer getOpenSurface(World world, int x, int z, int starty, int distance, boolean onSolidBlock) {
        for (int y = (starty += 2) + distance; y >= starty - distance; --y) {
            if (WorldUtils.getBlock(world, x, y + 2, z) != Blocks.field_150350_a || WorldUtils.getBlock(world, x, y + 1, z) != Blocks.field_150350_a || WorldUtils.getBlock(world, x, y, z) == Blocks.field_150350_a || LCMisc.inArray(WorldUtils.getBlock(world, x, y, z), blacklist) || onSolidBlock && !WorldUtils.getBlock(world, x, y, z).func_149662_c() || y >= Math.max(world.func_72940_L() - 1, starty)) continue;
            return y + 1;
        }
        return null;
    }

    public static Integer getOpenSurfaceReverse(World world, int x, int z, int starty, int distance, boolean onSolidBlock) {
        for (int y = (starty += 2) - distance; y <= starty + distance; ++y) {
            if (WorldUtils.getBlock(world, x, y + 2, z) != Blocks.field_150350_a || WorldUtils.getBlock(world, x, y + 1, z) != Blocks.field_150350_a || WorldUtils.getBlock(world, x, y, z) == Blocks.field_150350_a || LCMisc.inArray(WorldUtils.getBlock(world, x, y, z), blacklist) || onSolidBlock && !WorldUtils.getBlock(world, x, y, z).func_149662_c() || y >= Math.max(world.func_72940_L() - 1, starty)) continue;
            return y + 1;
        }
        return null;
    }

    public static Integer getOpenSurfaceCentered(World world, int x, int z, int starty, int distance, boolean onSolidBlock) {
        Integer y = WorldUtils.getOpenSurfaceReverse(world, x, z, starty - distance / 2, distance / 2, onSolidBlock);
        if (y == null) {
            y = WorldUtils.getOpenSurface(world, x, z, starty + distance / 2, distance / 2, onSolidBlock);
        }
        return y;
    }

    public static Integer getOpenSurface(World world, int x, int z, int starty, int distance) {
        return WorldUtils.getOpenSurface(world, x, z, starty, distance, false);
    }

    public static Integer getOpenCeiling(World world, int x, int z, int starty, int endy, int airBlocks) {
        for (int y = endy; y >= starty; --y) {
            if (!WorldUtils.canSpawnAtCeilingPosition(world, x, y - 1, z, airBlocks) || LCMisc.inArray(WorldUtils.getBlock(world, x, y, z), blacklist) || y >= Math.max(world.func_72940_L() - 1, starty)) continue;
            return y - 1;
        }
        return null;
    }

    public static boolean canSpawnAtPosition(World world, int x, int y, int z, Block onBlock, int airAbove) {
        if (WorldUtils.getBlock(world, x, y - 1, z) == onBlock) {
            for (int i = 0; i < airAbove; ++i) {
                if (WorldUtils.getBlock(world, x, y + i, z) == Blocks.field_150350_a) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canSpawnAtPosition(World world, int x, int y, int z, int airAbove) {
        if (WorldUtils.getBlock(world, x, y - 1, z) != Blocks.field_150350_a) {
            for (int i = 0; i < airAbove; ++i) {
                if (WorldUtils.getBlock(world, x, y + i, z) == Blocks.field_150350_a) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canSpawnAtPositionLoosely(World world, int x, int y, int z, int airAbove, int marginDown, int marginUp) {
        for (int j = y - marginDown; j <= y + marginUp; ++j) {
            if (!WorldUtils.canSpawnAtPosition(world, x, j, z, airAbove)) continue;
            return true;
        }
        return false;
    }

    public static boolean canSpawnAtCeilingPosition(World world, int x, int y, int z, int airBelow) {
        if (WorldUtils.getBlock(world, x, y + 1, z) != Blocks.field_150350_a) {
            for (int i = 0; i < airBelow; ++i) {
                if (WorldUtils.getBlock(world, x, y - i, z) == Blocks.field_150350_a) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Entity getEntityFromUUID(World world, UUID id) {
        for (Entity e : world.field_72996_f) {
            if (!e.getPersistentID().toString().equals(id.toString())) continue;
            return e;
        }
        return null;
    }

    public static EntityLivingBase getEntityLivingBaseFromUUID(World world, UUID id, boolean isPlayer) {
        Object e = !isPlayer ? WorldUtils.getEntityFromUUID(world, id) : WorldUtils.getEntityPlayerFromUUID(world, id);
        if (e instanceof EntityLivingBase) {
            return (EntityLivingBase)e;
        }
        return null;
    }

    public static EntityLivingBase getEntityLivingBaseFromUUID(World world, UUID id) {
        return WorldUtils.getEntityLivingBaseFromUUID(world, id, false);
    }

    public static EntityPlayer getEntityPlayerFromUUID(World world, UUID id) {
        for (EntityPlayer e : world.field_73010_i) {
            if (!e.getPersistentID().toString().equals(id.toString())) continue;
            return e;
        }
        return null;
    }

    public static boolean spawnMobNearPlayer(EntityPlayer player, EntityMob mob, double mindist, double maxdist) {
        double z;
        double dd = maxdist - mindist;
        double dist = mindist + random.nextDouble() * dd;
        float angle = (float)(random.nextDouble() * 2.0 * Math.PI);
        double x = player.field_70165_t - (double)MathHelper.func_76126_a((float)angle) * dist;
        Integer y = WorldUtils.getOpenSurface(player.field_70170_p, (int)x, (int)(z = player.field_70161_v + (double)MathHelper.func_76134_b((float)angle) * dist), (int)player.field_70163_u, 10, true);
        if (y == null) {
            return false;
        }
        if (player.field_70170_p.func_175626_b(new BlockPos((int)x, y.intValue(), (int)z), 0) <= 7) {
            mob.func_70634_a(x, (double)y.intValue(), z);
            return player.field_70170_p.func_72838_d((Entity)mob);
        }
        return false;
    }
}

