/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.worldgen;

import com.lightningcraft.blocks.LCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenUnderworldTrees
extends WorldGenAbstractTree {
    private final int minTreeHeight;
    private final boolean vinesGrow;
    private final IBlockState metaWood;
    private final IBlockState metaLeaves;

    public WorldGenUnderworldTrees(boolean setFalse) {
        this(setFalse, 6);
    }

    public WorldGenUnderworldTrees(boolean setFalse, int minTreeHeight) {
        super(setFalse);
        this.minTreeHeight = minTreeHeight;
        this.metaWood = LCBlocks.woodLog.func_176223_P();
        this.metaLeaves = Blocks.field_150362_t.func_176223_P();
        this.vinesGrow = true;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            Block block1 = worldIn.func_180495_p(down).func_177230_c();
            boolean isSoil = block1.canSustainPlant((IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < 256 - i - 1) {
                block1.onPlantGrow(worldIn, down, position);
                int k2 = 3;
                int l2 = 0;
                for (int i3 = position.func_177956_o() - k2 + i; i3 <= position.func_177956_o() + i; ++i3) {
                    int i4 = i3 - (position.func_177956_o() + i);
                    int j1 = l2 + 1 - i4 / 2;
                    for (int k1 = position.func_177958_n() - j1; k1 <= position.func_177958_n() + j1; ++k1) {
                        int l1 = k1 - position.func_177958_n();
                        for (int i2 = position.func_177952_p() - j1; i2 <= position.func_177952_p() + j1; ++i2) {
                            BlockPos blockpos;
                            Block block;
                            int j2 = i2 - position.func_177952_p();
                            if (Math.abs(l1) == j1 && Math.abs(j2) == j1 && (rand.nextInt(2) == 0 || i4 == 0) || !(block = worldIn.func_180495_p(blockpos = new BlockPos(k1, i3, i2)).func_177230_c()).isAir((IBlockAccess)worldIn, blockpos) && !block.isLeaves((IBlockAccess)worldIn, blockpos) && block.func_149688_o() != Material.field_151582_l) continue;
                            this.func_175903_a(worldIn, blockpos, this.metaLeaves);
                        }
                    }
                }
                for (int j3 = 0; j3 < i; ++j3) {
                    BlockPos upN = position.func_177981_b(j3);
                    Block block2 = worldIn.func_180495_p(upN).func_177230_c();
                    if (!block2.isAir((IBlockAccess)worldIn, upN) && !block2.isLeaves((IBlockAccess)worldIn, upN) && block2.func_149688_o() != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j3), this.metaWood);
                    if (!this.vinesGrow || j3 <= 0) continue;
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(-1, j3, 0))) {
                        this.func_181651_a(worldIn, position.func_177982_a(-1, j3, 0), BlockVine.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(1, j3, 0))) {
                        this.func_181651_a(worldIn, position.func_177982_a(1, j3, 0), BlockVine.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && worldIn.func_175623_d(position.func_177982_a(0, j3, -1))) {
                        this.func_181651_a(worldIn, position.func_177982_a(0, j3, -1), BlockVine.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !worldIn.func_175623_d(position.func_177982_a(0, j3, 1))) continue;
                    this.func_181651_a(worldIn, position.func_177982_a(0, j3, 1), BlockVine.field_176273_b);
                }
                if (this.vinesGrow) {
                    for (int k3 = position.func_177956_o() - 3 + i; k3 <= position.func_177956_o() + i; ++k3) {
                        int j4 = k3 - (position.func_177956_o() + i);
                        int k4 = 2 - j4 / 2;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
                        for (int l4 = position.func_177958_n() - k4; l4 <= position.func_177958_n() + k4; ++l4) {
                            for (int i5 = position.func_177952_p() - k4; i5 <= position.func_177952_p() + k4; ++i5) {
                                blockpos$mutableblockpos1.func_181079_c(l4, k3, i5);
                                if (!worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos1).func_177230_c().isLeaves((IBlockAccess)worldIn, (BlockPos)blockpos$mutableblockpos1)) continue;
                                BlockPos blockpos2 = blockpos$mutableblockpos1.func_177976_e();
                                BlockPos blockpos3 = blockpos$mutableblockpos1.func_177974_f();
                                BlockPos blockpos4 = blockpos$mutableblockpos1.func_177978_c();
                                BlockPos blockpos1 = blockpos$mutableblockpos1.func_177968_d();
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos2).func_177230_c().isAir((IBlockAccess)worldIn, blockpos2)) {
                                    this.func_181650_b(worldIn, blockpos2, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos3).func_177230_c().isAir((IBlockAccess)worldIn, blockpos3)) {
                                    this.func_181650_b(worldIn, blockpos3, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && worldIn.func_180495_p(blockpos4).func_177230_c().isAir((IBlockAccess)worldIn, blockpos4)) {
                                    this.func_181650_b(worldIn, blockpos4, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !worldIn.func_180495_p(blockpos1).func_177230_c().isAir((IBlockAccess)worldIn, blockpos1)) continue;
                                this.func_181650_b(worldIn, blockpos1, BlockVine.field_176273_b);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void func_181651_a(World p_181651_1_, BlockPos p_181651_2_, PropertyBool p_181651_3_) {
        this.func_175903_a(p_181651_1_, p_181651_2_, Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)p_181651_3_, (Comparable)Boolean.valueOf(true)));
    }

    private void func_181650_b(World p_181650_1_, BlockPos p_181650_2_, PropertyBool p_181650_3_) {
        this.func_181651_a(p_181650_1_, p_181650_2_, p_181650_3_);
        p_181650_2_ = p_181650_2_.func_177977_b();
        for (int i = 4; p_181650_1_.func_180495_p(p_181650_2_).func_177230_c().isAir((IBlockAccess)p_181650_1_, p_181650_2_) && i > 0; --i) {
            this.func_181651_a(p_181650_1_, p_181650_2_, p_181650_3_);
            p_181650_2_ = p_181650_2_.func_177977_b();
        }
    }
}

