/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.dimensions;

import com.LightningCraft.blocks.LCBlocks;
import com.LightningCraft.lib.RefMisc;
import com.LightningCraft.util.LCMisc;
import com.LightningCraft.worldgen.WorldGenIceShrub;
import com.LightningCraft.worldgen.WorldGenUnderworldLight;
import com.LightningCraft.worldgen.WorldGenUnderworldLiquid;
import com.LightningCraft.worldgen.WorldGenUnderworldTrees;
import com.LightningCraft.worldgen.structure.underworld.MapGenUnderworldRampart;
import com.LightningCraft.worldgen.structure.underworld.MapGenUnderworldTower;
import com.LightningCraft.worldgen.structure.underworld.MapGenUnderworldWaterTemple;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class ChunkProviderUnderworld
implements IChunkProvider {
    private Random dimRNG;
    public static final int chunkHeight = 256;
    private NoiseGeneratorOctaves underworldNoiseGen1;
    private NoiseGeneratorOctaves underworldNoiseGen2;
    private NoiseGeneratorOctaves underworldNoiseGen3;
    private NoiseGeneratorOctaves grassandstoneNoiseGen;
    private NoiseGeneratorOctaves understoneExculsivityNoiseGen;
    public NoiseGeneratorOctaves underworldNoiseGen6;
    public NoiseGeneratorOctaves underworldNoiseGen7;
    private World worldObj;
    private double[] noiseField;
    private double[] grassNoise = new double[256];
    private double[] stoneNoise = new double[256];
    private double[] understoneExclusivityNoise = new double[256];
    private MapGenBase underworldCaveGenerator = new MapGenCavesHell();
    public MapGenUnderworldWaterTemple genUnderworldWaterTemple = new MapGenUnderworldWaterTemple();
    public MapGenUnderworldTower genUnderworldTower = new MapGenUnderworldTower();
    public MapGenUnderworldRampart genUnderworldRampart = new MapGenUnderworldRampart();
    public static boolean towerLoadingExtraChunks = false;
    public static boolean rampartLoadingExtraChunks = false;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;

    public ChunkProviderUnderworld(World world, long seed) {
        this.worldObj = world;
        this.dimRNG = new Random(seed - 1L);
        this.underworldNoiseGen1 = new NoiseGeneratorOctaves(this.dimRNG, 16);
        this.underworldNoiseGen2 = new NoiseGeneratorOctaves(this.dimRNG, 16);
        this.underworldNoiseGen3 = new NoiseGeneratorOctaves(this.dimRNG, 8);
        this.grassandstoneNoiseGen = new NoiseGeneratorOctaves(this.dimRNG, 4);
        this.understoneExculsivityNoiseGen = new NoiseGeneratorOctaves(this.dimRNG, 4);
        this.underworldNoiseGen6 = new NoiseGeneratorOctaves(this.dimRNG, 10);
        this.underworldNoiseGen7 = new NoiseGeneratorOctaves(this.dimRNG, 16);
    }

    public void func_147419_a(int p_147419_1_, int p_147419_2_, Block[] p_147419_3_) {
        int b0 = 4;
        int b1 = 32;
        int k = b0 + 1;
        int b2 = 33;
        int l = b0 + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, p_147419_1_ * b0, 0, p_147419_2_ * b0, k, b2, l);
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 0];
                    double d2 = this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 0];
                    double d3 = this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 0];
                    double d4 = this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 0];
                    double d5 = (this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 1] - d1) * d0;
                    double d6 = (this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 1] - d2) * d0;
                    double d7 = (this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 1] - d3) * d0;
                    double d8 = (this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << 4 + LCMisc.log2(256) | 0 + j1 * 4 << LCMisc.log2(256) | k1 * 8 + l1;
                            int short1 = 256;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                Block block = null;
                                if (k1 * 8 + l1 < b1) {
                                    block = Blocks.field_150355_j;
                                }
                                if (d15 > 0.0) {
                                    block = LCBlocks.understone;
                                }
                                p_147419_3_[j2] = block;
                                j2 += short1;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int p_147418_1_, int p_147418_2_, Block[] blocks, byte[] meta, BiomeGenBase[] biomes) {
        int stoneGrassCanGen = 192;
        double d0 = 0.03125;
        this.grassNoise = this.grassandstoneNoiseGen.func_76304_a(this.grassNoise, p_147418_1_ * 16, p_147418_2_ * 16, 0, 16, 16, 1, d0, d0, 1.0);
        this.stoneNoise = this.grassandstoneNoiseGen.func_76304_a(this.stoneNoise, p_147418_1_ * 16, 109, p_147418_2_ * 16, 16, 1, 16, d0, 1.0, d0);
        this.understoneExclusivityNoise = this.understoneExculsivityNoiseGen.func_76304_a(this.understoneExclusivityNoise, p_147418_1_ * 16, p_147418_2_ * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                boolean flag = this.grassNoise[k + l * 16] + this.dimRNG.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.stoneNoise[k + l * 16] + this.dimRNG.nextDouble() * 0.4 > 0.0;
                int i1 = (int)(this.understoneExclusivityNoise[k + l * 16] / 3.0 + 3.0 + this.dimRNG.nextDouble() * 0.25);
                int j1 = -1;
                Block block = LCBlocks.understone;
                Block block1 = LCBlocks.understone;
                for (int k1 = 255; k1 >= 0; --k1) {
                    int l1 = (l * 16 + k) * 256 + k1;
                    if (k1 < 255 - this.dimRNG.nextInt(5) && k1 > 0 + this.dimRNG.nextInt(5)) {
                        Block block2 = blocks[l1];
                        if (block2 != null && block2.func_149688_o() != Material.field_151579_a) {
                            if (block2 != LCBlocks.understone) continue;
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    block = null;
                                    block1 = LCBlocks.understone;
                                } else if (k1 >= stoneGrassCanGen - 4 && k1 <= stoneGrassCanGen + 1) {
                                    block = LCBlocks.understone;
                                    block1 = LCBlocks.understone;
                                    if (flag1) {
                                        block = Blocks.field_150348_b;
                                        block1 = LCBlocks.corruptStone;
                                    }
                                    if (flag) {
                                        block = Blocks.field_150349_c;
                                        block1 = Blocks.field_150346_d;
                                    }
                                }
                                if (k1 < stoneGrassCanGen && (block == null || block.func_149688_o() == Material.field_151579_a)) {
                                    block = Blocks.field_150432_aD;
                                }
                                j1 = i1;
                                if (k1 >= stoneGrassCanGen - 1) {
                                    blocks[l1] = block;
                                    continue;
                                }
                                if (k1 + 1 < 256 && (blocks[l1 + 1] == null || blocks[l1 + 1].func_149688_o() == Material.field_151579_a)) {
                                    blocks[l1] = block;
                                    continue;
                                }
                                blocks[l1] = block1;
                                continue;
                            }
                            if (j1 <= 0) continue;
                            --j1;
                            blocks[l1] = block1;
                            continue;
                        }
                        j1 = -1;
                        continue;
                    }
                    blocks[l1] = Blocks.field_150357_h;
                }
            }
        }
    }

    public Chunk func_73158_c(int p_73158_1_, int p_73158_2_) {
        return this.func_73154_d(p_73158_1_, p_73158_2_);
    }

    public Chunk func_73154_d(int p_73154_1_, int p_73154_2_) {
        this.dimRNG.setSeed((long)p_73154_1_ * 341873128712L + (long)p_73154_2_ * 132897987541L);
        Block[] ablock = new Block[65536];
        byte[] meta = new byte[ablock.length];
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, p_73154_1_ * 16, p_73154_2_ * 16, 16, 16);
        this.func_147419_a(p_73154_1_, p_73154_2_, ablock);
        this.replaceBiomeBlocks(p_73154_1_, p_73154_2_, ablock, meta, abiomegenbase);
        this.underworldCaveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, p_73154_1_, p_73154_2_, ablock);
        this.genUnderworldWaterTemple.func_151539_a(this, this.worldObj, p_73154_1_, p_73154_2_, ablock);
        this.genUnderworldTower.func_151539_a(this, this.worldObj, p_73154_1_, p_73154_2_, ablock);
        if (!rampartLoadingExtraChunks) {
            this.genUnderworldRampart.func_151539_a(this, this.worldObj, p_73154_1_, p_73154_2_, ablock);
        }
        Chunk chunk = new Chunk(this.worldObj, ablock, meta, p_73154_1_, p_73154_2_);
        byte[] abyte = chunk.func_76605_m();
        for (int k = 0; k < abyte.length; ++k) {
            abyte[k] = (byte)abiomegenbase[k].field_76756_M;
        }
        chunk.func_76613_n();
        return chunk;
    }

    private double[] initializeNoiseField(double[] p_73164_1_, int p_73164_2_, int p_73164_3_, int p_73164_4_, int p_73164_5_, int p_73164_6_, int p_73164_7_) {
        int i2;
        if (p_73164_1_ == null) {
            p_73164_1_ = new double[p_73164_5_ * p_73164_6_ * p_73164_7_];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.underworldNoiseGen6.func_76304_a(this.noiseData4, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, 1, p_73164_7_, 1.0, 0.0, 1.0);
        this.noiseData5 = this.underworldNoiseGen7.func_76304_a(this.noiseData5, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, 1, p_73164_7_, 100.0, 0.0, 100.0);
        this.noiseData1 = this.underworldNoiseGen3.func_76304_a(this.noiseData1, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.underworldNoiseGen1.func_76304_a(this.noiseData2, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0, d1, d0);
        this.noiseData3 = this.underworldNoiseGen2.func_76304_a(this.noiseData3, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[p_73164_6_];
        for (i2 = 0; i2 < p_73164_6_; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)p_73164_6_) * 2.0;
            double d2 = i2;
            if (i2 > p_73164_6_ / 2) {
                d2 = p_73164_6_ - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < p_73164_5_; ++i2) {
            for (int k2 = 0; k2 < p_73164_7_; ++k2) {
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)p_73164_6_ / 16.0;
                ++l1;
                for (int j2 = 0; j2 < p_73164_6_; ++j2) {
                    double d11;
                    double d6 = 0.0;
                    double d7 = adouble1[j2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (j2 > p_73164_6_ - 4) {
                        d11 = (float)(j2 - (p_73164_6_ - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)j2 < d4) {
                        d11 = (d4 - (double)j2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    p_73164_1_[k1] = d6;
                    ++k1;
                }
            }
        }
        return p_73164_1_;
    }

    public boolean func_73149_a(int p_73149_1_, int p_73149_2_) {
        return true;
    }

    public void func_73153_a(IChunkProvider p_73153_1_, int p_73153_2_, int p_73153_3_) {
        int j2;
        int i2;
        int l1;
        int k1;
        int j1;
        BlockFalling.field_149832_M = true;
        int k = p_73153_2_ * 16;
        int l = p_73153_3_ * 16;
        if (RefMisc.DEBUG && rampartLoadingExtraChunks) {
            System.out.println("Loading chunk for rampart");
        }
        this.genUnderworldWaterTemple.func_75051_a(this.worldObj, this.dimRNG, p_73153_2_, p_73153_3_);
        this.genUnderworldTower.func_75051_a(this.worldObj, this.dimRNG, p_73153_2_, p_73153_3_);
        if (!rampartLoadingExtraChunks) {
            this.genUnderworldRampart.func_75051_a(this.worldObj, this.dimRNG, p_73153_2_, p_73153_3_);
        }
        boolean doGen = true;
        int numGen = this.dimRNG.nextInt(this.dimRNG.nextInt(12) + 1) + 4;
        for (j1 = 0; doGen && j1 < numGen; ++j1) {
            k1 = k + this.dimRNG.nextInt(16) + 8;
            l1 = this.dimRNG.nextInt(248) + 4;
            i2 = l + this.dimRNG.nextInt(16) + 8;
            new WorldGenUnderworldLight().func_76484_a(this.worldObj, this.dimRNG, k1, l1, i2);
        }
        numGen = 96;
        for (j1 = 0; doGen && j1 < numGen; ++j1) {
            k1 = k + this.dimRNG.nextInt(16) + 8;
            l1 = this.dimRNG.nextInt(248) + 4;
            i2 = l + this.dimRNG.nextInt(16) + 8;
            new WorldGenUnderworldTrees(false, 6).func_76484_a(this.worldObj, this.dimRNG, k1, l1, i2);
        }
        numGen = this.dimRNG.nextInt(this.dimRNG.nextInt(3) + 1) + 1;
        for (j1 = 0; doGen && j1 < numGen; ++j1) {
            k1 = k + this.dimRNG.nextInt(16) + 8;
            l1 = this.dimRNG.nextInt(248) + 4;
            i2 = l + this.dimRNG.nextInt(16) + 8;
            new WorldGenIceShrub().func_76484_a(this.worldObj, this.dimRNG, k1, l1, i2);
        }
        WorldGenMinable[] ore = new WorldGenMinable[]{new WorldGenMinable(LCBlocks.underworldOre, 0, 20, LCBlocks.understone), new WorldGenMinable(LCBlocks.underworldOre, 1, 16, LCBlocks.understone), new WorldGenMinable(LCBlocks.underworldOre, 2, 12, LCBlocks.understone)};
        int[] frequency = new int[]{8, 6, 4};
        for (int currentOre = 0; currentOre < 3; ++currentOre) {
            numGen = this.dimRNG.nextInt(this.dimRNG.nextInt((int)((double)frequency[currentOre] * 1.67)) + 1);
            for (k1 = 0; k1 < numGen; ++k1) {
                l1 = k + this.dimRNG.nextInt(16);
                i2 = this.dimRNG.nextInt(236) + 10;
                j2 = l + this.dimRNG.nextInt(16);
                ore[currentOre].func_76484_a(this.worldObj, this.dimRNG, l1, i2, j2);
            }
        }
        numGen = this.dimRNG.nextInt(this.dimRNG.nextInt(16) + 1) + 2;
        for (k1 = 0; k1 < numGen; ++k1) {
            l1 = k + this.dimRNG.nextInt(16);
            i2 = this.dimRNG.nextInt(236) + 10;
            j2 = l + this.dimRNG.nextInt(16);
            new WorldGenUnderworldLiquid((Block)Blocks.field_150358_i, false).func_76484_a(this.worldObj, this.dimRNG, l1, i2, j2);
        }
        BlockFalling.field_149832_M = false;
    }

    public boolean func_73151_a(boolean p_73151_1_, IProgressUpdate p_73151_2_) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "UnderworldRandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType creatureType, int x, int y, int z) {
        boolean canAccessWorld;
        boolean bl = canAccessWorld = this.genUnderworldTower.canAccessWorld() && this.genUnderworldWaterTemple.canAccessWorld() && this.genUnderworldRampart.canAccessWorld();
        if ((creatureType == EnumCreatureType.monster || creatureType == EnumCreatureType.ambient) && this.genUnderworldTower.func_75048_a(x, y, z)) {
            return this.genUnderworldTower.getSpawnList();
        }
        if ((creatureType == EnumCreatureType.monster || creatureType == EnumCreatureType.ambient) && this.genUnderworldWaterTemple.func_75048_a(x, y, z)) {
            return this.genUnderworldWaterTemple.getSpawnList();
        }
        if (creatureType == EnumCreatureType.monster && this.genUnderworldRampart.func_75048_a(x, y, z) && this.worldObj.func_147439_a(x, y - 1, z) != Blocks.field_150350_a) {
            return this.genUnderworldRampart.getSpawnList();
        }
        if (canAccessWorld) {
            BiomeGenBase biomegenbase = this.worldObj.func_72807_a(x, z);
            return biomegenbase.func_76747_a(creatureType);
        }
        return null;
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int p_82695_1_, int p_82695_2_) {
    }
}

