/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.entities;

import com.LightningCraft.achievements.LCAchievements;
import com.LightningCraft.items.LCItems;
import com.LightningCraft.util.SkyUtils;
import java.util.LinkedList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class EntityDemonSoldier
extends EntityMob {
    protected boolean isArmed = false;
    protected boolean isTough = false;
    protected boolean didReadNBT = false;
    protected int readTries = 0;
    protected static final int maxReadTries = 10;

    public EntityDemonSoldier(World world, boolean isTough) {
        this(world);
        this.isTough = isTough;
        this.didReadNBT = true;
    }

    public EntityDemonSoldier(World world) {
        super(world);
        this.field_82174_bp[0] = 0.025f;
        if (this.field_70146_Z.nextDouble() <= 0.01) {
            this.isTough = true;
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.func_70105_a(0.6f, 1.8f);
        this.field_70178_ae = true;
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer p;
            if (this.didReadNBT && !this.isArmed) {
                this.armDemon();
                this.isArmed = true;
            }
            if (!this.didReadNBT) {
                ++this.readTries;
                if (this.readTries > 10) {
                    this.didReadNBT = true;
                }
            }
            if (this.func_70638_az() == null && (p = (EntityPlayer)this.func_70782_k()) != null) {
                this.func_70624_b((EntityLivingBase)p);
                p.func_145747_a((IChatComponent)new ChatComponentText("[Demon Soldier] \u00a74\u00a7oYou will pay for your insolence.\u00a7r"));
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean flag = super.func_70097_a(source, damage);
        if (!this.field_70170_p.field_72995_K) {
            Entity p = source.func_76346_g();
            if (this.func_110143_aJ() > 0.0f && p != null && p instanceof EntityPlayerMP && this.func_70638_az() != p && !((EntityPlayerMP)p).field_71075_bZ.field_75098_d) {
                ((EntityPlayerMP)p).func_145747_a((IChatComponent)new ChatComponentText("[Demon Soldier] \u00a74\u00a7oWhat a fool.\u00a7r"));
            }
            if (this.func_110143_aJ() <= 0.0f && p instanceof EntityPlayer) {
                ((EntityPlayer)p).func_71064_a((StatBase)LCAchievements.demonKill, 1);
            }
        }
        return flag;
    }

    protected Entity func_70782_k() {
        EntityPlayerMP entityplayer = (EntityPlayerMP)this.field_70170_p.func_72856_b((Entity)this, 16.0);
        return entityplayer != null && this.func_70685_l((Entity)entityplayer) && SkyUtils.isPlayerInsolent(entityplayer) ? entityplayer : null;
    }

    protected void func_82164_bB() {
        this.armDemon();
    }

    protected void armDemon() {
        LinkedList<ItemStack> sword = new LinkedList<ItemStack>();
        sword.add(new ItemStack(LCItems.soulSword));
        sword.add(new ItemStack(LCItems.zombieSword));
        sword.add(new ItemStack(LCItems.featherSword));
        sword.add(new ItemStack(LCItems.enderSword));
        if (this.isTough) {
            sword.add(new ItemStack(LCItems.skySword));
        }
        int sel = this.field_70146_Z.nextInt(sword.size());
        ((ItemStack)sword.get(sel)).func_77966_a(Enchantment.field_77334_n, 2);
        this.func_70062_b(0, (ItemStack)sword.get(sel));
        if (this.isTough) {
            this.func_70062_b(3, new ItemStack((Item)Items.field_151023_V));
            this.func_70062_b(2, new ItemStack((Item)Items.field_151022_W));
            this.func_70062_b(1, new ItemStack((Item)Items.field_151029_X));
        }
    }

    public int func_70658_aO() {
        int i = super.func_70658_aO() + 8;
        if (i > 23) {
            i = 23;
        }
        return i;
    }

    protected String func_70639_aQ() {
        return "lightningcraft:mob.demonSoldier.idle";
    }

    protected String func_70621_aR() {
        return "lightningcraft:mob.demonSoldier.hurt";
    }

    protected String func_70673_aS() {
        return "lightningcraft:mob.demonSoldier.death";
    }

    protected void func_70628_a(boolean playerkill, int looting) {
        int k;
        int j = this.field_70146_Z.nextInt(3 + looting);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151065_br, 1);
        }
        j = this.field_70146_Z.nextInt(2 + looting);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(LCItems.demonBlood, 1);
        }
    }

    protected void func_70600_l(int p_70600_1_) {
        this.func_145779_a(LCItems.skyItem, 1);
    }

    public void func_70020_e(NBTTagCompound tag) {
        super.func_70020_e(tag);
        this.isArmed = tag.func_74767_n("isArmed");
        this.isTough = tag.func_74767_n("isTough");
        this.didReadNBT = true;
    }

    public void func_70109_d(NBTTagCompound tag) {
        super.func_70109_d(tag);
        tag.func_74757_a("isArmed", this.isArmed);
        tag.func_74757_a("isTough", this.isTough);
    }
}

