/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.gui;

import com.LightningCraft.config.LCConfig;
import com.LightningCraft.recipes.LPInfusionRecipes;
import com.LightningCraft.util.LCMisc;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiLightningBook
extends GuiScreen {
    private final int bookImageHeight = 192;
    private final int bookImageWidth = 192;
    private int currPage = 0;
    private int indexPage;
    private int recipePage;
    private int bookTotalPages;
    private static ResourceLocation bookCoverTexture = new ResourceLocation("lightningcraft:textures/gui/lightning_book_cover.png");
    private static ResourceLocation bookMainTexture = new ResourceLocation("lightningcraft:textures/gui/lightning_book.png");
    private static ResourceLocation bookRecipeTexture = new ResourceLocation("lightningcraft:textures/gui/lightning_book_recipes.png");
    private LinkedList<String> pages = new LinkedList();
    private LinkedList<RecipePage> recipePages = new LinkedList();
    private GuiButton buttonDone;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonLastPage;
    private NextPageButton buttonPreviousPage;
    private NextPageButton buttonFirstPage;
    private GuiButton level1Ref;
    private int pageLevel1 = -1;
    private GuiButton level2Ref;
    private int pageLevel2 = -1;
    private GuiButton level3Ref;
    private int pageLevel3 = -1;
    private GuiButton indexRef;
    private int level;
    private int mouseX;
    private int mouseY;

    public GuiLightningBook() {
        this(0);
    }

    public GuiLightningBook(int level) {
        String edition = "";
        String S = "\u00a7";
        switch (level) {
            case 0: {
                break;
            }
            case 1: {
                edition = S + "4" + S + "lSKYFATHER EDITION";
                break;
            }
            case 2: {
                edition = S + "3" + S + "lUNDERWORLD EDITION";
                break;
            }
            case 3: {
                edition = S + "d" + S + "lTRANSCENDENTAL EDITION";
            }
        }
        this.pages.add("\n\n\n" + S + "9by SBlectric" + S + "0\n\n" + S + "oA Guide to the\nWorld of Lightning!" + S + "r\n\n" + edition);
        this.pages.add("It is said only the very brave or the very stupid mess with one of the most dangerous forces of nature.\n\nFor one to harness such raw power, one would need very specialized tools and machines.");
        this.pages.add("Lucky for you, you've discovered how to build these machines.");
        this.pages.add(S + "lAir Terminals" + S + "r - Also known as lightning rods. They act as preferential paths for lightning to take when it strikes the ground. Used to charge lightning cells and use " + LCConfig.lpName + ". Made with a rod and a plate.");
        this.pages.add(S + "lLightning Cells" + S + "r - These store energy from lightning strikes, also known as " + LCConfig.lpNameLong + " (" + LCConfig.lpName + "). To store the energy of a strike, an air terminal needs to be directly above the lightning cell. Made with a metal block, 4 metal rods, and 4 redstone.");
        this.pages.add(S + "lLightning Furnaces" + S + "r - These are furnaces that use " + LCConfig.lpName + " instead of solid fuel to smelt items. A lightning furnace smelts items much quicker than a normal furnace, using one " + LCConfig.lpName + " per 2 items burned. Made with an iron cell, 7 cobblestone and a comparator.");
        this.pages.add(S + "lLightning Infusion Table" + S + "r - The mighty Lightning Infusion Table takes the idea of using " + LCConfig.lpName + " to create items to the next level. An item in the center slot gets infused with items in the outer slots along with some " + LCConfig.lpName + ". Made with a gold cell, 7 thunderstone and a comparator.");
        this.pages.add(S + "lElectrostatic Generator" + S + "r - These give you a method of generating lightning, and by extension, " + LCConfig.lpName + " by using blocks to generate a charge. When the charge is full (64C), lightning will strike. Made with an electricium cell, 4 quartz blocks and 4 comparators.");
        this.pages.add(S + "lWireless Power" + S + "r - Like Tesla, you've dreamt of wireless power. Today, you've discovered how to implement it. By creating a single transmitter from your core work area, you can add unlimited receivers nearby. To attune these receivers to the");
        this.pages.add("transmitter, you must craft a Tx/Rx tag, right click on the transmitter, then shift right-click on the receiver. These tags are reusable, and can be crafted back into an empty tag if you wish to mark a different transmitter location.");
        this.pages.add(S + "lEnchantment Reallocator" + S + "r - This can pull enchantments from an item and stick them on another. " + (level < 2 ? "You hypothesize about making such a machine, but you lack the mystical items to do so. Perhaps the answer lies in another realm..." : "Made with 2 chiseled understone bricks, 4 chiseled demonstone bricks, a comparator, enchanting table, and ensorcelled core."));
        this.pages.add("Now that you know the machinery, you should know some of the items and blocks you can create.");
        this.pages.add(S + "lThunderstone" + S + "r - A mysterious dense stone birthed from the depths of the earth. It seems to have semi-liquid properties and resist wear and tear. Four can be made with 4 cobblestone, 4 quartz, and a block of obsidian.");
        this.pages.add(S + "lElectricium" + S + "r - Iron and gold are nice, but you've discovered a way to create a metal better than each of them. Electricium has impressive electral properties and is quite shocking! Can be made by infusing iron with gold, diamond and " + LCConfig.lpName + ".");
        this.pages.add(S + "lDiamond" + S + "r - Yeah, you can make diamond. By infusing coal with two thunderstone and lightning, you can compress it enough to change its structure. Note that this does take a fair bit of " + LCConfig.lpName + ".");
        this.pages.add(S + "lFire" + S + "r - You've discovered that by infusing nether quartz with netherrack and lightning, you can create the primal element.");
        this.pages.add("Other Useful Items:\n\nBy using simple entropy present in infusion, you can create sand from gravel, moss stone from cobble and vines, and dead bushes from saplings. All infusion recipes can be found in the index.");
        this.pages.add("You've also discovered how to make new tools and armor.");
        this.pages.add(S + "lElectricium Tools" + S + "r - These tools are stronger, mine faster, and are more enchantable than vanilla tools, but are quite a bit more expensive to make. Made with electricium rods and ingots.");
        this.pages.add(S + "lElectricium Weapons" + S + "r - These weapons are quite powerful indeed. The sword and hammer have 9 and 10 attack damage respectively, and have latent electrical properties that can be brought out by the Hand of Thor enchantment.");
        this.pages.add(S + "lElectricium Armor" + S + "r - Offers slightly more protection than diamond armor and is more durable. Has latent electrical properties that can be brought out by the Electrostatic Aura enchantment.");
        this.pages.add(S + "lStonebound Swords" + S + "r - Stone doesn't channel " + LCConfig.lpName + " very well, but by forcing " + LCConfig.lpName + " through it, you can bind materials to it. You've discovered that infusing stone swords with soul sand, rotten flesh, feathers, or ender pearls could have some interesting effects...");
        this.pages.add(S + "lMobile " + LCConfig.lpName + S + "r - Through your tinkering with electricium, you've discovered that, when combined with redstone, forms a primitive voltaic pile. By stabilizing this pile with iron rods and a comparator, you have managed to make a functional battery capable of storing a");
        this.pages.add("small amound of " + LCConfig.lpName + ". You've learned that this battery can be charged from a lightning cell via a charging plate. Thus, when charged, this battery enables you to have a source of mobile " + LCConfig.lpName + " when in your inventory. It may just come in handy!");
        this.pages.add(S + "lKinetics" + S + "r - You've discovered an interesting new field of research. It seems that by crafting a golden tool or piece of armor with redstone and an electricium plate somewhat similarly to making a battery, the electrical properties of the gold can be");
        this.pages.add("brought out. By providing these kinetic devices with a mobile source of raw power - lightning, perhaps? - you have found that the item's abilities are amplified many times over: a kinetic sword being over twice as powerful as a golden one, for example. Tools mining");
        this.pages.add("many times faster. Armor giving you invincibility. It seems that no feat is out of your reach now. You have even designed other trinkets that can use mobile " + LCConfig.lpName + " to achieve neat functionalities.");
        if (level <= 0) {
            this.pages.add("Your mind turns to electricium. \"Sure, it's great!\" you say, but at the same time, you wonder if there is a material that offers more...");
            this.pages.add("What if... what if you were to infuse a nether star... with thunderstone... and um... eyes of ender? Surely doing that wouldn't be taboo...!");
        } else {
            this.pageLevel1 = this.pages.size();
            this.pages.add("Your intuition was right. The Skyfather shard is powerful indeed. You can make divine tools and armor by infusing their electricium counterparts with four dust that can be obtained from smelting these shards. Tools made this way have special properties,");
            this.pages.add("while both tools and armor automatically repair themselves. You can also make " + LCConfig.lpName + " cell upgrades by crafting a shard with four redstone.\nThe Skyfather Shard is useful, but the gods are taking notice of your mortal insolence.");
            this.pages.add("They have sent their demon soldiers to deal with you.");
        }
        if (level == 1) {
            this.pages.add("If you were to kill these demons, legend has it you can use their blood to forge a portal to the Underworld...");
        } else if (level > 1) {
            this.pageLevel2 = this.pages.size();
            this.pages.add("You've made your portal to the Underworld. What you see is a vast, dark, and damp cavern filled with spiders, demons, and more. It seems that it is so dark that night vision completely fails.");
            this.pages.add("There are a few naturally generated structures that exist in this evil dimension.");
            this.pages.add(S + "lWater Temples" + S + "r - These seemingly serene temples spawn on the bottom ocean of the Underworld.");
            this.pages.add(S + "lUnderworld Towers" + S + "r - These monolithic structures, found in between heights of 80m and 140m, are home to the Skeletal Guards and Demonfish. The top rooms have untold treasures. The guards drop their bones, which can be used to create high tier items.");
            this.pages.add("By infusing a cell upgrade with one of these bones, along with 2 demon blood and any enchanted book, you have created the ensorcelled core, with which you can make an enchantment reallocator.");
            this.pages.add(S + "lStalactite Ramparts" + S + "r - These garrisons spawn on the top of the Underworld, with cannons aimed at anyone foolish enough to attempt to breach their walls. However, these structures also contain divine treasures.");
            this.pages.add("Demons have been attacking you on sight and spawning around you in the Overworld and other places for some time now. Well, you've made a potion that can do away with that. By infusing a mundane potion with demon blood, 2 guard's bonemeal, and a golden");
            this.pages.add("carrot, you've crafted a brew that keeps these demons at bay. If they're already chasing you down, it won't stop them, however, and it won't stop them from attacking you when you strike them. But it certainly is better than being attacked for like, no reason.");
        }
        this.pageLevel3 = this.pages.size();
        this.addIndex();
        this.bookTotalPages = this.pages.size();
        this.level = level;
    }

    protected void addIndex() {
        String S = "\u00a7";
        int i = 0;
        this.indexPage = this.pages.size();
        this.pages.add(S + "lIndex" + S + "r\nHere you can see all of the infusion recipes that you can make.");
        this.recipePage = this.pages.size();
        LinkedList<ItemStack> results = LPInfusionRecipes.infusion().getIndexList();
        LinkedList<LinkedList> ingredients = new LinkedList<LinkedList>();
        LinkedList<Integer> costs = new LinkedList<Integer>();
        LinkedList<Boolean> damages = new LinkedList<Boolean>();
        for (ItemStack result : results) {
            ingredients.add((LinkedList)LPInfusionRecipes.infusion().getRecipeMap().get(result));
            costs.add((Integer)LPInfusionRecipes.infusion().getCostMap().get(result));
            damages.add((Boolean)LPInfusionRecipes.infusion().getIgnoreDamageMap().get(result));
        }
        for (ItemStack result : results) {
            this.pages.add(result.func_82833_r());
            this.recipePages.add(new RecipePage(this, result, (LinkedList)ingredients.get(i), (Integer)costs.get(i), (Boolean)damages.get(i++)));
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(4, this.field_146294_l / 2 - 49, 196 + (this.level + 1) * 24, 98, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.level1Ref = new GuiButton(5, this.field_146294_l / 2 - 80, 196, 160, 20, "Skyfather Reference");
        this.level2Ref = new GuiButton(6, this.field_146294_l / 2 - 80, 220, 160, 20, "Underworld Reference");
        this.level3Ref = new GuiButton(7, this.field_146294_l / 2 - 80, 244, 160, 20, "Transcendental Reference");
        this.indexRef = new GuiButton(8, this.field_146294_l / 2 - 49, 196 + this.level * 24, 98, 20, "Index");
        this.field_146292_n.add(this.buttonDone);
        if (this.level > 0) {
            this.field_146292_n.add(this.level1Ref);
        }
        if (this.level > 1) {
            this.field_146292_n.add(this.level2Ref);
        }
        if (this.level > 2) {
            this.field_146292_n.add(this.level3Ref);
        }
        this.field_146292_n.add(this.indexRef);
        int offsetFromScreenLeft = (this.field_146294_l - 192) / 2;
        int inOff = 20;
        this.buttonNextPage = new NextPageButton(0, offsetFromScreenLeft + 120 - inOff, 156, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(1, offsetFromScreenLeft + 38 + inOff, 156, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonLastPage = new NextPageButton(2, offsetFromScreenLeft + 145 - inOff, 156, true, true);
        this.field_146292_n.add(this.buttonLastPage);
        this.buttonFirstPage = new NextPageButton(3, offsetFromScreenLeft + 13 + inOff, 156, false, true);
        this.field_146292_n.add(this.buttonFirstPage);
    }

    public void func_73876_c() {
        this.buttonDone.field_146125_m = true;
        this.buttonNextPage.field_146125_m = this.currPage < this.bookTotalPages - 1;
        this.buttonPreviousPage.field_146125_m = this.currPage > 0;
    }

    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.currPage == 0) {
            mc.func_110434_K().func_110577_a(bookCoverTexture);
        } else if (this.currPage < this.recipePage) {
            mc.func_110434_K().func_110577_a(bookMainTexture);
        } else {
            mc.func_110434_K().func_110577_a(bookRecipeTexture);
        }
        int offsetFromScreenLeft = (this.field_146294_l - 192) / 2;
        this.func_73729_b(offsetFromScreenLeft, 2, 0, 0, 192, 192);
        String stringPageIndicator = I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.currPage + 1, this.bookTotalPages});
        int widthOfString = this.field_146289_q.func_78256_a(stringPageIndicator);
        this.field_146289_q.func_78276_b(stringPageIndicator, offsetFromScreenLeft - widthOfString + 192 - 44, 18, 0);
        this.field_146289_q.func_78279_b(this.pages.get(this.currPage), offsetFromScreenLeft + 36, 34, 116, 0);
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
        if (this.currPage >= this.recipePage) {
            this.recipePages.get(this.currPage - this.recipePage).drawPage(offsetFromScreenLeft, 2);
        }
    }

    protected void func_146273_a(int parMouseX, int parMouseY, int parLastButtonClicked, long parTimeSinceMouseClick) {
    }

    protected void func_146284_a(GuiButton parButton) {
        if (parButton == this.buttonDone) {
            this.field_146297_k.func_147108_a((GuiScreen)null);
        } else if (parButton == this.buttonNextPage) {
            if (this.currPage < this.bookTotalPages - 1) {
                ++this.currPage;
            }
        } else if (parButton == this.buttonPreviousPage) {
            if (this.currPage > 0) {
                --this.currPage;
            }
        } else if (parButton == this.buttonFirstPage) {
            this.currPage = 0;
        } else if (parButton == this.buttonLastPage) {
            this.currPage = this.bookTotalPages - 1;
        } else if (parButton == this.level1Ref) {
            this.currPage = this.pageLevel1;
        } else if (parButton == this.level2Ref) {
            this.currPage = this.pageLevel2;
        } else if (parButton == this.level3Ref) {
            this.currPage = this.pageLevel3;
        } else if (parButton == this.indexRef) {
            this.currPage = this.indexPage;
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void drawItemStack(ItemStack stack, int x, int y) {
        if (stack != null && stack.func_77973_b() != null) {
            GL11.glDisable((int)2896);
            if (stack.func_77973_b() instanceof ItemBlock) {
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
            }
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, x, y);
            GL11.glDisable((int)32826);
            GL11.glEnable((int)2896);
            String stackSize = stack.field_77994_a > 1 ? "" + stack.field_77994_a : "";
            field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, x, y, stackSize);
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        if (stack != null && stack.func_77973_b() != null) {
            super.func_146285_a(stack, x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        private final boolean isNextButton;
        private final boolean isTurbo;

        public NextPageButton(int parButtonId, int parPosX, int parPosY, boolean parIsNextButton, boolean parIsTurbo) {
            super(parButtonId, parPosX, parPosY, 23, 13, "");
            this.isNextButton = parIsNextButton;
            this.isTurbo = parIsTurbo;
        }

        public void func_146112_a(Minecraft mc, int parX, int parY) {
            if (this.field_146125_m) {
                boolean isButtonPressed = parX >= this.field_146128_h && parY >= this.field_146129_i && parX < this.field_146128_h + this.field_146120_f && parY < this.field_146129_i + this.field_146121_g;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(bookMainTexture);
                int textureX = this.isTurbo ? 46 : 0;
                int textureY = 192;
                if (isButtonPressed) {
                    textureX += 23;
                }
                if (!this.isNextButton) {
                    textureY += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, 23, 13);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class RecipePage {
        private static final Random rand = new Random();
        private static final int maxMetaTicks = 1;
        private static final int maxRecTicks = 50;
        private double metaTicks = 2.0;
        private double recTicks = 51.0;
        private long lasttime;
        private GuiLightningBook book;
        private ItemStack result;
        private LinkedList<ItemStack> ingredients;
        private int cost;
        private boolean ignoreDamage;
        private int[] itemRotate;
        private ItemStack[] displayStack;
        private int dispDamage = 0;
        private AxisAlignedBB resultBox;
        private LinkedList<AxisAlignedBB> ingredientBoxes;

        public RecipePage(GuiLightningBook book, ItemStack result, LinkedList<ItemStack> ingredients, int cost, boolean ignoreDamage) {
            this.book = book;
            this.result = result.func_77946_l();
            this.ingredients = ingredients;
            this.cost = cost;
            this.ignoreDamage = ignoreDamage;
            this.lasttime = Minecraft.func_71386_F();
        }

        public void drawPage(int bookX, int bookY) {
            this.book.field_146289_q.func_78279_b(this.cost + " " + LCConfig.lpName + " needed for this infusion", bookX + 36, 120, 116, 0);
            int xoff = 3;
            int yoff = -16;
            bookX += xoff;
            bookY += yoff;
            if (this.ignoreDamage && this.metaTicks > 1.0) {
                ++this.dispDamage;
                if (this.dispDamage > this.result.func_77958_k()) {
                    this.dispDamage = Math.min(1, this.result.func_77958_k());
                }
                this.metaTicks = 0.0;
            }
            this.metaTicks += (double)(Minecraft.func_71386_F() - this.lasttime) / 50.0;
            this.resultBox = AxisAlignedBB.func_72330_a((double)(bookX + 120), (double)(bookY + 89), (double)0.0, (double)(bookX + 120 + 16), (double)(bookY + 89 + 16), (double)0.0);
            if (this.result.func_77958_k() > 0) {
                this.result.func_77964_b(this.dispDamage);
            }
            this.book.drawItemStack(this.result, (int)this.resultBox.field_72340_a, (int)this.resultBox.field_72338_b);
            this.ingredientBoxes = new LinkedList();
            this.ingredientBoxes.add(AxisAlignedBB.func_72330_a((double)(bookX + 59), (double)(bookY + 89), (double)0.0, (double)(bookX + 59 + 16), (double)(bookY + 89 + 16), (double)0.0));
            this.ingredientBoxes.add(AxisAlignedBB.func_72330_a((double)(bookX + 59), (double)(bookY + 69), (double)0.0, (double)(bookX + 59 + 16), (double)(bookY + 69 + 16), (double)0.0));
            this.ingredientBoxes.add(AxisAlignedBB.func_72330_a((double)(bookX + 79), (double)(bookY + 89), (double)0.0, (double)(bookX + 79 + 16), (double)(bookY + 89 + 16), (double)0.0));
            this.ingredientBoxes.add(AxisAlignedBB.func_72330_a((double)(bookX + 59), (double)(bookY + 109), (double)0.0, (double)(bookX + 59 + 16), (double)(bookY + 109 + 16), (double)0.0));
            this.ingredientBoxes.add(AxisAlignedBB.func_72330_a((double)(bookX + 39), (double)(bookY + 89), (double)0.0, (double)(bookX + 39 + 16), (double)(bookY + 89 + 16), (double)0.0));
            boolean change = this.recTicks > 50.0;
            Integer[] shuffle = new Integer[]{1, 2, 3, 4};
            if (change) {
                Collections.shuffle(Arrays.asList(shuffle));
                this.itemRotate = new int[this.ingredientBoxes.size()];
            }
            this.displayStack = new ItemStack[this.ingredientBoxes.size()];
            for (int i = 0; i < this.ingredientBoxes.size(); ++i) {
                if (change) {
                    this.itemRotate[i] = i > 0 ? shuffle[i - 1] : 0;
                    this.recTicks = 0.0;
                }
                if (this.ingredients.get(this.itemRotate[i]) == null) continue;
                this.displayStack[i] = this.ingredients.get(this.itemRotate[i]);
                if (this.displayStack[i].func_77958_k() > 0) {
                    this.displayStack[i].func_77964_b(Math.min(this.displayStack[i].func_77958_k(), this.dispDamage));
                }
                this.book.drawItemStack(this.displayStack[i], (int)this.ingredientBoxes.get((int)i).field_72340_a, (int)this.ingredientBoxes.get((int)i).field_72338_b);
            }
            this.recTicks += (double)(Minecraft.func_71386_F() - this.lasttime) / 50.0;
            this.lasttime = Minecraft.func_71386_F();
            this.drawTooltips();
        }

        public void drawTooltips() {
            if (LCMisc.mouseColl(this.book.mouseX, this.book.mouseY, this.resultBox)) {
                this.book.func_146285_a(this.result, this.book.mouseX, this.book.mouseY);
            }
            for (int i = 0; i < this.ingredientBoxes.size(); ++i) {
                if (!LCMisc.mouseColl(this.book.mouseX, this.book.mouseY, this.ingredientBoxes.get(i))) continue;
                this.book.func_146285_a(this.displayStack[i], this.book.mouseX, this.book.mouseY);
            }
        }
    }
}

