/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.handler;

import com.LightningCraft.achievements.LCAchievements;
import com.LightningCraft.effects.Effect;
import com.LightningCraft.enchantments.LCEnchantments;
import com.LightningCraft.handler.LivingSoulStealEvent;
import com.LightningCraft.items.KineticArmor;
import com.LightningCraft.items.LCItems;
import com.LightningCraft.items.LPBattery;
import com.LightningCraft.items.SkyArmor;
import com.LightningCraft.lib.RefMisc;
import com.LightningCraft.util.ArmorHelper;
import com.LightningCraft.util.SkyUtils;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LCArmorEvents {
    private final Random random = new Random();
    static final float walkBoost = 0.31789f;
    static final float stepBoost = 1.01789f;
    static final UUID speedBootsID = UUID.fromString("caac9ed0-a4a7-42c1-af76-0482f06f34d8");

    @SubscribeEvent
    public void onSoulSteal(LivingSoulStealEvent event) {
        if (RefMisc.DEBUG) {
            System.out.println("Soul steal event fired");
        }
        this.onKineticArmorHurt(event);
    }

    @SubscribeEvent
    public void onKineticArmorHurt(LivingHurtEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer && event.ammount > 0.0f) {
            if (RefMisc.DEBUG) {
                System.out.println("Player hurt event fired, source: " + event.source.func_76355_l());
            }
            EntityPlayer player = (EntityPlayer)event.entity;
            KineticArmor armor = (KineticArmor)LCItems.kineticHelm;
            ItemStack helm = player.func_71124_b(4);
            ItemStack chest = player.func_71124_b(3);
            ItemStack legs = player.func_71124_b(2);
            ItemStack boots = player.func_71124_b(1);
            boolean fullSet = ArmorHelper.entityHasFullArmor((EntityLivingBase)player, KineticArmor.class);
            if (RefMisc.DEBUG) {
                System.out.println("Vanilla damage: " + event.ammount);
            }
            if (fullSet) {
                if (RefMisc.DEBUG) {
                    System.out.println("Wearing full set");
                }
                double cost = event.source == LivingSoulStealEvent.soulSteal ? 3.0 : 0.5 + (double)event.ammount / 5.0;
                double available = armor.getAvailablePower(player);
                ItemStack battery = armor.getLPSource(player, cost);
                if (battery != null) {
                    int armorcost;
                    event.setCanceled(true);
                    if (RefMisc.DEBUG) {
                        System.out.println("Damage avoided");
                    }
                    if (RefMisc.DEBUG) {
                        System.out.println("Reducing battery power by " + cost);
                    }
                    LPBattery.addStoredPower(battery, -cost);
                    if (event.source == LivingSoulStealEvent.soulSteal) {
                        if (RefMisc.DEBUG) {
                            System.out.println("Protected against a soul steal attempt");
                        }
                        armorcost = 1;
                    } else {
                        armorcost = (int)(0.5 + (double)event.ammount / 10.0);
                    }
                    SkyUtils.damageStack(armorcost, helm, (EntityLivingBase)player, 4);
                    SkyUtils.damageStack(armorcost, chest, (EntityLivingBase)player, 3);
                    SkyUtils.damageStack(armorcost, legs, (EntityLivingBase)player, 2);
                    SkyUtils.damageStack(armorcost, boots, (EntityLivingBase)player, 1);
                } else if (available > 0.0 && battery == null && (battery = armor.getLPSource(player, available)) != null) {
                    int armorcost;
                    if (RefMisc.DEBUG) {
                        System.out.println("Draining battery");
                    }
                    LPBattery.setStoredPower(battery, 0.0);
                    if (event.source == LivingSoulStealEvent.soulSteal) {
                        if (RefMisc.DEBUG) {
                            System.out.println("Protected against a soul steal attempt");
                        }
                        armorcost = 1;
                    } else {
                        armorcost = (int)(0.5 + (double)event.ammount / 10.0);
                    }
                    event.ammount = (float)((double)event.ammount - 5.0 * available);
                    if (RefMisc.DEBUG) {
                        System.out.println("Reduced damage: " + event.ammount);
                    }
                    SkyUtils.damageStack(armorcost, helm, (EntityLivingBase)player, 4);
                    SkyUtils.damageStack(armorcost, chest, (EntityLivingBase)player, 3);
                    SkyUtils.damageStack(armorcost, legs, (EntityLivingBase)player, 2);
                    SkyUtils.damageStack(armorcost, boots, (EntityLivingBase)player, 1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onSkyfatherBootsWear(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            IAttributeInstance attributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier mod = new AttributeModifier(speedBootsID, "skyBootsSpeedModifier", (double)0.31789f, 2).func_111168_a(false);
            if (player.func_71124_b(1) != null && player.func_71124_b(1).func_77973_b() == LCItems.skyBoots) {
                if (attributeinstance.func_111127_a(speedBootsID) == null) {
                    attributeinstance.func_111121_a(mod);
                }
                player.field_70138_W = !player.func_70093_af() ? 1.01789f : 0.5f;
            } else {
                if (attributeinstance.func_111127_a(speedBootsID) != null) {
                    attributeinstance.func_111124_b(mod);
                }
                if (player.field_70138_W == 1.01789f) {
                    player.field_70138_W = 0.5f;
                }
            }
        }
    }

    @SubscribeEvent
    public void onSkyfatherFallPreDamage(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack boots;
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer && event.source == DamageSource.field_76379_h && (boots = (player = (EntityPlayer)event.entity).func_71124_b(1)) != null && boots.func_77973_b() == LCItems.skyBoots && event.ammount / 2.0f < 1.0f) {
            boots.func_77972_a(1, (EntityLivingBase)player);
            event.setCanceled(true);
            if (RefMisc.DEBUG) {
                System.out.println("Fall damage averted");
            }
        }
    }

    @SubscribeEvent
    public void onSkyfatherFallDamage(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack boots;
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer && event.source == DamageSource.field_76379_h && (boots = (player = (EntityPlayer)event.entity).func_71124_b(1)) != null && boots.func_77973_b() == LCItems.skyBoots) {
            event.ammount /= 2.0f;
            boots.func_77972_a((int)(event.ammount / 1.5f) + 1, (EntityLivingBase)player);
            if (RefMisc.DEBUG) {
                System.out.println("Fall damage halfed");
            }
        }
    }

    @SubscribeEvent
    public void onElecAuraHurt(LivingHurtEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (event.source.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)event.source.func_76346_g();
                if (!player.field_70170_p.field_72995_K && !attacker.func_85032_ar()) {
                    LinkedList<Integer> ench = new LinkedList<Integer>();
                    ItemStack helm = player.func_71124_b(4);
                    ItemStack chest = player.func_71124_b(3);
                    ItemStack legs = player.func_71124_b(2);
                    ItemStack boots = player.func_71124_b(1);
                    int lv = 0;
                    int a = 0;
                    int damageHelm = 0;
                    int damageChest = 0;
                    int damageLegs = 0;
                    int damageBoots = 0;
                    if (helm != null) {
                        damageHelm = EnchantmentHelper.func_77506_a((int)LCEnchantments.elecAura.field_77352_x, (ItemStack)helm);
                        ench.add(damageHelm);
                        if (helm.func_77973_b() instanceof SkyArmor) {
                            ++a;
                        }
                    }
                    if (chest != null) {
                        damageChest = EnchantmentHelper.func_77506_a((int)LCEnchantments.elecAura.field_77352_x, (ItemStack)chest);
                        ench.add(damageChest);
                        if (chest.func_77973_b() instanceof SkyArmor) {
                            ++a;
                        }
                    }
                    if (legs != null) {
                        damageLegs = EnchantmentHelper.func_77506_a((int)LCEnchantments.elecAura.field_77352_x, (ItemStack)legs);
                        ench.add(damageLegs);
                        if (legs.func_77973_b() instanceof SkyArmor) {
                            ++a;
                        }
                    }
                    if (boots != null) {
                        damageBoots = EnchantmentHelper.func_77506_a((int)LCEnchantments.elecAura.field_77352_x, (ItemStack)boots);
                        ench.add(damageBoots);
                        if (boots.func_77973_b() instanceof SkyArmor) {
                            ++a;
                        }
                    }
                    Iterator iterator = ench.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        lv += i;
                    }
                    if (lv > 0 && this.random.nextDouble() <= (double)(lv * 2) / 100.0) {
                        Effect.lightning((Entity)attacker, false);
                        if (damageHelm > 0) {
                            helm.func_77972_a(4 * damageHelm, (EntityLivingBase)player);
                        }
                        if (damageChest > 0) {
                            chest.func_77972_a(4 * damageChest, (EntityLivingBase)player);
                        }
                        if (damageLegs > 0) {
                            legs.func_77972_a(4 * damageLegs, (EntityLivingBase)player);
                        }
                        if (damageBoots > 0) {
                            boots.func_77972_a(4 * damageBoots, (EntityLivingBase)player);
                        }
                        if (a == 4 && lv == 12) {
                            player.func_71064_a((StatBase)LCAchievements.skyfatherAscension, 1);
                        }
                    }
                }
            }
        }
    }
}

