/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.recipes;

import com.LightningCraft.blocks.LCBlocks;
import com.LightningCraft.items.LCItems;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LPInfusionRecipes {
    private static final LPInfusionRecipes LPI_BASE = new LPInfusionRecipes();
    private static final int ANYDAMAGE = Integer.MAX_VALUE;
    private static final boolean defaultIgnoreDamageState = true;
    private Map infusionList = new HashMap();
    private Map infusionCost = new HashMap();
    private Map infusionIgnoreDamage = new HashMap();
    private Map damageList = new HashMap();
    private Map quickList = new HashMap();
    private int recipeIndex = 0;
    private LinkedList<ItemStack> indexList = new LinkedList();

    public static LPInfusionRecipes infusion() {
        return LPI_BASE;
    }

    private LPInfusionRecipes() {
        this.addDefaultRecipes();
    }

    private void addDefaultRecipes() {
        this.addRecipe(new ItemStack(LCItems.elecIngot, 1), Items.field_151042_j, Items.field_151043_k, Items.field_151045_i, null, null, 15);
        this.addRecipe(new ItemStack(LCBlocks.metalBlock, 1), Item.func_150898_a((Block)Blocks.field_150339_S), Item.func_150898_a((Block)Blocks.field_150340_R), Item.func_150898_a((Block)Blocks.field_150484_ah), null, null, 135);
        int specialCost = 60;
        this.addRecipe(new ItemStack(LCItems.soulSword), Items.field_151052_q, Item.func_150898_a((Block)Blocks.field_150425_aM), Item.func_150898_a((Block)Blocks.field_150425_aM), Item.func_150898_a((Block)Blocks.field_150425_aM), Item.func_150898_a((Block)Blocks.field_150425_aM), specialCost);
        this.addRecipe(new ItemStack(LCItems.zombieSword), Items.field_151052_q, Items.field_151078_bh, Items.field_151078_bh, Items.field_151078_bh, Items.field_151078_bh, specialCost);
        this.addRecipe(new ItemStack(LCItems.featherSword), Items.field_151052_q, Items.field_151008_G, Items.field_151008_G, Items.field_151008_G, Items.field_151008_G, specialCost);
        this.addRecipe(new ItemStack(LCItems.enderSword), Items.field_151052_q, Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi, Items.field_151079_bi, specialCost);
        this.addRecipe(new ItemStack(LCItems.skyItem, 2), Items.field_151156_bN, Item.func_150898_a((Block)LCBlocks.thunderstone), Item.func_150898_a((Block)LCBlocks.thunderstone), Items.field_151061_bv, Items.field_151061_bv, 50);
        this.addRecipe(new ItemStack(LCItems.skySword, 1), new ItemStack(LCItems.elecSword), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 75, false);
        this.addRecipe(new ItemStack(LCItems.skyHammer, 1), new ItemStack(LCItems.elecHammer), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 100, false);
        this.addRecipe(new ItemStack(LCItems.skyPick, 1), new ItemStack(LCItems.elecPick), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 50, false);
        this.addRecipe(new ItemStack(LCItems.skyAxe, 1), new ItemStack(LCItems.elecAxe), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 50, false);
        this.addRecipe(new ItemStack(LCItems.skySpade, 1), new ItemStack(LCItems.elecSpade), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 45, false);
        this.addRecipe(new ItemStack(LCItems.skyHoe, 1), new ItemStack(LCItems.elecHoe), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 40, false);
        this.addRecipe(new ItemStack(LCItems.skyHelm, 1), new ItemStack(LCItems.elecHelm), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 50, false);
        this.addRecipe(new ItemStack(LCItems.skyChest, 1), new ItemStack(LCItems.elecChest), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 100, false);
        this.addRecipe(new ItemStack(LCItems.skyLegs, 1), new ItemStack(LCItems.elecLegs), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 75, false);
        this.addRecipe(new ItemStack(LCItems.skyBoots, 1), new ItemStack(LCItems.elecBoots), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 50, false);
        this.addRecipe(new ItemStack(LCBlocks.airTerm, 1, 7), new ItemStack(LCBlocks.airTerm, 1, 6), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 75);
        this.addRecipe(new ItemStack(LCBlocks.skyCell, 1), new ItemStack(LCBlocks.elecCell), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), new ItemStack(LCItems.skyItem, 1, 1), 200);
        this.addRecipe(new ItemStack(LCItems.underworldCharge, 1), Items.field_151059_bz, LCItems.demonBlood, null, null, null, 25);
        this.addRecipe(new ItemStack(LCBlocks.demonstone, 1), Item.func_150898_a((Block)LCBlocks.thunderstone), LCItems.demonBlood, LCItems.demonBlood, null, null, 15);
        this.addRecipe(new ItemStack(LCItems.ensorcelledCore, 1), LCItems.lpCellUpgrade, LCItems.demonBlood, LCItems.demonBlood, LCItems.underworldBone, (Item)Items.field_151134_bR, 100);
        this.addRecipe(new ItemStack((Item)LCItems.lcPotion, 1, 0), new ItemStack((Item)Items.field_151068_bn, 1, 8192), new ItemStack(LCItems.demonBlood), new ItemStack(LCItems.underworldBonemeal), new ItemStack(LCItems.underworldBonemeal), new ItemStack(Items.field_151150_bK), 30);
        this.addRecipe(new ItemStack((Item)LCItems.lcPotion, 1, 2048), new ItemStack((Item)LCItems.lcPotion, 1, 0), new ItemStack(Items.field_151137_ax), new ItemStack((Item)Items.field_151068_bn, 1, 8206), null, null, 15);
        this.addRecipe(new ItemStack(Items.field_151045_i, 1), Items.field_151044_h, Item.func_150898_a((Block)LCBlocks.thunderstone), Item.func_150898_a((Block)LCBlocks.thunderstone), Items.field_151016_H, Items.field_151016_H, 25);
        this.addRecipe(new ItemStack((Block)Blocks.field_150480_ab, 2), Items.field_151128_bU, Item.func_150898_a((Block)Blocks.field_150424_aL), Item.func_150898_a((Block)Blocks.field_150424_aL), Item.func_150898_a((Block)Blocks.field_150424_aL), Item.func_150898_a((Block)Blocks.field_150424_aL), 10);
        this.addRecipe(new ItemStack(Blocks.field_150341_Y, 1), Item.func_150898_a((Block)Blocks.field_150347_e), Item.func_150898_a((Block)Blocks.field_150395_bd), null, null, null, 5);
        this.addRecipe(new ItemStack((Block)Blocks.field_150354_m, 1), Item.func_150898_a((Block)Blocks.field_150351_n), Items.field_151145_ak, Items.field_151145_ak, null, null, 5);
        this.addRecipe(new ItemStack((Block)Blocks.field_150330_I), Item.func_150898_a((Block)Blocks.field_150345_g), Item.func_150898_a((Block)Blocks.field_150354_m), null, null, null, 5);
    }

    public Map getRecipeMap() {
        return this.infusionList;
    }

    public Map getCostMap() {
        return this.infusionCost;
    }

    public Map getIgnoreDamageMap() {
        return this.infusionIgnoreDamage;
    }

    public Map getItemDamageMap() {
        return this.damageList;
    }

    public LinkedList<ItemStack> getIndexList() {
        return this.indexList;
    }

    public void addRecipe(ItemStack create, Item infuse, Item item1, Item item2, Item item3, Item item4, int cost) {
        this.addRecipe(create, infuse, item1, item2, item3, item4, cost, true);
    }

    public void addRecipe(ItemStack create, Item infuse, Item item1, Item item2, Item item3, Item item4, int cost, boolean ignoreDamage) {
        ItemStack stackInfuse = infuse == null ? null : new ItemStack(infuse);
        ItemStack stack1 = item1 == null ? null : new ItemStack(item1);
        ItemStack stack2 = item2 == null ? null : new ItemStack(item2);
        ItemStack stack3 = item3 == null ? null : new ItemStack(item3);
        ItemStack stack4 = item4 == null ? null : new ItemStack(item4);
        this.addRecipe(create, stackInfuse, stack1, stack2, stack3, stack4, cost, ignoreDamage);
    }

    public void addRecipe(ItemStack create, ItemStack infuse, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4, int cost) {
        this.addRecipe(create, infuse, stack1, stack2, stack3, stack4, cost, true);
    }

    public void addRecipe(ItemStack create, ItemStack infuse, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4, int cost, boolean ignoreDamage) {
        this.putLists(create, infuse, stack1, stack2, stack3, stack4, cost, ignoreDamage);
    }

    private void putLists(ItemStack itemstack, ItemStack infuse, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4, int cost, boolean ignoreDamage) {
        LinkedList<ItemStack> iList = new LinkedList<ItemStack>();
        iList.add(stack1);
        iList.add(stack2);
        iList.add(stack3);
        iList.add(stack4);
        iList.addFirst(infuse);
        this.infusionList.put(itemstack, iList);
        this.infusionCost.put(itemstack, cost);
        this.infusionIgnoreDamage.put(itemstack, ignoreDamage);
        this.quickList.put(infuse.func_77973_b(), itemstack);
        int damage = ignoreDamage && infuse.func_77958_k() > 0 ? Integer.MAX_VALUE : infuse.func_77960_j();
        this.damageList.put(itemstack, damage);
        this.indexList.add(itemstack);
    }

    public int getInfusionCost(ItemStack result) {
        Map.Entry entry;
        Iterator iterator = this.infusionCost.entrySet().iterator();
        if (result == null) {
            return -2;
        }
        do {
            if (iterator.hasNext()) continue;
            return -1;
        } while (((ItemStack)(entry = iterator.next()).getKey()).func_77973_b() != result.func_77973_b());
        int thecost = (Integer)entry.getValue();
        return thecost;
    }

    public ItemStack getInfusionResult(ItemStack infuse, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
        if (infuse == null) {
            return null;
        }
        ItemStack expectedResult = this.getBaseResult(infuse);
        boolean ignoreDamage = this.infusionIgnoreDamage.containsKey(expectedResult) ? (Boolean)this.infusionIgnoreDamage.get(expectedResult) : true;
        ItemStack result = this.getInfusionResultBase(infuse, stack1, stack2, stack3, stack4);
        if (result == null) {
            return null;
        }
        if (ignoreDamage) {
            result.func_77964_b(infuse.func_77960_j());
        }
        return result;
    }

    private ItemStack getInfusionResultBase(ItemStack infuse, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
        Map.Entry entry;
        Iterator iterator = this.infusionList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.canBeInfused(infuse, stack1, stack2, stack3, stack4, (LinkedList)(entry = iterator.next()).getValue()));
        ItemStack result = (ItemStack)entry.getKey();
        return result;
    }

    public ItemStack getBaseResult(ItemStack infuse) {
        int compdamage;
        Boolean ignoreDamage;
        int damage;
        Item infuseItem = infuse.func_77973_b();
        ItemStack result = (ItemStack)this.quickList.get(infuseItem);
        if (result != null && ((damage = (ignoreDamage = Boolean.valueOf((Boolean)this.infusionIgnoreDamage.get(result) != false && infuse.func_77958_k() > 0)) != false ? Integer.MAX_VALUE : infuse.func_77960_j()) != (compdamage = ((Integer)this.damageList.get(result)).intValue()) || infuse.func_77958_k() > 0 && !ignoreDamage.booleanValue() && infuse.func_77960_j() > 0)) {
            return null;
        }
        return result;
    }

    private LinkedList<ItemStack> getInfusers(ItemStack infuse) {
        if (infuse == null) {
            return null;
        }
        ItemStack output = this.getBaseResult(infuse);
        if (output == null) {
            return null;
        }
        LinkedList list = (LinkedList)this.infusionList.get(output);
        list.removeFirst();
        return list;
    }

    private boolean canBeInfused(ItemStack infuse, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4, LinkedList<ItemStack> stackList) {
        if (infuse != null && infuse.func_77973_b() == stackList.get(0).func_77973_b()) {
            LinkedList<Item> localList = new LinkedList<Item>();
            for (ItemStack s : stackList) {
                Item add = s == null ? null : s.func_77973_b();
                localList.add(add);
            }
            localList.removeFirst();
            int compnulls = 0;
            for (int i = 0; i < localList.size(); ++i) {
                if (localList.get(i) != null) continue;
                ++compnulls;
            }
            int nulls = 0;
            if (stack1 != null) {
                boolean ok = localList.remove(stack1.func_77973_b());
                if (!ok) {
                    return false;
                }
            } else {
                ++nulls;
            }
            if (stack2 != null) {
                boolean ok = localList.remove(stack2.func_77973_b());
                if (!ok) {
                    return false;
                }
            } else {
                ++nulls;
            }
            if (stack3 != null) {
                boolean ok = localList.remove(stack3.func_77973_b());
                if (!ok) {
                    return false;
                }
            } else {
                ++nulls;
            }
            if (stack4 != null) {
                boolean ok = localList.remove(stack4.func_77973_b());
                if (!ok) {
                    return false;
                }
            } else {
                ++nulls;
            }
            if (nulls != compnulls) {
                return false;
            }
            System.out.println("canBeInfused");
            return true;
        }
        return false;
    }
}

