/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.tileentities;

import com.LightningCraft.tileentities.TileEntityLPReceiver;
import com.LightningCraft.tileentities.TileEntityLPTransmitter;
import com.LightningCraft.tileentities.TileEntityLightningCell;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityLPUser
extends TileEntity {
    public TileEntityLightningCell tileLPCell;
    public double cellPower;
    public double maxPower;
    private double efficiency;

    protected boolean hasLPCell() {
        TileEntity tile;
        int z;
        int y;
        int x;
        for (x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            for (y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                for (z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || (tile = this.field_145850_b.func_147438_o(x, y, z)) == null || !(tile instanceof TileEntityLightningCell)) continue;
                    this.tileLPCell = (TileEntityLightningCell)tile;
                    this.cellPower = this.tileLPCell.storedPower;
                    this.maxPower = this.tileLPCell.maxPower;
                    this.setEfficiency(1.0);
                    return true;
                }
            }
        }
        if (!(this instanceof TileEntityLPTransmitter)) {
            for (x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
                for (y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                    for (z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || (tile = this.field_145850_b.func_147438_o(x, y, z)) == null || !(tile instanceof TileEntityLPReceiver)) continue;
                        TileEntityLPReceiver rx = (TileEntityLPReceiver)tile;
                        if (rx.tx == null || !rx.tx.hasLPCell()) continue;
                        this.tileLPCell = rx.tx.tileLPCell;
                        this.cellPower = this.tileLPCell.storedPower;
                        this.maxPower = this.tileLPCell.maxPower;
                        this.setEfficiency(rx.efficiency);
                        return true;
                    }
                }
            }
        }
        this.tileLPCell = null;
        this.cellPower = 0.0;
        this.maxPower = -1.0;
        this.setEfficiency(-1.0);
        return false;
    }

    protected boolean isRemotelyPowered() {
        return this.getEfficiency() < 1.0;
    }

    protected boolean canDrawCellPower(double amount) {
        return this.getEfficiency() > 0.0 && this.cellPower >= amount / this.getEfficiency() && this.tileLPCell.storedPower >= amount / this.getEfficiency();
    }

    public double getActualNeededPower(double amount) {
        if (this.getEfficiency() > 0.0) {
            return amount / this.getEfficiency();
        }
        return Double.NaN;
    }

    protected boolean drawCellPower(double amount) {
        if (this.canDrawCellPower(amount)) {
            this.cellPower -= amount / this.getEfficiency();
            this.tileLPCell.storedPower -= amount / this.getEfficiency();
            return true;
        }
        return false;
    }

    public double getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
    }
}

