/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.util;

import com.LightningCraft.config.LCConfig;
import com.LightningCraft.items.LCItems;
import com.LightningCraft.items.LPBattery;
import com.LightningCraft.util.LCMisc;
import com.LightningCraft.util.LCText;
import com.LightningCraft.util.SkyUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class InventoryLP {
    public static final double lpRepairSpeedModifier = 2.25;
    public static final double lpBreakUsage = 0.2;
    public static final double lpPowerUsage = 0.02;
    public static final double lpStrikeUsage = 0.2;

    public static boolean addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4, LPCharge charge) {
        list.add(LCText.getInventoryLPUserLore());
        boolean charged = InventoryLP.hasLPSource(player);
        charge.setCharge(InventoryLP.getAvailablePower(player));
        String lpLore = "\u00a7" + (charged ? (charge.getCharge() > 0.0 ? "b" + LCText.df.format(charge.getCharge()) : "cNo") + " " + LCConfig.lpName + " available" : "cNo " + LCConfig.lpName + " Source Found");
        list.add(lpLore);
        return charged;
    }

    public static double getAvailablePower(EntityPlayer user) {
        if (user != null && user.field_71071_by.func_146028_b(LCItems.lpBattery)) {
            int invPos = 0;
            double power = 0.0;
            LinkedList<Integer> avoid = new LinkedList<Integer>();
            while ((invPos = LCMisc.posInInventory(user, LCItems.lpBattery, avoid)) >= 0) {
                if (invPos < 0) continue;
                ItemStack battery = user.field_71071_by.field_70462_a[invPos];
                power = Math.max(power, LPBattery.getStoredPower(battery));
                avoid.add(invPos);
            }
            return power;
        }
        return 0.0;
    }

    public static boolean hasLPSource(EntityPlayer user) {
        return InventoryLP.getLPSource(user, 0.0) != null;
    }

    public static ItemStack getLPSource(EntityPlayer user, double lpNeeded) {
        if (user != null && user.field_71071_by.func_146028_b(LCItems.lpBattery)) {
            int invPos = 0;
            LinkedList<Integer> avoid = new LinkedList<Integer>();
            while ((invPos = LCMisc.posInInventory(user, LCItems.lpBattery, avoid)) >= 0) {
                if (invPos < 0) continue;
                ItemStack battery = user.field_71071_by.field_70462_a[invPos];
                if (LPBattery.getStoredPower(battery) >= lpNeeded) {
                    return battery;
                }
                avoid.add(invPos);
            }
        }
        return null;
    }

    public static boolean autoRepairItem(ItemStack stack, World world, Entity player, double repairCost) {
        ItemStack battery = InventoryLP.getLPSource((EntityPlayer)player, repairCost);
        if (battery != null && SkyUtils.autoRepairItemNotInUse(stack, world, player, 2.25)) {
            LPBattery.addStoredPower(battery, -repairCost);
            return true;
        }
        return false;
    }

    public static void hitEntity(ItemStack stack, EntityLivingBase entity, EntityLivingBase user, double normalDamage, boolean maxDamage) {
        if (user instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)user;
            DamageSource source = DamageSource.func_76365_a((EntityPlayer)player);
            float damage = 0.0f;
            double charge = InventoryLP.getAvailablePower(player);
            boolean sneaking = player.func_70093_af() && maxDamage;
            damage = !sneaking ? (float)Math.min(charge, normalDamage) : (float)charge;
            if (damage > 0.0f) {
                double cost = (double)damage * 0.2;
                ItemStack battery = InventoryLP.getLPSource(player, cost);
                if (!sneaking) {
                    LPBattery.addStoredPower(battery, -cost);
                } else {
                    LPBattery.setStoredPower(battery, 0.0);
                }
            }
            entity.func_70097_a(source, damage);
        }
    }

    public static float getEfficiency(ItemStack tool, float baseEff) {
        double charge = tool.field_77990_d.func_74769_h("availablePower");
        double multiplier = (LCItems.skyShard.func_77998_b() - 2.0f) / baseEff;
        double take = Math.min(charge / 0.2, multiplier);
        float newEff = charge > 0.0 ? baseEff * (float)take : baseEff;
        return newEff;
    }

    public static void updateToolPower(ItemStack tool, EntityPlayer player) {
        if (SkyUtils.canWriteItemNBT(tool, player) && tool.field_77990_d.func_74769_h("availablePower") != InventoryLP.getAvailablePower(player)) {
            tool.field_77990_d.func_74780_a("availablePower", InventoryLP.getAvailablePower(player));
        }
    }

    public static void onBlockBreak(ItemStack tool, EntityPlayer player, float baseEff) {
        double charge = InventoryLP.getAvailablePower(player);
        double multiplier = (LCItems.skyShard.func_77998_b() - 2.0f) / baseEff;
        double take = Math.min(charge, multiplier) * 0.02;
        ItemStack battery = InventoryLP.getLPSource(player, take);
        LPBattery.addStoredPower(battery, -take);
        tool.field_77990_d.func_74780_a("availablePower", InventoryLP.getAvailablePower(player));
    }

    public static class LPCharge {
        private double power;

        public LPCharge(double charge) {
            this.power = charge;
        }

        public LPCharge() {
            this.power = 0.0;
        }

        public double getCharge() {
            return this.power;
        }

        public void setCharge(double charge) {
            this.power = charge;
        }
    }
}

