/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.util;

import com.LightningCraft.util.WorldUtils;
import java.util.LinkedList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class WLRequest {
    public static LinkedList<WLRequest> requestQueue = new LinkedList();
    public UUID requester;
    public UUID owner;
    public WLUser target;

    public WLRequest(UUID requester, UUID owner, WLUser target) {
        this.requester = requester;
        this.owner = owner;
        this.target = target;
    }

    public static void viewRequest(EntityPlayer viewer) {
        for (int i = 0; i < requestQueue.size(); ++i) {
            WLRequest request = requestQueue.get(i);
            if (viewer.func_110124_au() != request.owner) continue;
            EntityPlayer requester = WorldUtils.getEntityPlayerFromUUID(request.target.getWorldObj(), request.requester);
            if (requester != null) {
                Vec3 targetPos = request.target.getPosition();
                int x = (int)targetPos.field_72450_a;
                int y = (int)targetPos.field_72448_b;
                int z = (int)targetPos.field_72449_c;
                viewer.func_145747_a((IChatComponent)new WLChatText(requester.getDisplayName() + " desires whitelist permissions to the location (" + x + ", " + y + ", " + z + ")"));
                continue;
            }
            viewer.func_145747_a((IChatComponent)new WLChatText("The player who requested whitelist access is not currently online. Use wl-accept or wl-deny to remove this request."));
        }
        viewer.func_145747_a((IChatComponent)new WLChatText("You have no pending whitelist requests."));
    }

    public static boolean acceptRequest(EntityPlayer decider) {
        for (int i = 0; i < requestQueue.size(); ++i) {
            WLRequest request = requestQueue.get(i);
            if (decider.func_110124_au() != request.owner) continue;
            EntityPlayer requester = WorldUtils.getEntityPlayerFromUUID(request.target.getWorldObj(), request.requester);
            if (requester != null) {
                request.target.addPlayerToWhitelist(requester);
                decider.func_145747_a((IChatComponent)new WLChatText("You have given " + requester.getDisplayName() + " whitelist permissions to the requested location."));
                requester.func_145747_a((IChatComponent)new WLChatText("You have been given whitelist permissions by " + decider.getDisplayName() + " to the requested location."));
                requestQueue.remove(i);
                return true;
            }
            decider.func_145747_a((IChatComponent)new WLChatText("The player who requested whitelist access is not currently online. This request will now be removed."));
            requestQueue.remove(i);
            return false;
        }
        decider.func_145747_a((IChatComponent)new WLChatText("You have no pending whitelist requests."));
        return false;
    }

    public static boolean denyRequest(EntityPlayer decider) {
        for (int i = 0; i < requestQueue.size(); ++i) {
            WLRequest request = requestQueue.get(i);
            if (decider.func_110124_au() != request.owner) continue;
            EntityPlayer requester = WorldUtils.getEntityPlayerFromUUID(request.target.getWorldObj(), request.requester);
            if (requester != null) {
                decider.func_145747_a((IChatComponent)new WLChatText("You have denied " + requester.getDisplayName() + " whitelist permissions to the requested location."));
                requester.func_145747_a((IChatComponent)new WLChatText("You have been denied whitelist permissions by " + decider.getDisplayName() + " to the requested location."));
                requestQueue.remove(i);
                return true;
            }
            decider.func_145747_a((IChatComponent)new WLChatText("The player who requested whitelist access is not currently online. This request will now be removed."));
            requestQueue.remove(i);
            return false;
        }
        decider.func_145747_a((IChatComponent)new WLChatText("You have no pending whitelist requests."));
        return false;
    }

    public static class WLChatText
    extends ChatComponentText {
        public WLChatText(String chat) {
            super("\u00a77\u00a7o" + chat);
        }
    }

    public static interface WLUser {
        public World getWorldObj();

        public boolean pendPlayerToWhitelist(EntityPlayer var1);

        public boolean addPlayerToWhitelist(EntityPlayer var1);

        public Vec3 getPosition();
    }
}

