/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.worldgen.structure;

import com.LightningCraft.lib.RefMisc;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.gen.structure.MapGenStructure;

public abstract class MapGenLCStructure
extends MapGenStructure {
    protected List spawnList = new ArrayList();
    protected int maxDistanceBetweenStructures;
    protected int minDistanceBetweenStructures;
    protected int seedDistance;

    public MapGenLCStructure(int maxDistanceBetweenStructures, int minDistanceBetweenStructures, int seedModifier) {
        this.maxDistanceBetweenStructures = maxDistanceBetweenStructures;
        this.minDistanceBetweenStructures = minDistanceBetweenStructures;
        this.seedDistance = 14357617 + seedModifier;
    }

    public MapGenLCStructure(int maxDistanceBetweenStructures, int minDistanceBetweenStructures) {
        this(maxDistanceBetweenStructures, minDistanceBetweenStructures, 0);
    }

    public String func_143025_a() {
        return this.getStructureName();
    }

    public abstract String getStructureName();

    public List getSpawnList() {
        return this.spawnList;
    }

    protected boolean func_75047_a(int x, int z) {
        int k = x;
        int l = z;
        if (x < 0) {
            x -= this.maxDistanceBetweenStructures - 1;
        }
        if (z < 0) {
            z -= this.maxDistanceBetweenStructures - 1;
        }
        int i1 = x / this.maxDistanceBetweenStructures;
        int j1 = z / this.maxDistanceBetweenStructures;
        Random random = this.field_75039_c.func_72843_D(i1, j1, this.seedDistance);
        i1 *= this.maxDistanceBetweenStructures;
        j1 *= this.maxDistanceBetweenStructures;
        if (k == (i1 += random.nextInt(this.maxDistanceBetweenStructures - this.minDistanceBetweenStructures)) && l == (j1 += random.nextInt(this.maxDistanceBetweenStructures - this.minDistanceBetweenStructures))) {
            if (RefMisc.DEBUG) {
                System.out.println("Structure gen possible for chunk (" + k + "," + l + ")");
            }
            return true;
        }
        return false;
    }

    public boolean func_75048_a(int x, int y, int z) {
        if (this.canAccessWorld()) {
            return super.func_75048_a(x, y, z);
        }
        return false;
    }

    public boolean canAccessWorld() {
        return this.field_75039_c != null;
    }
}

