/*
 * Decompiled with CFR 0.152.
 */
package com.LightningCraft.worldgen.structure.arcadia;

import com.LightningCraft.blocks.LCBlocks;
import com.LightningCraft.items.LCItems;
import com.LightningCraft.util.WorldUtils;
import com.LightningCraft.worldgen.structure.Feature;
import com.LightningCraft.worldgen.structure.LootChestGroup;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class HeavenRuins
extends Feature {
    private static final int nChests = 1;
    private static final int minStacks = 4;
    private static final int maxStacks = 7;
    private static final Block mainBlock = LCBlocks.heavenstoneBricks;

    public HeavenRuins() {
        this(new Random(), 0, 0);
    }

    public HeavenRuins(Random rand, int x, int z) {
        super(rand, x, 64, z, 5, 5, 5);
        this.spawnMinY = 50;
        this.spawnMaxY = 70;
        this.lootChests = new LootChestGroup(1, 4, 7, new WeightedRandomChestContent[]{new WeightedRandomChestContent(new ItemStack(Blocks.field_150340_R), 1, 5, 10), new WeightedRandomChestContent(LCItems.demonBlood, 0, 1, 4, 20), new WeightedRandomChestContent(new ItemStack(Blocks.field_150484_ah), 1, 2, 5), new WeightedRandomChestContent(new ItemStack(LCBlocks.metalBlock), 1, 2, 5), new WeightedRandomChestContent(LCItems.heavenItem, 0, 1, 1, 3), new WeightedRandomChestContent(LCItems.skyItem, 0, 1, 2, 10)});
        this.lootChests.setIsTrapped(0, true);
    }

    @Override
    protected boolean findSpawnPosition(World world, StructureBoundingBox box, int yoff) {
        if (this.structY >= 0) {
            return true;
        }
        for (int y = this.spawnMinY; y <= this.spawnMaxY; ++y) {
            if (!WorldUtils.canSpawnAtPosition(world, this.field_74887_e.field_78897_a, y, this.field_74887_e.field_78896_c, this.scatteredFeatureSizeY) || !WorldUtils.canSpawnAtPosition(world, this.field_74887_e.field_78893_d, y, this.field_74887_e.field_78896_c, this.scatteredFeatureSizeY) || !WorldUtils.canSpawnAtPosition(world, this.field_74887_e.field_78897_a, y, this.field_74887_e.field_78892_f, this.scatteredFeatureSizeY) || !WorldUtils.canSpawnAtPosition(world, this.field_74887_e.field_78893_d, y, this.field_74887_e.field_78892_f, this.scatteredFeatureSizeY)) continue;
            this.structY = y - 1;
            this.field_74887_e.func_78886_a(0, this.structY - this.field_74887_e.field_78895_b + yoff, 0);
            return true;
        }
        return false;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
        int z;
        int x;
        if (!this.findSpawnPosition(world, box, 0)) {
            return false;
        }
        int ymax = 5;
        int y = 0;
        for (x = 0; x < 5; ++x) {
            for (z = 0; z < 5; ++z) {
                this.addRuinedBlock(world, x, y, z, mainBlock, 0, rand, 0.9);
            }
        }
        z = 0;
        for (x = 0; x < 4; ++x) {
            for (y = 1; y < ymax; ++y) {
                this.addRuinedBlockStacked(world, x, y, z, mainBlock, 0, rand, 0.9 / (double)y);
            }
        }
        z = 4;
        for (x = 1; x < 5; ++x) {
            for (y = 1; y < ymax; ++y) {
                this.addRuinedBlockStacked(world, x, y, z, mainBlock, 0, rand, 0.9 / (double)y);
            }
        }
        x = 0;
        for (z = 1; z < 5; ++z) {
            for (y = 1; y < ymax; ++y) {
                this.addRuinedBlockStacked(world, x, y, z, mainBlock, 0, rand, 0.9 / (double)y);
            }
        }
        x = 4;
        for (z = 0; z < 4; ++z) {
            for (y = 1; y < ymax; ++y) {
                this.addRuinedBlockStacked(world, x, y, z, mainBlock, 0, rand, 0.9 / (double)y);
            }
        }
        x = rand.nextInt(3) + 1;
        y = 0;
        z = rand.nextInt(3) + 1;
        this.addBlock(world, x, y, z, Blocks.field_150350_a, 0);
        for (x = 1; x < 4; ++x) {
            for (y = -2; y < 0; ++y) {
                for (z = 1; z < 4; ++z) {
                    this.addBlock(world, x, y, z, Blocks.field_150350_a, -1);
                }
            }
        }
        y = -3;
        for (x = 1; x < 4; ++x) {
            for (z = 1; z < 4; ++z) {
                this.addRuinedBlock(world, x, y, z, mainBlock, -1, rand, 0.4);
            }
        }
        if (!this.lootChests.getChestPlaced(0)) {
            this.lootChests.setChestPlaced(0, this.generateStructureChestContents(world, box, rand, 2, -2, 2, 0, 0));
        }
        this.addBlock(world, 2, -4, 2, LCBlocks.underworldTNT, -1);
        return true;
    }

    private void addRuinedBlock(World world, int x, int y, int z, Block block, int meta, Random rand, double chance) {
        if (rand.nextDouble() <= chance) {
            this.addBlock(world, x, y, z, block, meta);
        }
    }

    private void addRuinedBlockStacked(World world, int x, int y, int z, Block block, int meta, Random rand, double chance) {
        if (this.func_151548_a(world, x, y - 1, z, this.field_74887_e) == block) {
            this.addRuinedBlock(world, x, y, z, block, meta, rand, chance);
        }
    }
}

