/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.api.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.api.util.StackHelper;

public class LightningInfusionRecipe {
    public static final String nullIdentifier = "NULL";
    public static final int itemsNeeded = 4;
    private final ItemStack output;
    private final String infuse;
    private final List<String> items;
    private final int cost;
    private boolean nbtSensitive;

    public LightningInfusionRecipe(ItemStack output, int cost, Object infuse, Object ... surrounding) {
        ArrayList<Object> items = new ArrayList<Object>(Arrays.asList(surrounding));
        if (items.size() > 4) {
            throw new IllegalArgumentException("There must be at most 4 surrounding items in an infusion recipe.");
        }
        while (items.size() < 4) {
            items.add(null);
        }
        this.output = output;
        this.cost = cost;
        if (infuse == null) {
            throw new IllegalArgumentException("The infused item cannot be null!");
        }
        this.infuse = infuse instanceof Block ? StackHelper.makeStringFromItemStack(new ItemStack((Block)infuse)) : (infuse instanceof Item ? StackHelper.makeStringFromItemStack(new ItemStack((Item)infuse)) : StackHelper.makeStringFromItemStack(infuse));
        this.items = new JointList<String>();
        for (Object e : items) {
            if (e == null) {
                this.items.add(nullIdentifier);
                continue;
            }
            if (e instanceof Block) {
                this.items.add(StackHelper.makeStringFromItemStack(new ItemStack((Block)e)));
                continue;
            }
            if (e instanceof Item) {
                this.items.add(StackHelper.makeStringFromItemStack(new ItemStack((Item)e)));
                continue;
            }
            this.items.add(StackHelper.makeStringFromItemStack(e));
        }
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getCost() {
        return this.cost;
    }

    public String getInfuseItem() {
        return this.infuse;
    }

    public List<String> getInfuseItemAsOre() {
        JointList<String> list = new JointList<String>();
        if (OreDictionary.doesOreNameExist((String)this.infuse)) {
            for (ItemStack s : OreDictionary.getOres((String)this.infuse)) {
                list.add(StackHelper.makeStringFromItemStack(s));
            }
        }
        return list;
    }

    public List<String> getItems() {
        return this.items;
    }

    public List<List<String>> getItemsAsOres() {
        JointList<List<String>> list = new JointList<List<String>>();
        for (String name : this.items) {
            JointList list2 = new JointList();
            if (OreDictionary.doesOreNameExist((String)name)) {
                for (ItemStack s : OreDictionary.getOres((String)name)) {
                    list2.add(StackHelper.makeStringFromItemStack(s));
                }
            }
            list.add(list2);
        }
        return list;
    }

    public LightningInfusionRecipe setNBTSensitive() {
        this.nbtSensitive = true;
        return this;
    }

    public boolean getNBTSensitive() {
        return this.nbtSensitive;
    }
}

