/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.crafting;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.crafting.RecipeHelper;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.integration.energy.EnergyApiHelper;
import sblectric.lightningcraft.recipes.LCFuelHandler;
import sblectric.lightningcraft.ref.Metal;

public class LCCraftingManager {
    public static void onInit() {
        LCCraftingManager.setOreDictionary();
        LCCraftingManager.addCraftingRecipes();
        LCCraftingManager.addSmeltingRecipes();
        GameRegistry.registerFuelHandler((IFuelHandler)new LCFuelHandler());
    }

    private static void setOreDictionary() {
        int meta;
        for (meta = 0; meta < 3; ++meta) {
            OreDictionary.registerOre((String)Metal.MBlock.getBlockFromMeta(meta), (ItemStack)new ItemStack((Block)LCBlocks.metalBlock, 1, meta));
        }
        for (meta = 0; meta < 3; ++meta) {
            OreDictionary.registerOre((String)Metal.Ingot.getIngotFromMeta(meta), (ItemStack)new ItemStack((Item)LCItems.ingot, 1, meta));
        }
        for (meta = 0; meta < 3; ++meta) {
            OreDictionary.registerOre((String)Metal.Nugget.getNuggetFromMeta(meta), (ItemStack)new ItemStack((Item)LCItems.nugget, 1, meta));
        }
        for (meta = 0; meta < 3; ++meta) {
            OreDictionary.registerOre((String)Metal.Dust.getDustFromMeta(meta), (ItemStack)new ItemStack((Item)LCItems.dust, 1, meta));
        }
        for (meta = 0; meta < 10; ++meta) {
            OreDictionary.registerOre((String)Metal.Rod.getRodFromMeta(meta), (ItemStack)new ItemStack((Item)LCItems.rod, 1, meta));
        }
        for (meta = 0; meta < 10; ++meta) {
            OreDictionary.registerOre((String)Metal.Plate.getPlateFromMeta(meta), (ItemStack)new ItemStack((Item)LCItems.plate, 1, meta));
        }
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)LCBlocks.woodLog));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)LCBlocks.woodPlank));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack((Block)LCBlocks.slabBlock, 1, 3));
        OreDictionary.registerOre((String)"stairWood", (ItemStack)new ItemStack((Block)LCBlocks.underPlankStairs));
        OreDictionary.registerOre((String)"oreIron", (ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 0));
        OreDictionary.registerOre((String)"oreGold", (ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 1));
        OreDictionary.registerOre((String)"oreDiamond", (ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 2));
        OreDictionary.registerOre((String)"oreEmerald", (ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 3));
        OreDictionary.registerOre((String)"nuggetNetherStar", (ItemStack)new ItemStack((Item)LCItems.material, 1, 0));
        OreDictionary.registerOre((String)"dustDiamond", (ItemStack)new ItemStack((Item)LCItems.material, 1, 1));
        OreDictionary.registerOre((String)"dustEmerald", (ItemStack)new ItemStack((Item)LCItems.material, 1, 2));
        OreDictionary.registerOre((String)"dustQuartz", (ItemStack)new ItemStack((Item)LCItems.material, 1, 3));
    }

    private static void addCraftingRecipes() {
        int meta;
        for (meta = 0; meta < 3; ++meta) {
            RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.metalBlock, 1, meta), "XXX", "XXX", "XXX", Character.valueOf('X'), Metal.Ingot.getIngotFromMeta(meta));
            RecipeHelper.addShapelessOreRecipe(new ItemStack((Item)LCItems.ingot, 9, meta), new ItemStack((Block)LCBlocks.metalBlock, 1, meta));
        }
        for (meta = 0; meta < 3; ++meta) {
            RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.ingot, 1, meta), "XXX", "XXX", "XXX", Character.valueOf('X'), Metal.Nugget.getNuggetFromMeta(meta));
            RecipeHelper.addShapelessOreRecipe(new ItemStack((Item)LCItems.nugget, 9, meta), new ItemStack((Item)LCItems.ingot, 1, meta));
        }
        for (meta = 0; meta < 10; ++meta) {
            RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.rod, 1, meta), "  X", " X ", "X  ", Character.valueOf('X'), Metal.Rod.getIngotFromMeta(meta));
        }
        for (meta = 0; meta < 10; ++meta) {
            RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.plate, 3, meta), "XXX", Character.valueOf('X'), Metal.Rod.getIngotFromMeta(meta));
        }
        for (meta = 0; meta < 10; ++meta) {
            RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.airTerminal, 1, meta), " I ", " X ", "PIP", Character.valueOf('I'), Metal.Rod.getIngotFromMeta(meta), Character.valueOf('X'), Metal.Rod.getRodFromMeta(meta), Character.valueOf('P'), Metal.Plate.getPlateFromMeta(meta));
        }
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.golfClub), " II", " X ", "I  ", Character.valueOf('X'), "rodIron", Character.valueOf('I'), "ingotIron");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.golfClubGold), " II", " X ", "I  ", Character.valueOf('X'), "rodGold", Character.valueOf('I'), "ingotGold");
        RecipeHelper.addShapedOreRecipe(new ItemStack(Items.field_151156_bN), "XXX", "XXX", "XXX", Character.valueOf('X'), "nuggetNetherStar");
        RecipeHelper.addShapelessOreRecipe(new ItemStack((Item)LCItems.material, 9, 0), Items.field_151156_bN);
        RecipeHelper.addShapelessOreRecipe(new ItemStack((Item)LCItems.material, 3, 8), new ItemStack((Item)LCItems.material, 1, 7));
        RecipeHelper.addShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 6, 1), new ItemStack((Item)LCItems.material, 1, 5));
        RecipeHelper.addShapelessOreRecipe(new ItemStack(Items.field_151100_aR, 3, 6), new ItemStack((Item)LCItems.material, 1, 8));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 0), "QXQ", "XOX", "QXQ", Character.valueOf('X'), "cobblestone", Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('Q'), "gemQuartz");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 1), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 0));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 1, 2), "X", "X", Character.valueOf('X'), new ItemStack((Block)LCBlocks.slabBlock, 1, 0));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 9), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 2));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 12), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 1));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.slabBlock, 6, 0), "XXX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 1));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.thunderStairs, 4), "X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 1));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 4), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 3));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 1, 5), "X", "X", Character.valueOf('X'), new ItemStack((Block)LCBlocks.slabBlock, 1, 1));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 10), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 5));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 13), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 4));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.slabBlock, 6, 1), "XXX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 4));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.demonStairs, 4), "X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 4));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 7), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 6));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 1, 8), "X", "X", Character.valueOf('X'), new ItemStack((Block)LCBlocks.slabBlock, 1, 2));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 11), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 8));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 4, 14), "XX", "XX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 7));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.slabBlock, 6, 2), "XXX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 7));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.underStairs, 4), "X  ", "XX ", "XXX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 7));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightBlock, 4, 1), "RBR", "BLB", "RBR", Character.valueOf('R'), Blocks.field_150426_aN, Character.valueOf('B'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 8), Character.valueOf('L'), new ItemStack((Block)LCBlocks.lightBlock, 1, 0));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightBlock, 4, 2), "AB", "BA", Character.valueOf('A'), new ItemStack((Block)LCBlocks.lightBlock, 1, 0), Character.valueOf('B'), new ItemStack((Block)LCBlocks.lightBlock, 1, 1));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightBlock, 4, 3), "AA", "AA", Character.valueOf('A'), new ItemStack((Block)LCBlocks.lightBlock, 1, 2));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightBlock, 4, 4), "AA", "AA", Character.valueOf('A'), new ItemStack((Block)LCBlocks.lightBlock, 1, 3));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightBlock, 4, 2), "AA", "AA", Character.valueOf('A'), new ItemStack((Block)LCBlocks.lightBlock, 1, 4));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.wallBlock, 6), "BBB", "BBB", Character.valueOf('B'), LCBlocks.corruptStone);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.underTNT, 1, 1), "GSG", "SGS", "GSG", Character.valueOf('G'), new ItemStack((Item)LCItems.material, 1, 13), Character.valueOf('S'), LCBlocks.underSand);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.underTNT, 1, 2), "GSG", "TGT", "GSG", Character.valueOf('G'), new ItemStack((Item)LCItems.material, 1, 14), Character.valueOf('S'), new ItemStack((Block)LCBlocks.underTNT, 1, 1), Character.valueOf('T'), Blocks.field_150335_W);
        RecipeHelper.addShapelessOreRecipe(new ItemStack((Block)LCBlocks.woodPlank, 4), LCBlocks.woodLog);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.slabBlock, 6, 3), "XXX", Character.valueOf('X'), LCBlocks.woodPlank);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.underPlankStairs, 4), "X  ", "XX ", "XXX", Character.valueOf('X'), LCBlocks.woodPlank);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecHammer), "PPP", "XIX", " I ", Character.valueOf('X'), "ingotElectricium", Character.valueOf('I'), "rodElectricium", Character.valueOf('P'), "plateElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecSword), " X ", "PXP", " I ", Character.valueOf('X'), "ingotElectricium", Character.valueOf('I'), "rodElectricium", Character.valueOf('P'), "plateElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecPick), "XXX", " I ", " I ", Character.valueOf('X'), "ingotElectricium", Character.valueOf('I'), "rodElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecAxe), "XX", "XI", " I", Character.valueOf('X'), "ingotElectricium", Character.valueOf('I'), "rodElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecShovel), "X", "I", "I", Character.valueOf('X'), "ingotElectricium", Character.valueOf('I'), "rodElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecHoe), "XX", " I", " I", Character.valueOf('X'), "ingotElectricium", Character.valueOf('I'), "rodElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyHammer), "PPP", "XIX", " I ", Character.valueOf('X'), "ingotSkyfather", Character.valueOf('I'), "rodSkyfather", Character.valueOf('P'), "plateSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skySword), " X ", "PXP", " I ", Character.valueOf('X'), "ingotSkyfather", Character.valueOf('I'), "rodSkyfather", Character.valueOf('P'), "plateSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyPick), "XXX", " I ", " I ", Character.valueOf('X'), "ingotSkyfather", Character.valueOf('I'), "rodSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyAxe), "XX", "XI", " I", Character.valueOf('X'), "ingotSkyfather", Character.valueOf('I'), "rodSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyShovel), "X", "I", "I", Character.valueOf('X'), "ingotSkyfather", Character.valueOf('I'), "rodSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyHoe), "XX", " I", " I", Character.valueOf('X'), "ingotSkyfather", Character.valueOf('I'), "rodSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecHelm), "XXX", "X X", Character.valueOf('X'), "ingotElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecChest), "X X", "XXX", "XXX", Character.valueOf('X'), "ingotElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecLegs), "XXX", "X X", "X X", Character.valueOf('X'), "ingotElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.elecBoots), "X X", "X X", Character.valueOf('X'), "ingotElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyHelm), "XXX", "X X", Character.valueOf('X'), "ingotSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyChest), "X X", "XXX", "XXX", Character.valueOf('X'), "ingotSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyLegs), "XXX", "X X", "X X", Character.valueOf('X'), "ingotSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.skyBoots), "X X", "X X", Character.valueOf('X'), "ingotSkyfather");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticSword), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151010_B, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticPick), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151005_D, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticAxe), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151006_E, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticShovel), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151011_C, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticHelm), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151169_ag, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticChest), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151171_ah, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticLegs), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151149_ai, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.kineticBoots), "RCR", "RAR", "RER", Character.valueOf('A'), Items.field_151151_aj, Character.valueOf('E'), "plateElectricium", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningCell, 1, 0), "XAX", "IBI", "XAX", Character.valueOf('B'), "plateGold", Character.valueOf('X'), "rodIron", Character.valueOf('I'), "plateElectricium", Character.valueOf('A'), "dustRedstone");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningCell, 1, 1), "XAX", "IBI", "XAX", Character.valueOf('B'), new ItemStack((Block)LCBlocks.lightningCell, 1, 0), Character.valueOf('X'), "rodGold", Character.valueOf('I'), "plateSkyfather", Character.valueOf('A'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningCell, 1, 2), "XAX", "IBI", "XAX", Character.valueOf('B'), new ItemStack((Block)LCBlocks.lightningCell, 1, 1), Character.valueOf('X'), "rodSkyfather", Character.valueOf('I'), "plateMystic", Character.valueOf('A'), "plateElectricium");
        ItemStack lUpgrade = new ItemStack((Item)LCItems.material, 1, 4);
        RecipeHelper.addShapedOreRecipe(lUpgrade, " R ", "RXR", " R ", Character.valueOf('X'), "plateSkyfather", Character.valueOf('R'), "dustRedstone");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningFurnace), "XCX", "XAX", "XIX", Character.valueOf('X'), "cobblestone", Character.valueOf('I'), "plateIron", Character.valueOf('A'), Blocks.field_150460_al, Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningCrusher), "ZCZ", "XAX", "ZIZ", Character.valueOf('Z'), Blocks.field_150411_aY, Character.valueOf('X'), Blocks.field_150343_Z, Character.valueOf('I'), "plateElectricium", Character.valueOf('A'), LCBlocks.lightningFurnace, Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningInfuser), "XCX", "XAX", "XIX", Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 0), Character.valueOf('I'), "plateGold", Character.valueOf('A'), "rodElectricium", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningBreaker), "XCX", "GAG", "XIX", Character.valueOf('X'), "plateIron", Character.valueOf('G'), "plateGold", Character.valueOf('I'), Items.field_151046_w, Character.valueOf('A'), "blockIron", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningMiner), "XCX", "GAG", "XIX", Character.valueOf('X'), "plateGold", Character.valueOf('G'), "plateSkyfather", Character.valueOf('I'), LCItems.elecPick, Character.valueOf('A'), new ItemStack((Block)LCBlocks.lightningBreaker), Character.valueOf('C'), "plateElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.staticGenerator), "XCX", "COC", "XCX", Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('X'), Blocks.field_150371_ca, Character.valueOf('O'), new ItemStack((Block)LCBlocks.lightningCell, 1, 0));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.enchReallocator), "TCT", "XAX", "XEX", Character.valueOf('A'), new ItemStack((Item)LCItems.material, 1, 9), Character.valueOf('E'), Blocks.field_150381_bn, Character.valueOf('T'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 8), Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('X'), new ItemStack((Block)LCBlocks.stoneBlock, 1, 5));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningCannon, 1, 1), "ERE", "ICI", "ETE", Character.valueOf('C'), new ItemStack((Item)LCItems.material, 1, 10), Character.valueOf('I'), "rodIron", Character.valueOf('E'), "rodElectricium", Character.valueOf('T'), Blocks.field_150335_W, Character.valueOf('R'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.lightningCannon, 1, 2), "EQE", "ICI", "EDE", Character.valueOf('C'), new ItemStack((Block)LCBlocks.lightningCannon, 1, 1), Character.valueOf('I'), "rodMystic", Character.valueOf('E'), "rodSkyfather", Character.valueOf('Q'), lUpgrade, Character.valueOf('D'), "dustMystic");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.wirelessBlock, 1, 0), " T ", "XOX", "XCX", Character.valueOf('C'), "dustDiamond", Character.valueOf('X'), "plateIron", Character.valueOf('O'), lUpgrade, Character.valueOf('T'), new ItemStack((Block)LCBlocks.airTerminal, 1, 7));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.wirelessBlock, 1, 1), " T ", "XOX", "XCX", Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('X'), "rodIron", Character.valueOf('O'), new ItemStack((Block)LCBlocks.wirelessBlock, 1, 0), Character.valueOf('T'), new ItemStack((Block)LCBlocks.airTerminal, 1, 8));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.wirelessBlock, 1, 2), " T ", "XOX", "XCX", Character.valueOf('C'), "plateElectricium", Character.valueOf('X'), "blockIron", Character.valueOf('O'), new ItemStack((Block)LCBlocks.wirelessBlock, 1, 1), Character.valueOf('T'), new ItemStack((Block)LCBlocks.airTerminal, 1, 9));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.wirelessBlock, 1, 3), " T ", "XOX", "XCX", Character.valueOf('C'), "dustRedstone", Character.valueOf('X'), "plateGold", Character.valueOf('O'), lUpgrade, Character.valueOf('T'), new ItemStack((Block)LCBlocks.airTerminal, 1, 7));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.wirelessBlock, 1, 4), " T ", "XOX", "XCX", Character.valueOf('C'), Items.field_151132_bS, Character.valueOf('X'), "rodGold", Character.valueOf('O'), new ItemStack((Block)LCBlocks.wirelessBlock, 1, 3), Character.valueOf('T'), new ItemStack((Block)LCBlocks.airTerminal, 1, 8));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.wirelessBlock, 1, 5), " T ", "XOX", "XCX", Character.valueOf('C'), "blockRedstone", Character.valueOf('X'), "blockGold", Character.valueOf('O'), new ItemStack((Block)LCBlocks.wirelessBlock, 1, 4), Character.valueOf('T'), new ItemStack((Block)LCBlocks.airTerminal, 1, 9));
        if (EnergyApiHelper.rfOrTeslaLoaded) {
            RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.rfProvider), "BRB", "CAC", "BCB", Character.valueOf('B'), "plateElectricium", Character.valueOf('A'), "blockIron", Character.valueOf('R'), Items.field_151132_bS, Character.valueOf('C'), "plateIron");
            RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.rfReceiver), "BRB", "CAC", "BCB", Character.valueOf('B'), "blockRedstone", Character.valueOf('A'), "blockGold", Character.valueOf('R'), Items.field_151132_bS, Character.valueOf('C'), "plateIron");
        }
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.wirelessMarker, 1), " C ", "EPE", " U ", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('E'), "dustElectricium", Character.valueOf('U'), lUpgrade, Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapelessOreRecipe(new ItemStack((Item)LCItems.wirelessMarker, 1, 0), new ItemStack((Item)LCItems.wirelessMarker, 1, 1));
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.battery, 1, 0), "ICI", "IBI", "IRI", Character.valueOf('B'), "plateElectricium", Character.valueOf('I'), "rodIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.battery, 1, 1), "RUR", "RBR", "RIR", Character.valueOf('B'), new ItemStack((Item)LCItems.battery, 1, 0), Character.valueOf('U'), lUpgrade, Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "rodElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.battery, 1, 2), "RUR", "RBR", "RIR", Character.valueOf('B'), new ItemStack((Item)LCItems.battery, 1, 1), Character.valueOf('U'), "ingotSkyfather", Character.valueOf('R'), "blockRedstone", Character.valueOf('I'), "blockElectricium");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Block)LCBlocks.chargingPlate), "RCR", "RPR", "RER", Character.valueOf('E'), "plateElectricium", Character.valueOf('P'), Blocks.field_150443_bT, Character.valueOf('R'), "dustRedstone", Character.valueOf('C'), Items.field_151132_bS);
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.itemMagnet, 1, 0), "INN", "  N", "INN", Character.valueOf('I'), "plateIron", Character.valueOf('N'), "blockRedstone");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.itemMagnet, 1, 1), "IEE", " ME", "IEE", Character.valueOf('I'), "plateIron", Character.valueOf('M'), new ItemStack((Item)LCItems.itemMagnet, 1, 0), Character.valueOf('E'), "ingotIron");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.itemMagnet, 1, 2), "IEE", " ME", "IEE", Character.valueOf('I'), "plateIron", Character.valueOf('M'), new ItemStack((Item)LCItems.itemMagnet, 1, 1), Character.valueOf('E'), "ingotGold");
        RecipeHelper.addShapedOreRecipe(new ItemStack((Item)LCItems.itemMagnet, 1, 3), "IEE", " ME", "IEE", Character.valueOf('I'), "plateIron", Character.valueOf('M'), new ItemStack((Item)LCItems.itemMagnet, 1, 2), Character.valueOf('E'), "ingotElectricium");
    }

    private static void addSmeltingRecipes() {
        for (int meta = 0; meta < 3; ++meta) {
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)LCItems.dust, 1, meta), (ItemStack)new ItemStack((Item)LCItems.ingot, 1, meta), (float)1.0f);
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)LCBlocks.woodLog, 1, 0), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 0), (ItemStack)new ItemStack(Items.field_151042_j), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 1), (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 2), (ItemStack)new ItemStack(Items.field_151045_i, 2), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)LCBlocks.oreBlock, 1, 3), (ItemStack)new ItemStack(Items.field_151166_bC, 2), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)LCItems.material, 1, 1), (ItemStack)new ItemStack(Items.field_151045_i), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)LCItems.material, 1, 2), (ItemStack)new ItemStack(Items.field_151166_bC), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)LCItems.material, 1, 3), (ItemStack)new ItemStack(Items.field_151128_bU), (float)1.0f);
    }

    public static void postInit() {
        for (String name : OreDictionary.getOreNames()) {
            if (name.equals("rod") || !name.startsWith("rod") || !Metal.getAllNames().contains(name.substring(3))) continue;
            for (ItemStack s : OreDictionary.getOres((String)name)) {
                try {
                    if (LCConfig.disableOtherRods && !s.func_77973_b().getRegistryName().func_110624_b().equals("lightningcraft")) {
                        RecipeHelper.removeRecipes(s);
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                OreDictionary.registerOre((String)"rodLC", (ItemStack)s);
            }
        }
        RecipeHelper.addShapelessOreRecipe(new ItemStack((Item)LCItems.guide), Items.field_151122_aG, "rodLC");
    }
}

