/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import sblectric.lightningcraft.api.capabilities.implementation.BaseLightningUpgradable;
import sblectric.lightningcraft.blocks.BlockAirTerminal;
import sblectric.lightningcraft.init.LCAchievements;
import sblectric.lightningcraft.init.LCCapabilities;
import sblectric.lightningcraft.tiles.TileEntityBase;
import sblectric.lightningcraft.util.Effect;
import sblectric.lightningcraft.util.WeatherUtils;
import sblectric.lightningcraft.util.WorldUtils;

public class TileEntityLightningCell
extends TileEntityBase {
    public double storedPower;
    public double maxPower;
    public double efficiency;
    public int cooldownTime;
    public String cellName;
    public boolean creative;
    private boolean topTierTerminal = false;
    private boolean didCheck = false;
    private BaseLightningUpgradable upgrade = new BaseLightningUpgradable(){

        @Override
        public EnumActionResult onLightningUpgrade(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            this.setUpgraded(true);
            TileEntityLightningCell.this.maxPower *= 1.5;
            TileEntityLightningCell.this.cellName = TileEntityLightningCell.this.cellName + " (Upgr.)";
            return EnumActionResult.SUCCESS;
        }
    };

    public TileEntityLightningCell(double mp, String name, boolean creative) {
        this.maxPower = mp;
        this.cellName = name;
        if (creative) {
            this.creative = creative;
            this.storedPower = this.maxPower;
        }
    }

    public TileEntityLightningCell() {
    }

    public void func_73660_a() {
        EntityPlayerMP player;
        boolean dosave = false;
        if (this.field_145850_b.field_72995_K) {
            this.isAirTerminalPresent();
            return;
        }
        if (this.storedPower > this.maxPower) {
            this.storedPower = this.maxPower;
        }
        if (this.storedPower < 0.0) {
            this.storedPower = 0.0;
        }
        if (this.creative) {
            this.storedPower = this.maxPower;
        }
        if (!this.didCheck && this.maxPower == 30000.0 && this.topTierTerminal && (player = (EntityPlayerMP)WorldUtils.getClosestPlayer(this.field_145850_b, this.getX(), this.getY(), this.getZ(), 16.0)) != null && player.func_147099_x().func_77442_b(LCAchievements.perfectCell)) {
            player.func_71064_a((StatBase)LCAchievements.perfectCell, 1);
            this.didCheck = true;
        }
        if (this.cooldownTime > 0) {
            --this.cooldownTime;
            dosave = true;
        }
        if (this.isAirTerminalPresent()) {
            AxisAlignedBB box;
            List<EntityLightningBolt> bolts;
            double chance = 1.0E-5;
            if (this.field_145850_b.func_72911_I()) {
                chance = 0.001;
            }
            if (this.random.nextDouble() <= chance && this.storedPower < this.maxPower - 100.0 * this.efficiency) {
                Effect.lightningGen(this.field_145850_b, this.field_174879_c.func_177984_a());
            }
            if (!(bolts = WeatherUtils.getLightningBoltsWithinAABB(this.field_145850_b, box = new AxisAlignedBB((double)(this.getX() - 5), (double)(this.getY() - 2), (double)(this.getZ() - 5), (double)(this.getX() + 5), (double)(this.getY() + 4), (double)(this.getZ() + 5)))).isEmpty() && this.cooldownTime <= 0 && this.storedPower < this.maxPower - 100.0 * this.efficiency) {
                for (EntityLightningBolt bolt : bolts) {
                    if (bolt.field_70128_L) {
                        return;
                    }
                    this.field_145850_b.func_72900_e((Entity)bolt);
                }
                this.storedPower += 100.0 * this.efficiency;
                this.cooldownTime = 40;
                dosave = true;
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == LCCapabilities.LIGHTNING_UPGRADABLE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == LCCapabilities.LIGHTNING_UPGRADABLE) {
            return (T)this.upgrade;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean isUpgraded() {
        return this.upgrade.isUpgraded();
    }

    public void setUpgraded(boolean upgraded) {
        this.upgrade.setUpgraded(upgraded);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1) {
        super.func_189515_b(par1);
        par1.func_74780_a("storedPower", this.storedPower);
        par1.func_74780_a("maxPower", this.maxPower);
        par1.func_74768_a("cooldownTime", this.cooldownTime);
        par1.func_74757_a("topTierCheck", this.didCheck);
        par1.func_74778_a("customName", this.cellName);
        par1.func_74757_a("isCreative", this.creative);
        this.upgrade.serializeNBT(par1);
        return par1;
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.storedPower = par1.func_74769_h("storedPower");
        this.maxPower = par1.func_74769_h("maxPower");
        this.cooldownTime = par1.func_74762_e("cooldownTime");
        this.didCheck = par1.func_74767_n("topTierCheck");
        this.cellName = par1.func_74779_i("customName");
        this.creative = par1.func_74767_n("isCreative");
        this.upgrade.deserializeNBT(par1);
    }

    public boolean isAirTerminalPresent() {
        boolean flag;
        this.topTierTerminal = false;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a());
        Block test = state.func_177230_c();
        int meta = test.func_176201_c(state);
        if (test instanceof BlockAirTerminal) {
            flag = true;
            this.efficiency = ((BlockAirTerminal)test).getEfficiency(state);
            if (meta == 9) {
                this.topTierTerminal = true;
            }
        } else {
            flag = false;
            this.efficiency = 0.0;
        }
        return flag;
    }
}

