/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sblectric.lightningcraft.api.IFurnace;
import sblectric.lightningcraft.recipes.LightningInfusionRecipes;
import sblectric.lightningcraft.tiles.TileEntityLightningItemHandler;

public class TileEntityLightningInfuser
extends TileEntityLightningItemHandler.Upgradable {
    private static final int top = 0;
    private static final int inf1 = 1;
    private static final int inf2 = 2;
    private static final int inf3 = 3;
    private static final int inf4 = 4;
    private static final int bottom = 5;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{5};
    private static final int[] slotsSides = new int[]{1, 2, 3, 4};
    public static final int burnTime = 600;
    public int infuserBurnTime;
    public int infuserCookTime;
    public int currentBurnTime;
    public int infusionCost;
    private boolean redo;

    public TileEntityLightningInfuser() {
        this.stacks = new ItemStack[6];
    }

    @SideOnly(value=Side.CLIENT)
    public int getInfusionProgressScaled(int par1) {
        return this.infuserCookTime * par1 / 600;
    }

    @SideOnly(value=Side.CLIENT)
    public int getInfusionTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 600;
        }
        return this.infuserBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.infuserBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.infuserCookTime > 0;
        boolean dosave = false;
        if (this.infuserBurnTime > 0) {
            --this.infuserBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.infuserBurnTime == 0 && this.canInfuse()) {
                this.infuserBurnTime = 600;
                this.currentBurnTime = 600;
                if (this.infuserBurnTime > 0) {
                    dosave = true;
                }
            }
            if (this.isBurning() && this.canInfuse()) {
                ++this.infuserCookTime;
                if (this.infuserCookTime == 600) {
                    this.infuserCookTime = 0;
                    this.infuseItem();
                    dosave = true;
                }
            } else {
                this.infuserCookTime = 0;
            }
            if (burning != this.infuserCookTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.infuserCookTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
        if (this.isUpgraded() && !this.redo) {
            this.redo = true;
            this.func_73660_a();
        }
        this.redo = false;
    }

    private boolean canInfuse() {
        this.infusionCost = 0;
        if (!this.hasLPCell()) {
            return false;
        }
        if (this.stacks[0] == null) {
            return false;
        }
        ItemStack itemstack = LightningInfusionRecipes.instance().getInfusionResult(this.stacks[0], this.stacks[1], this.stacks[2], this.stacks[3], this.stacks[4]);
        this.infusionCost = LightningInfusionRecipes.instance().getLastResultCost();
        if (itemstack == null) {
            return false;
        }
        if (this.infusionCost <= 0) {
            return false;
        }
        if (!this.canDrawCellPower(this.infusionCost)) {
            return false;
        }
        if (this.stacks[5] == null) {
            return true;
        }
        if (!this.stacks[5].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.stacks[5].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.stacks[5].func_77976_d();
    }

    private void infuseItem() {
        if (this.canInfuse()) {
            ItemStack itemstack = LightningInfusionRecipes.instance().getInfusionResult(this.stacks[0], this.stacks[1], this.stacks[2], this.stacks[3], this.stacks[4]);
            int cost = LightningInfusionRecipes.instance().getLastResultCost();
            this.drawCellPower(cost);
            if (this.stacks[5] == null) {
                this.stacks[5] = itemstack.func_77946_l();
            } else if (this.stacks[5].func_77973_b() == itemstack.func_77973_b()) {
                this.stacks[5].field_77994_a += itemstack.field_77994_a;
            }
            for (int i = 0; i < 5; ++i) {
                if (this.stacks[i] == null) continue;
                --this.stacks[i].field_77994_a;
                if (this.stacks[i].field_77994_a > 0) continue;
                this.stacks[i] = null;
            }
        }
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot != 5;
    }

    public int[] func_180463_a(EnumFacing facing) {
        return facing == EnumFacing.UP ? slotsTop : (facing == EnumFacing.DOWN ? slotsBottom : slotsSides);
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing facing) {
        return slot == 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.infuserBurnTime = tagCompound.func_74765_d("BurnTime");
        this.infuserCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = 600;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.infuserBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.infuserBurnTime);
        return tagCompound;
    }
}

