/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.config;

import java.io.File;
import sblectric.lightningcraft.config.ConfigurationCustom;
import sblectric.lightningcraft.integration.cofh.CoFH;
import sblectric.lightningcraft.ref.Log;

public class LCConfig {
    public static boolean portalEnabled;
    public static int portalCooldown;
    public static boolean demonSoldiersAlwaysNeutral;
    public static boolean useVanillaGhastSounds;
    public static boolean autoSmelt;
    public static boolean autoRepair;
    public static boolean mysticGear;
    public static int underworldDimensionID;
    public static boolean JEIIntegration;
    public static boolean RFIntegration;
    public static int RFtoLEConversion;

    private static void setDefaultValues() {
        portalEnabled = true;
        portalCooldown = 200;
        demonSoldiersAlwaysNeutral = false;
        useVanillaGhastSounds = false;
        autoSmelt = true;
        autoRepair = true;
        mysticGear = true;
        underworldDimensionID = -9;
        JEIIntegration = true;
        RFIntegration = true;
        RFtoLEConversion = 50;
    }

    public static void loadConfig(File f) {
        ConfigurationCustom config = new ConfigurationCustom(f);
        LCConfig.setDefaultValues();
        config.load();
        portalEnabled = config.getBoolean("Portal Enabled", "General", portalEnabled, "Set to false to disable default portal creation.");
        portalCooldown = config.getInt("Portal Cooldown Time", "General", portalCooldown, "The cooldown time for the underworld portal. Increase if repeated teleporting occurs.");
        demonSoldiersAlwaysNeutral = config.getBoolean("Wuss Mode", "General", demonSoldiersAlwaysNeutral, "Set to true if Demon Soldiers should only attack the player if they are attacked first");
        useVanillaGhastSounds = config.getBoolean("Use Vanilla Ghast Sounds", "General", useVanillaGhastSounds, "Whether or not to use the vanilla ghast sounds for the Underghast instead of the provided ones");
        autoSmelt = config.getBoolean("Enable Skyfather Autosmelting", "Tools and Armor", autoSmelt, "Whether or not Skyfather and Mystic tools will auto-smelt mined blocks.");
        autoRepair = config.getBoolean("Enable Mystic Auto-repair", "Tools and Armor", autoRepair, "Whether or not Mystic tools will auto-repair.");
        mysticGear = config.getBoolean("Enable Mystic Gear", "Tools and Armor", autoRepair, "If false, Mystic gear will not be able to be created.");
        underworldDimensionID = config.getInt("Underworld Dimension ID", "Worldgen", underworldDimensionID, "The ID for the Underworld dimension");
        JEIIntegration = config.getBoolean("JEI integration", "Mod Integration", RFIntegration, "Enable JEI integration?");
        RFIntegration = config.getBoolean("RF integration", "Mod Integration", RFIntegration, "Enable LE <-> RF conversion machines?");
        if (!RFIntegration) {
            CoFH.apiLoaded = false;
        }
        RFtoLEConversion = config.getInt("RF to LE conversion", "Mod Integration", RFtoLEConversion, "This amount of RF is equal to 1 LE (for 1 LE -> x RF conversion). The reverse will be 10 times costlier.");
        if (config.hasChanged()) {
            config.save();
        }
        Log.logger.info("Config loaded.");
    }
}

