/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.entities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.ref.Log;
import sblectric.lightningcraft.sounds.LCSoundEvents;

public class EntityUnderworldGhast
extends EntityGhast {
    public EntityUnderworldGhast(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 3.0f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        EntityAIBase remove = null;
        for (EntityAITasks.EntityAITaskEntry task : this.field_70714_bg.field_75782_a) {
            if (!task.field_75733_a.getClass().getSimpleName().equals("AIFireballAttack")) continue;
            remove = task.field_75733_a;
            break;
        }
        if (remove != null) {
            this.field_70714_bg.func_85156_a(remove);
            this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIUnderworldFireballAttack(this));
        } else {
            Log.logger.error(this.func_70005_c_() + " failed to override Ghast fireball AI.");
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.4);
    }

    public int func_175453_cd() {
        return super.func_175453_cd() * 2;
    }

    protected SoundEvent func_184639_G() {
        if (!LCConfig.useVanillaGhastSounds) {
            return LCSoundEvents.underworldGhastMoan;
        }
        return super.func_184639_G();
    }

    protected SoundEvent func_184601_bQ() {
        if (!LCConfig.useVanillaGhastSounds) {
            return LCSoundEvents.underworldGhastHurt;
        }
        return super.func_184601_bQ();
    }

    protected SoundEvent func_184615_bR() {
        if (!LCConfig.useVanillaGhastSounds) {
            return LCSoundEvents.underworldGhastDeath;
        }
        return super.func_184615_bR();
    }

    protected float func_70599_aP() {
        return super.func_70599_aP() * 0.75f;
    }

    protected float func_70647_i() {
        if (!LCConfig.useVanillaGhastSounds) {
            return super.func_70647_i() * 1.125f;
        }
        return super.func_70647_i() * 1.25f;
    }

    public static class AIUnderworldFireballAttack
    extends EntityAIBase {
        private EntityUnderworldGhast parentEntity;
        public int attackTimer;

        public AIUnderworldFireballAttack(EntityUnderworldGhast ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null;
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
            this.parentEntity.func_175454_a(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double d0 = 64.0;
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < d0 * d0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                World world = this.parentEntity.field_70170_p;
                ++this.attackTimer;
                if (this.attackTimer == 10) {
                    if (!LCConfig.useVanillaGhastSounds) {
                        world.func_184133_a(null, new BlockPos((Entity)this.parentEntity), LCSoundEvents.underworldGhastWarn, SoundCategory.HOSTILE, 10.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    } else {
                        world.func_180498_a((EntityPlayer)null, 1015, new BlockPos((Entity)this.parentEntity), 0);
                    }
                }
                if (this.attackTimer == 20) {
                    double d1 = 4.0;
                    Vec3d vec3d = this.parentEntity.func_70676_i(1.0f);
                    double d2 = entitylivingbase.field_70165_t - (this.parentEntity.field_70165_t + vec3d.field_72450_a * d1);
                    double d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (0.5 + this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                    double d4 = entitylivingbase.field_70161_v - (this.parentEntity.field_70161_v + vec3d.field_72449_c * d1);
                    world.func_180498_a((EntityPlayer)null, 1016, new BlockPos((Entity)this.parentEntity), 0);
                    EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    entitylargefireball.field_92057_e = this.parentEntity.func_175453_cd();
                    entitylargefireball.field_70165_t = this.parentEntity.field_70165_t + vec3d.field_72450_a * d1;
                    entitylargefireball.field_70163_u = this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f) + 0.5;
                    entitylargefireball.field_70161_v = this.parentEntity.field_70161_v + vec3d.field_72449_c * d1;
                    world.func_72838_d((Entity)entitylargefireball);
                    this.attackTimer = -30;
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            this.parentEntity.func_175454_a(this.attackTimer > 10);
        }
    }
}

