/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.events;

import java.util.Iterator;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import sblectric.lightningcraft.achievements.LCAchievements;
import sblectric.lightningcraft.enchantments.LCEnchantments;
import sblectric.lightningcraft.entities.EntityLCZombie;
import sblectric.lightningcraft.events.LivingSoulStealEvent;
import sblectric.lightningcraft.items.ItemBlazeSword;
import sblectric.lightningcraft.items.ItemChargedSword;
import sblectric.lightningcraft.items.ItemEnderSword;
import sblectric.lightningcraft.items.ItemFeatherSword;
import sblectric.lightningcraft.items.ItemHammer;
import sblectric.lightningcraft.items.ItemIceSword;
import sblectric.lightningcraft.items.ItemMysticArmor;
import sblectric.lightningcraft.items.ItemSoulSword;
import sblectric.lightningcraft.items.ItemSpecialSword;
import sblectric.lightningcraft.items.ItemZombieSword;
import sblectric.lightningcraft.util.Effect;
import sblectric.lightningcraft.util.IntList;
import sblectric.lightningcraft.util.WorldUtils;

public class CombatEvents {
    private static final Random random = new Random();

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityLivingBase && !event.getEntity().field_70170_p.field_72995_K) {
            this.handleLightningSwordStrike(event);
            this.handleSpecialStrike(event);
            this.handleElecAuraHurt(event);
        }
    }

    public void handleLightningSwordStrike(LivingHurtEvent event) {
        double var;
        double init;
        EntityLivingBase target = (EntityLivingBase)event.getEntity();
        if (target == null || target.func_180431_b(event.getSource())) {
            return;
        }
        EntityLivingBase user = null;
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            user = (EntityLivingBase)event.getSource().func_76346_g();
        }
        if (user == null) {
            return;
        }
        ItemStack weapon = user.func_184586_b(EnumHand.MAIN_HAND);
        if (weapon == null) {
            return;
        }
        int j = EnchantmentHelper.func_77506_a((Enchantment)LCEnchantments.handOfThor, (ItemStack)weapon);
        int m = LCEnchantments.handOfThor.func_77325_b();
        Item w = weapon.func_77973_b();
        int s = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)weapon);
        if (!user.field_70170_p.field_72995_K && user instanceof EntityPlayer && j == 3 && s == 5) {
            ((EntityPlayer)user).func_71064_a((StatBase)LCAchievements.mysticHammer, 1);
        }
        double d = w instanceof ItemChargedSword ? (w instanceof ItemHammer ? 0.5 : 0.15) : (init = 0.0);
        double d2 = w instanceof ItemChargedSword ? (w instanceof ItemHammer ? 0.5 : 0.3) : (var = 0.1);
        if (!user.func_70093_af() && random.nextDouble() < init + var * (double)j / (double)m) {
            Effect.lightning((Entity)target, false);
            weapon.func_77972_a(2, user);
        }
    }

    public void handleElecAuraHurt(LivingHurtEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityLivingBase attacker;
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (event.getSource().func_76346_g() instanceof EntityLivingBase && !(attacker = (EntityLivingBase)event.getSource().func_76346_g()).func_180431_b(event.getSource())) {
                IntList ench = new IntList();
                ItemStack helm = player.func_184582_a(EntityEquipmentSlot.HEAD);
                ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
                ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
                ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
                int lv = 0;
                int a = 0;
                int damageHelm = 0;
                int damageChest = 0;
                int damageLegs = 0;
                int damageBoots = 0;
                if (helm != null) {
                    damageHelm = EnchantmentHelper.func_77506_a((Enchantment)LCEnchantments.elecAura, (ItemStack)helm);
                    ench.add(damageHelm);
                    if (helm.func_77973_b() instanceof ItemMysticArmor) {
                        ++a;
                    }
                }
                if (chest != null) {
                    damageChest = EnchantmentHelper.func_77506_a((Enchantment)LCEnchantments.elecAura, (ItemStack)chest);
                    ench.add(damageChest);
                    if (chest.func_77973_b() instanceof ItemMysticArmor) {
                        ++a;
                    }
                }
                if (legs != null) {
                    damageLegs = EnchantmentHelper.func_77506_a((Enchantment)LCEnchantments.elecAura, (ItemStack)legs);
                    ench.add(damageLegs);
                    if (legs.func_77973_b() instanceof ItemMysticArmor) {
                        ++a;
                    }
                }
                if (boots != null) {
                    damageBoots = EnchantmentHelper.func_77506_a((Enchantment)LCEnchantments.elecAura, (ItemStack)boots);
                    ench.add(damageBoots);
                    if (boots.func_77973_b() instanceof ItemMysticArmor) {
                        ++a;
                    }
                }
                Iterator iterator = ench.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    lv += i;
                }
                if (lv > 0 && random.nextDouble() <= (double)(lv * 2) / 100.0) {
                    Effect.lightning((Entity)attacker, false);
                    if (damageHelm > 0) {
                        helm.func_77972_a(4 * damageHelm, (EntityLivingBase)player);
                    }
                    if (damageChest > 0) {
                        chest.func_77972_a(4 * damageChest, (EntityLivingBase)player);
                    }
                    if (damageLegs > 0) {
                        legs.func_77972_a(4 * damageLegs, (EntityLivingBase)player);
                    }
                    if (damageBoots > 0) {
                        boots.func_77972_a(4 * damageBoots, (EntityLivingBase)player);
                    }
                    if (a >= 4 && lv >= 12) {
                        player.func_71064_a((StatBase)LCAchievements.mysticArmor, 1);
                    }
                }
            }
        }
    }

    public void handleSpecialStrike(LivingHurtEvent event) {
        EntityLivingBase user;
        ItemStack sword;
        EntityLivingBase target = (EntityLivingBase)event.getEntity();
        World world = target.field_70170_p;
        Entity src = event.getSource().func_76346_g();
        float nextHealth = target.func_110143_aJ() - event.getAmount();
        if (event.getAmount() <= 0.0f || target.func_180431_b(event.getSource())) {
            return;
        }
        if (src != null && src instanceof EntityLivingBase && (sword = (user = (EntityLivingBase)src).func_184586_b(EnumHand.MAIN_HAND)) != null && sword.func_77973_b() instanceof ItemSpecialSword) {
            Item w = sword.func_77973_b();
            String effect = null;
            if (w instanceof ItemSoulSword) {
                effect = "soulSteal";
                float health = target.func_110143_aJ();
                float steal = health * 0.15f;
                LivingSoulStealEvent soulEvent = new LivingSoulStealEvent(target, steal);
                if (!MinecraftForge.EVENT_BUS.post((Event)soulEvent)) {
                    steal = soulEvent.getAmount();
                    nextHealth -= steal;
                    target.func_70606_j(health - steal);
                    user.func_70691_i(steal * 0.2515f * (random.nextFloat() + 1.0f));
                }
            } else if (w instanceof ItemZombieSword && (!(target instanceof EntityLCZombie) || ((EntityLCZombie)target).getOwner() != user)) {
                effect = "zombieSummon";
                EntityLCZombie zombie = new EntityLCZombie(world, target, user);
                zombie.func_70107_b(target.field_70165_t + (double)random.nextFloat() - 0.5, target.field_70163_u, target.field_70161_v + (double)random.nextFloat() - 0.5);
                world.func_72838_d((Entity)zombie);
                zombie.func_70642_aH();
            } else if (w instanceof ItemFeatherSword) {
                effect = "featherAttack";
                float knockbackModifier = 10.0f;
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackModifier * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(user.field_70177_z * (float)Math.PI / 180.0f)) * knockbackModifier * 0.5f));
                target.field_70159_w *= 0.6;
                target.field_70179_y *= 0.6;
            } else if (w instanceof ItemEnderSword) {
                double posZ;
                effect = "enderAttack";
                float distance = 2.5f + random.nextFloat();
                double posX = target.field_70165_t + (double)(MathHelper.func_76126_a((float)(target.field_70759_as * (float)Math.PI / 180.0f)) * distance);
                Integer posY = WorldUtils.getOpenSurface(world, (int)posX, (int)(posZ = target.field_70161_v - (double)(MathHelper.func_76134_b((float)(target.field_70759_as * (float)Math.PI / 180.0f)) * distance)), (int)target.field_70163_u, 6);
                if (posY != null) {
                    Effect.ender(world, user.field_70165_t, user.field_70163_u, user.field_70161_v, posX, posY.intValue(), posZ, true);
                    user.field_70177_z = target.field_70759_as;
                    user.field_70759_as = target.field_70759_as;
                    user.func_70634_a(posX, (double)posY.intValue(), posZ);
                }
            } else if (w instanceof ItemBlazeSword) {
                effect = "blazeAttack";
                target.func_70015_d(3600);
            } else if (w instanceof ItemIceSword) {
                effect = "iceAttack";
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 5));
                target.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 60, 128));
            }
            if (effect != null) {
                Effect.specialSword(effect, world, target.field_70165_t, target.field_70163_u, target.field_70161_v);
            }
            if (user instanceof EntityPlayer && nextHealth <= 0.0f) {
                ((EntityPlayer)user).func_71064_a((StatBase)LCAchievements.specialSwordKill, 1);
            }
        }
    }
}

