/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.ref;

import java.awt.Color;

public class Metal {
    public static final String NAME_IRON = "Iron";
    public static final String NAME_STEEL = "Steel";
    public static final String NAME_LEAD = "Lead";
    public static final String NAME_TIN = "Tin";
    public static final String NAME_ALUM = "Aluminum";
    public static final String NAME_GOLD = "Gold";
    public static final String NAME_COPPER = "Copper";
    public static final String NAME_ELEC = "Electricium";
    public static final String NAME_SKY = "Skyfather";
    public static final String NAME_MYSTIC = "Mystic";
    private static final String NAME_DEFAULT = "[none]";
    public static final int COLOR_IRON = new Color(197, 197, 197).getRGB();
    public static final int COLOR_STEEL = new Color(133, 133, 133).getRGB();
    public static final int COLOR_LEAD = new Color(98, 111, 119).getRGB();
    public static final int COLOR_TIN = new Color(216, 213, 203).getRGB();
    public static final int COLOR_ALUM = new Color(227, 227, 227).getRGB();
    public static final int COLOR_GOLD = new Color(232, 206, 95).getRGB();
    public static final int COLOR_COPPER = new Color(234, 134, 46).getRGB();
    public static final int COLOR_ELEC = new Color(179, 255, 255).getRGB();
    public static final int COLOR_SKY = new Color(44, 44, 44).getRGB();
    public static final int COLOR_MYSTIC = new Color(174, 43, 30).getRGB();
    private static final int COLOR_DEFAULT = Color.WHITE.getRGB();

    public static class Plate
    extends Rod {
        public static String getPlateFromMeta(int meta) {
            return "plate" + Plate.getNameFromMeta(meta);
        }
    }

    public static class Rod
    extends Base {
        public static final int count = 10;
        public static final int IRON = 0;
        public static final int STEEL = 1;
        public static final int LEAD = 2;
        public static final int TIN = 3;
        public static final int ALUM = 4;
        public static final int GOLD = 5;
        public static final int COPPER = 6;
        public static final int ELEC = 7;
        public static final int SKY = 8;
        public static final int MYSTIC = 9;

        public static String getNameFromMeta(int meta) {
            switch (meta) {
                case 0: {
                    return Metal.NAME_IRON;
                }
                case 1: {
                    return Metal.NAME_STEEL;
                }
                case 2: {
                    return Metal.NAME_LEAD;
                }
                case 3: {
                    return Metal.NAME_TIN;
                }
                case 4: {
                    return Metal.NAME_ALUM;
                }
                case 5: {
                    return Metal.NAME_GOLD;
                }
                case 6: {
                    return Metal.NAME_COPPER;
                }
                case 7: {
                    return Metal.NAME_ELEC;
                }
                case 8: {
                    return Metal.NAME_SKY;
                }
                case 9: {
                    return Metal.NAME_MYSTIC;
                }
            }
            return Metal.NAME_DEFAULT;
        }

        public static String getIngotFromMeta(int meta) {
            return "ingot" + Rod.getNameFromMeta(meta);
        }

        public static String getRodFromMeta(int meta) {
            return "rod" + Rod.getNameFromMeta(meta);
        }

        public static int getColorFromMeta(int meta) {
            switch (meta) {
                case 0: {
                    return COLOR_IRON;
                }
                case 1: {
                    return COLOR_STEEL;
                }
                case 2: {
                    return COLOR_LEAD;
                }
                case 3: {
                    return COLOR_TIN;
                }
                case 4: {
                    return COLOR_ALUM;
                }
                case 5: {
                    return COLOR_GOLD;
                }
                case 6: {
                    return COLOR_COPPER;
                }
                case 7: {
                    return COLOR_ELEC;
                }
                case 8: {
                    return COLOR_SKY;
                }
                case 9: {
                    return COLOR_MYSTIC;
                }
            }
            return COLOR_DEFAULT;
        }
    }

    public static class Dust
    extends Ingot {
        public static String getDustFromMeta(int meta) {
            return "dust" + Dust.getNameFromMeta(meta);
        }
    }

    public static class Nugget
    extends Ingot {
        public static String getNuggetFromMeta(int meta) {
            return "nugget" + Nugget.getNameFromMeta(meta);
        }
    }

    public static class MBlock
    extends Ingot {
        public static String getBlockFromMeta(int meta) {
            return "block" + MBlock.getNameFromMeta(meta);
        }
    }

    public static class Ingot
    extends Base {
        public static final int count = 3;
        public static final int ELEC = 0;
        public static final int SKY = 1;
        public static final int MYSTIC = 2;

        public static String getNameFromMeta(int meta) {
            switch (meta) {
                case 0: {
                    return Metal.NAME_ELEC;
                }
                case 1: {
                    return Metal.NAME_SKY;
                }
                case 2: {
                    return Metal.NAME_MYSTIC;
                }
            }
            return Metal.NAME_DEFAULT;
        }

        public static String getIngotFromMeta(int meta) {
            return "ingot" + Ingot.getNameFromMeta(meta);
        }

        public static int getColorFromMeta(int meta) {
            switch (meta) {
                case 0: {
                    return COLOR_ELEC;
                }
                case 1: {
                    return COLOR_SKY;
                }
                case 2: {
                    return COLOR_MYSTIC;
                }
            }
            return COLOR_DEFAULT;
        }
    }

    private static class Base {
        private Base() {
        }
    }
}

