/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.tiles;

import cofh.api.energy.IEnergyReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.tiles.TileEntityRF;
import sblectric.lightningcraft.util.Effect;
import sblectric.lightningcraft.util.RFStorage;

@Optional.Interface(iface="cofh.api.energy.IEnergyReceiver", modid="CoFHAPI")
public class TileEntityRFReceiver
extends TileEntityRF
implements IEnergyReceiver {
    public static final int maxStorage = 100000;
    public static final int rfPerTick = 512;
    private RFStorage storage = new RFStorage(100000, 512, 0);

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.hasLPCell() && !this.isRemotelyPowered() && this.field_145850_b.func_82737_E() % 100L == 0L && !this.field_145850_b.func_175640_z(this.field_174879_c) && this.storage.getEnergyStored() >= LCConfig.RFtoLEConversion * 10 * 100 && this.cellPower < this.maxPower - 100.0 * this.tileCell.efficiency) {
            Effect.lightningGen(this.field_145850_b, this.tileCell.func_174877_v().func_177984_a());
            this.storage.modifyEnergyStored(-LCConfig.RFtoLEConversion * 10 * 100);
            this.func_70296_d();
        }
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int receiveEnergy(EnumFacing from, int toReceive, boolean simulate) {
        if (!simulate) {
            this.func_70296_d();
        }
        return this.storage.receiveEnergy(toReceive, simulate);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.storage.writeToNBT(tagCompound);
        return tagCompound;
    }
}

