/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import sblectric.lightningcraft.LightningCraft;
import sblectric.lightningcraft.blocks.base.BlockContainerLCMeta;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.items.blocks.ItemBlockLightningCell;
import sblectric.lightningcraft.tiles.TileEntityLightningCell;

public class BlockLightningCell
extends BlockContainerLCMeta {
    public static final int nCells = 4;
    private double[] maxPower = new double[]{1000.0, 5000.0, 20000.0, 100000.0};

    public BlockLightningCell() {
        super((Block)LCBlocks.metalBlock, 4, 6.5f, 40.0f);
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileEntityLightningCell(this.maxPower[meta % 4], I18n.func_74838_a((String)(this.func_149739_a() + "_" + meta + ".name")), meta % 4 >= 3);
    }

    public int getMaxPower(IBlockState state) {
        return (int)this.maxPower[this.func_176201_c(state) % 4];
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        player.openGui((Object)LightningCraft.modInstance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    @Override
    public Class getItemClass() {
        return ItemBlockLightningCell.class;
    }
}

