/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.recipes;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import sblectric.lightningcraft.api.recipes.LightningInfusionRecipe;
import sblectric.lightningcraft.api.util.JointList;
import sblectric.lightningcraft.api.util.StackHelper;
import sblectric.lightningcraft.config.LCConfig;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.init.LCPotions;
import sblectric.lightningcraft.util.LCMisc;

public class LightningInfusionRecipes {
    private static LightningInfusionRecipes instance = new LightningInfusionRecipes();
    private int recipeIndex = 0;
    private JointList<LightningInfusionRecipe> recipes = new JointList();
    private int lastResultCost = -2;
    private static final int ANY = Short.MAX_VALUE;

    public static LightningInfusionRecipes instance() {
        return instance;
    }

    private LightningInfusionRecipes() {
        this.addDefaultRecipes();
    }

    private void addDefaultRecipes() {
        ItemStack thunderstone = new ItemStack((Block)LCBlocks.stoneBlock, 1, 0);
        ItemStack demonBlood = new ItemStack((Item)LCItems.material, 1, 5);
        ItemStack ichor = new ItemStack((Item)LCItems.material, 1, 11);
        ItemStack prismarine = new ItemStack(Blocks.field_180397_cI, 1, Short.MAX_VALUE);
        ItemStack wool = new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE);
        String dust = "dustMystic";
        this.addRecipe(new ItemStack((Block)Blocks.field_150330_I), 10, "treeSapling", Blocks.field_150354_m);
        this.addRecipe(new ItemStack(Blocks.field_150435_aG, 3), 15, Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150354_m, Items.field_151068_bn);
        this.addRecipe(new ItemStack(Blocks.field_150360_v), 10, wool, "slimeball");
        this.addRecipe(new ItemStack(Blocks.field_150403_cj), 15, Blocks.field_150432_aD, LCMisc.makeArray(Blocks.field_150432_aD, 3));
        this.addRecipe(new ItemStack(Blocks.field_150341_Y), 10, "cobblestone", Blocks.field_150395_bd);
        this.addRecipe(new ItemStack(Blocks.field_150342_X, 2), 10, "logWood", LCMisc.makeArray(Items.field_151122_aG, 4));
        this.addRecipe(new ItemStack(Items.field_151128_bU), 40, new ItemStack(Blocks.field_150348_b, 1, 1), LCMisc.makeArray(new ItemStack(Blocks.field_150348_b, 1, 3), 2));
        this.addRecipe(new ItemStack(Items.field_151045_i), 50, Blocks.field_150402_ci, LCMisc.makeArray(Items.field_151044_h, 4));
        this.addRecipe(new ItemStack(Items.field_151166_bC), 75, prismarine, LCMisc.makeArray(Items.field_179563_cD, 4));
        this.addRecipe(new ItemStack((Item)LCItems.ingot, 1, 0), 30, "ingotIron", "ingotGold", "gemDiamond");
        this.addRecipe(new ItemStack((Block)LCBlocks.metalBlock, 1, 0), 270, "blockIron", "blockGold", "blockDiamond");
        int spCost = 90;
        this.addRecipe(new ItemStack((Item)LCItems.soulSword), spCost, Items.field_151052_q, LCMisc.makeArray(Blocks.field_150425_aM, 4));
        this.addRecipe(new ItemStack((Item)LCItems.zombieSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151078_bh, 4));
        this.addRecipe(new ItemStack((Item)LCItems.featherSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151008_G, 4));
        this.addRecipe(new ItemStack((Item)LCItems.enderSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151079_bi, 4));
        this.addRecipe(new ItemStack((Item)LCItems.blazeSword), spCost, Items.field_151052_q, LCMisc.makeArray(Items.field_151072_bj, 4));
        this.addRecipe(new ItemStack((Item)LCItems.iceSword), spCost, Items.field_151052_q, LCMisc.makeArray(Blocks.field_150403_cj, 4));
        this.addRecipe(new ItemStack((Item)LCItems.ingot, 1, 1), 85, "ingotElectricium", thunderstone, Items.field_151061_bv, thunderstone, Items.field_151061_bv);
        this.addRecipe(new ItemStack(Items.field_151129_at), 40, Items.field_151131_as, LCMisc.makeArray(demonBlood, 4));
        this.addRecipe(new ItemStack(Blocks.field_150424_aL, 2), 15, "cobblestone", demonBlood);
        this.addRecipe(new ItemStack(Blocks.field_150385_bj), 25, Blocks.field_150336_V, demonBlood);
        this.addRecipe(new ItemStack(Items.field_151075_bm, 2), 20, Items.field_151014_N, demonBlood);
        this.addRecipe(new ItemStack((Block)LCBlocks.stoneBlock, 1, 3), 35, new ItemStack((Block)LCBlocks.stoneBlock, 1, 0), demonBlood, demonBlood);
        this.addRecipe(new ItemStack((Item)LCItems.material, 1, 6), 100, Items.field_151059_bz, "dustDiamond", demonBlood, Blocks.field_150343_Z);
        this.addRecipe(new ItemStack((Item)LCItems.material, 1, 6), 40, Blocks.field_150343_Z, demonBlood, new ItemStack((Item)LCItems.material, 1, 13));
        this.addRecipe(new ItemStack((Item)LCItems.material, 1, 9), 250, new ItemStack((Item)LCItems.material, 1, 4), "dustDiamond", demonBlood, new ItemStack((Item)LCItems.material, 1, 8), demonBlood);
        this.addRecipe(new ItemStack((Item)LCItems.material, 4, 13), 50, "dustElectricium", LCMisc.makeArray(new ItemStack((Item)LCItems.material, 1, 12), 4));
        this.addRecipe(new ItemStack((Item)LCItems.material, 4, 14), 100, "dustMystic", LCMisc.makeArray(new ItemStack((Item)LCItems.material, 1, 13), 4));
        ItemStack mundane = LCPotions.getPotionWithType(PotionTypes.field_185231_c);
        ItemStack normalDemon = LCPotions.getPotionWithType(LCPotions.demonFriendNormal);
        ItemStack extendedDemon = LCPotions.getPotionWithType(LCPotions.demonFriendExtended);
        this.addRecipe(normalDemon, 50, mundane, demonBlood, Items.field_151150_bK, demonBlood, Items.field_151150_bK).setNBTSensitive();
        this.addRecipe(extendedDemon, 25, normalDemon, LCMisc.makeArray("dustRedstone", 4)).setNBTSensitive();
        this.addRecipe(new ItemStack((Item)LCItems.ingot, 2, 2), 160, "ingotSkyfather", "nuggetNetherStar", demonBlood, ichor, demonBlood);
        if (LCConfig.mysticGear) {
            this.addRecipe(new ItemStack((Item)LCItems.mysticHammer), 360, LCItems.skyHammer, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticSword), 300, LCItems.skySword, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticPick), 240, LCItems.skyPick, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticAxe), 240, LCItems.skyAxe, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticShovel), 240, LCItems.skyShovel, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticHoe), 200, LCItems.skyHoe, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticHelm), 240, LCItems.skyHelm, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticChest), 360, LCItems.skyChest, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticLegs), 300, LCItems.skyLegs, LCMisc.makeArray(dust, 4));
            this.addRecipe(new ItemStack((Item)LCItems.mysticBoots), 240, LCItems.skyBoots, LCMisc.makeArray(dust, 4));
        }
    }

    public LightningInfusionRecipe addRecipe(LightningInfusionRecipe r) {
        this.recipes.add(r);
        ++this.recipeIndex;
        return r;
    }

    public LightningInfusionRecipe addRecipe(@Nonnull ItemStack output, int cost, Object infuse, Object ... surrounding) {
        return this.addRecipe(new LightningInfusionRecipe(output, cost, infuse, surrounding));
    }

    private boolean hasResult(@Nonnull ItemStack infuse, String item, List<String> itemOres, boolean nbtSensitive) {
        String newInfuse;
        String useItem = StackHelper.makeStringFromItemStack(infuse);
        if (!nbtSensitive) {
            useItem = StackHelper.stripNBTFromString(useItem);
            item = StackHelper.stripNBTFromString(item);
        }
        if (item.equals(useItem) || itemOres.contains(useItem)) {
            return true;
        }
        if (StackHelper.getMetaFromString(item) == Short.MAX_VALUE && (newInfuse = StackHelper.stripMetaFromString(item)).equals(StackHelper.stripMetaFromString(useItem))) {
            return true;
        }
        for (String s : itemOres) {
            String cutInfuseOre;
            if (StackHelper.getMetaFromString(s) != Short.MAX_VALUE || !(cutInfuseOre = StackHelper.stripMetaFromString(s)).equals(StackHelper.stripMetaFromString(useItem))) continue;
            return true;
        }
        return false;
    }

    public boolean hasBaseResult(@Nonnull ItemStack infuse1) {
        if (infuse1.func_190926_b()) {
            return false;
        }
        ItemStack infuse = infuse1.func_77946_l();
        infuse.func_190920_e(1);
        for (LightningInfusionRecipe recipe : this.recipes) {
            if (!this.hasResult(infuse, recipe.getInfuseItem(), recipe.getInfuseItemAsOre(), recipe.getNBTSensitive())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack getInfusionResult(@Nonnull ItemStack infuse1, ItemStack ... stacks1) {
        if (stacks1.length != 4) {
            return ItemStack.field_190927_a;
        }
        ItemStack infuse = infuse1.func_77946_l();
        infuse.func_190920_e(1);
        JointList stacks = new JointList();
        for (int s = 0; s < stacks1.length; ++s) {
            if (!stacks1[s].func_190926_b()) {
                ItemStack current = stacks1[s].func_77946_l();
                current.func_190920_e(1);
                stacks.add(current);
                continue;
            }
            stacks.add(ItemStack.field_190927_a);
        }
        for (LightningInfusionRecipe recipe : this.recipes) {
            int valid = 0;
            JointList itemList = new JointList();
            JointList oreList = new JointList();
            for (String string : recipe.getItems()) {
                String string2 = StackHelper.stripNBTFromString(string);
                itemList.add(string2);
            }
            for (List list : recipe.getItemsAsOres()) {
                oreList.add(list);
            }
            if (this.hasResult(infuse, recipe.getInfuseItem(), recipe.getInfuseItemAsOre(), recipe.getNBTSensitive())) {
                ++valid;
            }
            for (ItemStack itemStack : stacks) {
                String stackString = itemStack.func_190926_b() ? "NULL" : StackHelper.makeStringFromItemStack(itemStack);
                String modStackString = StackHelper.changeStringMeta(stackString, Short.MAX_VALUE);
                modStackString = StackHelper.stripNBTFromString(modStackString);
                if (itemList.contains(stackString)) {
                    itemList.remove(stackString);
                    ++valid;
                    continue;
                }
                if (itemList.contains(modStackString)) {
                    itemList.remove(modStackString);
                    ++valid;
                    continue;
                }
                List matchList = LCMisc.listListContains(oreList, stackString);
                if (matchList != null) {
                    oreList.remove(matchList);
                    ++valid;
                    continue;
                }
                matchList = LCMisc.listListContains(oreList, modStackString);
                if (matchList == null) continue;
                oreList.remove(matchList);
                ++valid;
            }
            if (valid != 5) continue;
            this.lastResultCost = recipe.getCost();
            return recipe.getOutput().func_77946_l();
        }
        this.lastResultCost = -2;
        return ItemStack.field_190927_a;
    }

    public int getLastResultCost() {
        return this.lastResultCost;
    }

    public final List<LightningInfusionRecipe> getRecipeList() {
        return this.recipes;
    }
}

