/*
 * Decompiled with CFR 0.152.
 */
package sblectric.lightningcraft.worldgen.structure.underworld;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import sblectric.lightningcraft.entities.EntityUnderworldSkeleton;
import sblectric.lightningcraft.init.LCBlocks;
import sblectric.lightningcraft.init.LCEnchantments;
import sblectric.lightningcraft.init.LCItems;
import sblectric.lightningcraft.ref.RefMisc;
import sblectric.lightningcraft.util.IntList;
import sblectric.lightningcraft.util.LCMisc;
import sblectric.lightningcraft.util.WeightedRandomChestContent;
import sblectric.lightningcraft.util.WorldUtils;
import sblectric.lightningcraft.worldgen.structure.Feature;
import sblectric.lightningcraft.worldgen.structure.LootChestGroup;

public class UnderworldTower
extends Feature {
    private static final int nChests = 4;
    private static final int minStacks = 3;
    private static final int maxStacks = 6;
    private static final Block stairBlock = LCBlocks.demonStairs;
    private static final Block mainBlock;
    private static final int mainMeta = 1;
    private static final Block roofBlock;
    private static final int roofMeta = 4;
    private static final Block lightBlock;
    private static final Block windowBlock;
    private static final Block slabBlock;
    private static final int slabMeta = 1;
    private static final Block cannonBlock;

    public UnderworldTower() {
        this(new Random(), 0, 0);
    }

    public UnderworldTower(Random rand, int par2, int par3) {
        super(rand, par2, 64, par3, 11, 25, 11);
        this.spawnMinY = 32;
        this.spawnMaxY = 180;
        ItemStack bookThor = new ItemStack((Item)Items.field_151134_bR);
        ItemStack bookAura = new ItemStack((Item)Items.field_151134_bR);
        Items.field_151134_bR.func_92115_a(bookThor, new EnchantmentData((Enchantment)LCEnchantments.handOfThor, 1));
        Items.field_151134_bR.func_92115_a(bookAura, new EnchantmentData((Enchantment)LCEnchantments.elecAura, 1));
        WeightedRandomChestContent contentBookThor = new WeightedRandomChestContent(null, 0, 1, 2, 2);
        contentBookThor.theItemId = bookThor;
        WeightedRandomChestContent contentBookAura = new WeightedRandomChestContent(null, 0, 1, 2, 2);
        contentBookAura.theItemId = bookAura;
        this.lootChests = new LootChestGroup(4, 3, 6, new WeightedRandomChestContent[]{new WeightedRandomChestContent(LCItems.material, 5, 1, 3, 5), new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 5, 20), new WeightedRandomChestContent(Items.field_151043_k, 0, 2, 7, 20), new WeightedRandomChestContent(Items.field_151166_bC, 0, 1, 3, 20), new WeightedRandomChestContent(Items.field_151059_bz, 0, 4, 6, 15), new WeightedRandomChestContent(Items.field_151042_j, 0, 3, 7, 20), new WeightedRandomChestContent((Item)LCItems.elecBoots, 0, 1, 1, 1), new WeightedRandomChestContent((Item)LCItems.elecLegs, 0, 1, 1, 1), new WeightedRandomChestContent((Item)LCItems.elecHelm, 0, 1, 1, 1), new WeightedRandomChestContent((Item)LCItems.elecChest, 0, 1, 1, 1), new WeightedRandomChestContent((Item)LCItems.elecSword, 0, 1, 1, 1), new WeightedRandomChestContent(LCItems.ingot, 1, 1, 1, 1), new WeightedRandomChestContent(LCItems.ingot, 0, 1, 5, 10), contentBookThor, contentBookAura});
    }

    @Override
    protected boolean findSpawnPosition(World world, StructureBoundingBox box, int yoff) {
        if (this.structY >= 0) {
            if (RefMisc.DEBUG) {
                System.out.println("Structure already exists @ (" + this.field_74887_e.field_78897_a + ", " + this.field_74887_e.field_78896_c + ")");
            }
            return true;
        }
        int failed = 0;
        int x = WorldUtils.getStructureCenter(this.field_74887_e).func_177958_n();
        int z = WorldUtils.getStructureCenter(this.field_74887_e).func_177952_p();
        if (RefMisc.DEBUG) {
            System.out.println("Spawn check initiated at  (" + x + "," + z + ")");
        }
        IntList yPoints = new IntList();
        for (int l = this.field_74887_e.field_78896_c; l <= this.field_74887_e.field_78892_f; ++l) {
            for (int i1 = this.field_74887_e.field_78897_a; i1 <= this.field_74887_e.field_78893_d; ++i1) {
                Integer y = WorldUtils.getOpenSurfaceCentered(world, i1, l, (this.spawnMaxY + this.spawnMinY) / 2 - 2, (this.spawnMaxY - this.spawnMinY) / 2, true);
                if (y == null) {
                    if (++failed <= 10) continue;
                    if (RefMisc.DEBUG) {
                        System.out.println("Spawn failed: too many invalid points");
                    }
                    return false;
                }
                yPoints.add(y);
            }
        }
        int variance = yPoints.variance();
        if (variance > 10) {
            if (RefMisc.DEBUG) {
                System.out.println("Spawn failed: too much terrain variance");
            }
            return false;
        }
        if (yPoints.isEmpty()) {
            if (RefMisc.DEBUG) {
                System.out.println("Spawn failed: no points valid");
            }
            return false;
        }
        this.structY = yPoints.min();
        if (RefMisc.DEBUG) {
            System.out.println("Spawn succeeded at (" + x + "," + this.structY + "," + z + ")");
        }
        this.field_74887_e.func_78886_a(0, this.structY - this.field_74887_e.field_78895_b + yoff, 0);
        return true;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
        if (!this.findSpawnPosition(world, box, 0)) {
            return false;
        }
        int i = LCMisc.getMetadataWithOffsetStairs(this.func_186165_e(), 2);
        int j = LCMisc.getMetadataWithOffsetStairs(this.func_186165_e(), 3);
        int k = LCMisc.getMetadataWithOffsetStairs(this.func_186165_e(), 0);
        int l = LCMisc.getMetadataWithOffsetStairs(this.func_186165_e(), 1);
        int i1 = i + 4;
        int j1 = j + 4;
        int k1 = k + 4;
        int l1 = l + 4;
        this.addBlock(world, 0, 4, 4, stairBlock, k1);
        this.addBlock(world, 0, 4, 6, stairBlock, k1);
        this.addBlock(world, 0, 5, 5, stairBlock, k);
        this.addBlock(world, 0, 12, 4, stairBlock, k1);
        this.addBlock(world, 0, 12, 6, stairBlock, k1);
        this.addBlock(world, 0, 13, 5, stairBlock, k);
        this.addBlock(world, 0, 17, 3, roofBlock, 4);
        this.addBlock(world, 0, 17, 4, roofBlock, 4);
        this.addBlock(world, 0, 17, 5, roofBlock, 4);
        this.addBlock(world, 0, 17, 6, roofBlock, 4);
        this.addBlock(world, 0, 17, 7, roofBlock, 4);
        this.addBlock(world, 0, 18, 4, roofBlock, 4);
        this.addBlock(world, 0, 18, 5, roofBlock, 4);
        this.addBlock(world, 0, 18, 6, roofBlock, 4);
        this.addBlock(world, 1, 0, 4, mainBlock, 1);
        this.addBlock(world, 1, 0, 5, mainBlock, 1);
        this.addBlock(world, 1, 0, 6, mainBlock, 1);
        this.addBlock(world, 1, 1, 4, mainBlock, 1);
        this.addBlock(world, 1, 1, 5, mainBlock, 1);
        this.addBlock(world, 1, 1, 6, mainBlock, 1);
        this.addBlock(world, 1, 2, 4, mainBlock, 1);
        this.addBlock(world, 1, 2, 5, mainBlock, 1);
        this.addBlock(world, 1, 2, 6, mainBlock, 1);
        this.addBlock(world, 1, 3, 4, mainBlock, 1);
        this.addBlock(world, 1, 3, 5, windowBlock, 0);
        this.addBlock(world, 1, 3, 6, mainBlock, 1);
        this.addBlock(world, 1, 4, 4, mainBlock, 1);
        this.addBlock(world, 1, 4, 5, windowBlock, 0);
        this.addBlock(world, 1, 4, 6, mainBlock, 1);
        this.addBlock(world, 1, 5, 4, mainBlock, 1);
        this.addBlock(world, 1, 5, 5, mainBlock, 1);
        this.addBlock(world, 1, 5, 6, mainBlock, 1);
        this.addBlock(world, 1, 6, 4, mainBlock, 1);
        this.addBlock(world, 1, 6, 5, mainBlock, 1);
        this.addBlock(world, 1, 6, 6, mainBlock, 1);
        this.addBlock(world, 1, 7, 4, mainBlock, 1);
        this.addBlock(world, 1, 7, 5, mainBlock, 1);
        this.addBlock(world, 1, 7, 6, mainBlock, 1);
        this.addBlock(world, 1, 8, 4, mainBlock, 1);
        this.addBlock(world, 1, 8, 5, mainBlock, 1);
        this.addBlock(world, 1, 8, 6, mainBlock, 1);
        this.addBlock(world, 1, 9, 4, mainBlock, 1);
        this.addBlock(world, 1, 9, 5, mainBlock, 1);
        this.addBlock(world, 1, 9, 6, mainBlock, 1);
        this.addBlock(world, 1, 10, 4, mainBlock, 1);
        this.addBlock(world, 1, 10, 5, mainBlock, 1);
        this.addBlock(world, 1, 10, 6, mainBlock, 1);
        this.addBlock(world, 1, 11, 4, mainBlock, 1);
        this.addBlock(world, 1, 11, 5, windowBlock, 0);
        this.addBlock(world, 1, 11, 6, mainBlock, 1);
        this.addBlock(world, 1, 12, 4, mainBlock, 1);
        this.addBlock(world, 1, 12, 5, windowBlock, 0);
        this.addBlock(world, 1, 12, 6, mainBlock, 1);
        this.addBlock(world, 1, 13, 4, mainBlock, 1);
        this.addBlock(world, 1, 13, 5, mainBlock, 1);
        this.addBlock(world, 1, 13, 6, mainBlock, 1);
        this.addBlock(world, 1, 14, 4, mainBlock, 1);
        this.addBlock(world, 1, 14, 5, mainBlock, 1);
        this.addBlock(world, 1, 14, 6, mainBlock, 1);
        this.addBlock(world, 1, 15, 4, mainBlock, 1);
        this.addBlock(world, 1, 15, 5, mainBlock, 1);
        this.addBlock(world, 1, 15, 6, mainBlock, 1);
        this.addBlock(world, 1, 16, 4, mainBlock, 1);
        this.addBlock(world, 1, 16, 5, mainBlock, 1);
        this.addBlock(world, 1, 16, 6, mainBlock, 1);
        this.addBlock(world, 1, 17, 2, roofBlock, 4);
        this.addBlock(world, 1, 17, 3, roofBlock, 4);
        this.addBlock(world, 1, 17, 4, 0, 0);
        this.addBlock(world, 1, 17, 6, 0, 0);
        this.addBlock(world, 1, 17, 7, roofBlock, 4);
        this.addBlock(world, 1, 17, 8, roofBlock, 4);
        this.addBlock(world, 1, 18, 3, roofBlock, 4);
        this.addBlock(world, 1, 18, 4, 0, 0);
        this.addBlock(world, 1, 18, 5, 0, 0);
        this.addBlock(world, 1, 18, 6, 0, 0);
        this.addBlock(world, 1, 18, 7, roofBlock, 4);
        this.addBlock(world, 1, 19, 4, roofBlock, 4);
        this.addBlock(world, 1, 19, 5, roofBlock, 4);
        this.addBlock(world, 1, 19, 6, roofBlock, 4);
        this.addBlock(world, 2, 0, 3, mainBlock, 1);
        this.addBlock(world, 2, 0, 4, mainBlock, 1);
        this.addBlock(world, 2, 0, 5, mainBlock, 1);
        this.addBlock(world, 2, 0, 6, mainBlock, 1);
        this.addBlock(world, 2, 0, 7, mainBlock, 1);
        this.addBlock(world, 2, 1, 3, mainBlock, 1);
        this.addBlock(world, 2, 1, 4, 0, 0);
        this.addBlock(world, 2, 1, 5, 0, 0);
        this.addBlock(world, 2, 1, 6, 0, 0);
        this.addBlock(world, 2, 1, 7, mainBlock, 1);
        this.addBlock(world, 2, 2, 3, mainBlock, 1);
        this.addBlock(world, 2, 2, 4, 0, 0);
        this.addBlock(world, 2, 2, 5, 0, 0);
        this.addBlock(world, 2, 2, 6, 0, 0);
        this.addBlock(world, 2, 2, 7, mainBlock, 1);
        this.addBlock(world, 2, 3, 3, mainBlock, 1);
        this.addBlock(world, 2, 3, 4, 0, 0);
        this.addBlock(world, 2, 3, 5, 0, 0);
        this.addBlock(world, 2, 3, 6, 0, 0);
        this.addBlock(world, 2, 3, 7, mainBlock, 1);
        this.addBlock(world, 2, 4, 3, mainBlock, 1);
        this.addBlock(world, 2, 4, 4, 0, 0);
        this.addBlock(world, 2, 4, 5, 0, 0);
        this.addBlock(world, 2, 4, 6, 0, 0);
        this.addBlock(world, 2, 4, 7, mainBlock, 1);
        this.addBlock(world, 2, 5, 3, mainBlock, 1);
        this.addBlock(world, 2, 5, 4, 0, 0);
        this.addBlock(world, 2, 5, 5, 0, 0);
        this.addBlock(world, 2, 5, 6, 0, 0);
        this.addBlock(world, 2, 5, 7, mainBlock, 1);
        this.addBlock(world, 2, 6, 3, mainBlock, 1);
        this.addBlock(world, 2, 6, 4, 0, 0);
        this.addBlock(world, 2, 6, 5, 0, 0);
        this.addBlock(world, 2, 6, 6, 0, 0);
        this.addBlock(world, 2, 6, 7, mainBlock, 1);
        this.addBlock(world, 2, 7, 3, mainBlock, 1);
        this.addBlock(world, 2, 7, 4, slabBlock, 1);
        this.addBlock(world, 2, 7, 5, slabBlock, 9);
        this.addBlock(world, 2, 7, 6, 0, 0);
        this.addBlock(world, 2, 7, 7, mainBlock, 1);
        this.addBlock(world, 2, 8, 3, mainBlock, 1);
        this.addBlock(world, 2, 8, 4, 0, 0);
        this.addBlock(world, 2, 8, 5, 0, 0);
        this.addBlock(world, 2, 8, 6, slabBlock, 1);
        this.addBlock(world, 2, 8, 7, mainBlock, 1);
        this.addBlock(world, 2, 9, 3, mainBlock, 1);
        this.addBlock(world, 2, 9, 4, 0, 0);
        this.addBlock(world, 2, 9, 5, 0, 0);
        this.addBlock(world, 2, 9, 6, 0, 0);
        this.addBlock(world, 2, 9, 7, mainBlock, 1);
        this.addBlock(world, 2, 10, 3, mainBlock, 1);
        this.addBlock(world, 2, 10, 4, 0, 0);
        this.addBlock(world, 2, 10, 5, 0, 0);
        this.addBlock(world, 2, 10, 6, 0, 0);
        this.addBlock(world, 2, 10, 7, mainBlock, 1);
        this.addBlock(world, 2, 11, 3, mainBlock, 1);
        this.addBlock(world, 2, 11, 4, 0, 0);
        this.addBlock(world, 2, 11, 5, 0, 0);
        this.addBlock(world, 2, 11, 6, 0, 0);
        this.addBlock(world, 2, 11, 7, mainBlock, 1);
        this.addBlock(world, 2, 12, 3, mainBlock, 1);
        this.addBlock(world, 2, 12, 4, 0, 0);
        this.addBlock(world, 2, 12, 5, 0, 0);
        this.addBlock(world, 2, 12, 6, 0, 0);
        this.addBlock(world, 2, 12, 7, mainBlock, 1);
        this.addBlock(world, 2, 13, 3, mainBlock, 1);
        this.addBlock(world, 2, 13, 4, 0, 0);
        this.addBlock(world, 2, 13, 5, 0, 0);
        this.addBlock(world, 2, 13, 6, 0, 0);
        this.addBlock(world, 2, 13, 7, mainBlock, 1);
        this.addBlock(world, 2, 14, 3, mainBlock, 1);
        this.addBlock(world, 2, 14, 4, 0, 0);
        this.addBlock(world, 2, 14, 5, 0, 0);
        this.addBlock(world, 2, 14, 6, 0, 0);
        this.addBlock(world, 2, 14, 7, mainBlock, 1);
        this.addBlock(world, 2, 15, 3, mainBlock, 1);
        this.addBlock(world, 2, 15, 4, slabBlock, 1);
        this.addBlock(world, 2, 15, 5, slabBlock, 9);
        this.addBlock(world, 2, 15, 6, 0, 0);
        this.addBlock(world, 2, 15, 7, mainBlock, 1);
        this.addBlock(world, 2, 16, 3, mainBlock, 1);
        this.addBlock(world, 2, 16, 4, 0, 0);
        this.addBlock(world, 2, 16, 5, 0, 0);
        this.addBlock(world, 2, 16, 6, slabBlock, 1);
        this.addBlock(world, 2, 16, 7, mainBlock, 1);
        this.addBlock(world, 2, 17, 1, roofBlock, 4);
        this.addBlock(world, 2, 17, 2, roofBlock, 4);
        this.addBlock(world, 2, 17, 3, 0, 0);
        this.addBlock(world, 2, 17, 4, 0, 0);
        this.addBlock(world, 2, 17, 5, 0, 0);
        this.addBlock(world, 2, 17, 6, 0, 0);
        this.addBlock(world, 2, 17, 7, 0, 0);
        this.addBlock(world, 2, 17, 8, roofBlock, 4);
        this.addBlock(world, 2, 17, 9, roofBlock, 4);
        this.addBlock(world, 2, 18, 2, roofBlock, 4);
        this.addBlock(world, 2, 18, 3, 0, 0);
        this.addBlock(world, 2, 18, 4, 0, 0);
        this.addBlock(world, 2, 18, 5, 0, 0);
        this.addBlock(world, 2, 18, 6, 0, 0);
        this.addBlock(world, 2, 18, 7, 0, 0);
        this.addBlock(world, 2, 18, 8, roofBlock, 4);
        this.addBlock(world, 2, 19, 3, roofBlock, 4);
        this.addBlock(world, 2, 19, 4, 0, 0);
        this.addBlock(world, 2, 19, 5, 0, 0);
        this.addBlock(world, 2, 19, 6, 0, 0);
        this.addBlock(world, 2, 19, 7, roofBlock, 4);
        this.addBlock(world, 2, 20, 4, roofBlock, 4);
        this.addBlock(world, 2, 20, 5, roofBlock, 4);
        this.addBlock(world, 2, 20, 6, roofBlock, 4);
        this.addBlock(world, 3, 0, 2, mainBlock, 1);
        this.addBlock(world, 3, 0, 3, mainBlock, 1);
        this.addBlock(world, 3, 0, 4, mainBlock, 1);
        this.addBlock(world, 3, 0, 5, mainBlock, 1);
        this.addBlock(world, 3, 0, 6, mainBlock, 1);
        this.addBlock(world, 3, 0, 7, mainBlock, 1);
        this.addBlock(world, 3, 0, 8, mainBlock, 1);
        this.addBlock(world, 3, 0, 9, lightBlock, 0);
        this.addBlock(world, 3, 1, 2, mainBlock, 1);
        this.addBlock(world, 3, 1, 3, 0, 0);
        this.addBlock(world, 3, 1, 4, 0, 0);
        this.addBlock(world, 3, 1, 5, 0, 0);
        this.addBlock(world, 3, 1, 6, 0, 0);
        this.addBlock(world, 3, 1, 7, 0, 0);
        this.addBlock(world, 3, 1, 8, mainBlock, 1);
        this.addBlock(world, 3, 1, 9, windowBlock, 0);
        this.addBlock(world, 3, 2, 2, mainBlock, 1);
        this.addBlock(world, 3, 2, 3, 0, 0);
        this.addBlock(world, 3, 2, 4, 0, 0);
        this.addBlock(world, 3, 2, 5, 0, 0);
        this.addBlock(world, 3, 2, 6, 0, 0);
        this.addBlock(world, 3, 2, 7, 0, 0);
        this.addBlock(world, 3, 2, 8, mainBlock, 1);
        this.addBlock(world, 3, 2, 9, windowBlock, 0);
        this.addBlock(world, 3, 3, 2, mainBlock, 1);
        this.addBlock(world, 3, 3, 3, 0, 0);
        this.addBlock(world, 3, 3, 4, 0, 0);
        this.addBlock(world, 3, 3, 5, 0, 0);
        this.addBlock(world, 3, 3, 6, 0, 0);
        this.addBlock(world, 3, 3, 7, 0, 0);
        this.addBlock(world, 3, 3, 8, mainBlock, 1);
        this.addBlock(world, 3, 3, 9, windowBlock, 0);
        this.addBlock(world, 3, 4, 2, mainBlock, 1);
        this.addBlock(world, 3, 4, 3, 0, 0);
        this.addBlock(world, 3, 4, 4, 0, 0);
        this.addBlock(world, 3, 4, 5, 0, 0);
        this.addBlock(world, 3, 4, 6, 0, 0);
        this.addBlock(world, 3, 4, 7, 0, 0);
        this.addBlock(world, 3, 4, 8, mainBlock, 1);
        this.addBlock(world, 3, 5, 2, mainBlock, 1);
        this.addBlock(world, 3, 5, 3, 0, 0);
        this.addBlock(world, 3, 5, 4, 0, 0);
        this.addBlock(world, 3, 5, 5, 0, 0);
        this.addBlock(world, 3, 5, 6, 0, 0);
        this.addBlock(world, 3, 5, 7, 0, 0);
        this.addBlock(world, 3, 5, 8, mainBlock, 1);
        this.addBlock(world, 3, 6, 2, mainBlock, 1);
        this.addBlock(world, 3, 6, 3, slabBlock, 1);
        this.addBlock(world, 3, 6, 4, slabBlock, 9);
        this.addBlock(world, 3, 6, 5, 0, 0);
        this.addBlock(world, 3, 6, 6, 0, 0);
        this.addBlock(world, 3, 6, 7, 0, 0);
        this.addBlock(world, 3, 6, 8, mainBlock, 1);
        this.addBlock(world, 3, 7, 2, mainBlock, 1);
        this.addBlock(world, 3, 7, 3, 0, 0);
        this.addBlock(world, 3, 7, 4, 0, 0);
        this.addBlock(world, 3, 7, 5, 0, 0);
        this.addBlock(world, 3, 7, 6, 0, 0);
        this.addBlock(world, 3, 7, 7, 0, 0);
        this.addBlock(world, 3, 7, 8, mainBlock, 1);
        this.addBlock(world, 3, 8, 2, mainBlock, 1);
        this.addBlock(world, 3, 8, 3, 0, 0);
        this.addBlock(world, 3, 8, 4, 0, 0);
        this.addBlock(world, 3, 8, 5, mainBlock, 1);
        this.addBlock(world, 3, 8, 6, mainBlock, 1);
        this.addBlock(world, 3, 8, 7, mainBlock, 1);
        this.addBlock(world, 3, 8, 8, mainBlock, 1);
        this.addBlock(world, 3, 9, 2, mainBlock, 1);
        this.addBlock(world, 3, 9, 3, 0, 0);
        this.addBlock(world, 3, 9, 4, 0, 0);
        this.addBlock(world, 3, 9, 5, 0, 0);
        this.addBlock(world, 3, 9, 6, 0, 0);
        this.addBlock(world, 3, 9, 7, 0, 0);
        this.addBlock(world, 3, 9, 8, mainBlock, 1);
        this.addBlock(world, 3, 10, 2, mainBlock, 1);
        this.addBlock(world, 3, 10, 3, 0, 0);
        this.addBlock(world, 3, 10, 4, 0, 0);
        this.addBlock(world, 3, 10, 5, 0, 0);
        this.addBlock(world, 3, 10, 6, 0, 0);
        this.addBlock(world, 3, 10, 7, 0, 0);
        this.addBlock(world, 3, 10, 8, mainBlock, 1);
        this.addBlock(world, 3, 11, 2, mainBlock, 1);
        this.addBlock(world, 3, 11, 3, 0, 0);
        this.addBlock(world, 3, 11, 4, 0, 0);
        this.addBlock(world, 3, 11, 5, 0, 0);
        this.addBlock(world, 3, 11, 6, 0, 0);
        this.addBlock(world, 3, 11, 7, 0, 0);
        this.addBlock(world, 3, 11, 8, mainBlock, 1);
        this.addBlock(world, 3, 12, 2, mainBlock, 1);
        this.addBlock(world, 3, 12, 3, 0, 0);
        this.addBlock(world, 3, 12, 4, 0, 0);
        this.addBlock(world, 3, 12, 5, 0, 0);
        this.addBlock(world, 3, 12, 6, 0, 0);
        this.addBlock(world, 3, 12, 7, 0, 0);
        this.addBlock(world, 3, 12, 8, mainBlock, 1);
        this.addBlock(world, 3, 13, 2, mainBlock, 1);
        this.addBlock(world, 3, 13, 3, 0, 0);
        this.addBlock(world, 3, 13, 4, 0, 0);
        this.addBlock(world, 3, 13, 5, 0, 0);
        this.addBlock(world, 3, 13, 6, 0, 0);
        this.addBlock(world, 3, 13, 7, 0, 0);
        this.addBlock(world, 3, 13, 8, mainBlock, 1);
        this.addBlock(world, 3, 14, 2, mainBlock, 1);
        this.addBlock(world, 3, 14, 3, slabBlock, 1);
        this.addBlock(world, 3, 14, 4, slabBlock, 9);
        this.addBlock(world, 3, 14, 5, 0, 0);
        this.addBlock(world, 3, 14, 6, 0, 0);
        this.addBlock(world, 3, 14, 7, 0, 0);
        this.addBlock(world, 3, 14, 8, mainBlock, 1);
        this.addBlock(world, 3, 15, 2, mainBlock, 1);
        this.addBlock(world, 3, 15, 3, 0, 0);
        this.addBlock(world, 3, 15, 4, 0, 0);
        this.addBlock(world, 3, 15, 5, 0, 0);
        this.addBlock(world, 3, 15, 6, 0, 0);
        this.addBlock(world, 3, 15, 7, 0, 0);
        this.addBlock(world, 3, 15, 8, mainBlock, 1);
        this.addBlock(world, 3, 16, 2, mainBlock, 1);
        this.addBlock(world, 3, 16, 3, 0, 0);
        this.addBlock(world, 3, 16, 4, 0, 0);
        this.addBlock(world, 3, 16, 5, mainBlock, 1);
        this.addBlock(world, 3, 16, 6, mainBlock, 1);
        this.addBlock(world, 3, 16, 7, mainBlock, 1);
        this.addBlock(world, 3, 16, 8, mainBlock, 1);
        this.addBlock(world, 3, 17, 0, roofBlock, 4);
        this.addBlock(world, 3, 17, 1, roofBlock, 4);
        this.addBlock(world, 3, 17, 2, 0, 0);
        this.addBlock(world, 3, 17, 3, 0, 0);
        this.addBlock(world, 3, 17, 4, 0, 0);
        this.addBlock(world, 3, 17, 5, 0, 0);
        this.addBlock(world, 3, 17, 6, 0, 0);
        this.addBlock(world, 3, 17, 7, 0, 0);
        this.addBlock(world, 3, 17, 8, 0, 0);
        this.addBlock(world, 3, 17, 9, roofBlock, 4);
        this.addBlock(world, 3, 17, 10, roofBlock, 4);
        this.addBlock(world, 3, 18, 1, roofBlock, 4);
        this.addBlock(world, 3, 18, 2, 0, 0);
        this.addBlock(world, 3, 18, 3, 0, 0);
        this.addBlock(world, 3, 18, 4, 0, 0);
        this.addBlock(world, 3, 18, 5, 0, 0);
        this.addBlock(world, 3, 18, 6, 0, 0);
        this.addBlock(world, 3, 18, 7, 0, 0);
        this.addBlock(world, 3, 18, 8, 0, 0);
        this.addBlock(world, 3, 18, 9, roofBlock, 4);
        this.addBlock(world, 3, 19, 2, roofBlock, 4);
        this.addBlock(world, 3, 19, 3, 0, 0);
        this.addBlock(world, 3, 19, 4, 0, 0);
        this.addBlock(world, 3, 19, 5, 0, 0);
        this.addBlock(world, 3, 19, 6, 0, 0);
        this.addBlock(world, 3, 19, 7, 0, 0);
        this.addBlock(world, 3, 19, 8, roofBlock, 4);
        this.addBlock(world, 3, 20, 3, roofBlock, 4);
        this.addBlock(world, 3, 20, 4, 0, 0);
        this.addBlock(world, 3, 20, 5, 0, 0);
        this.addBlock(world, 3, 20, 6, 0, 0);
        this.addBlock(world, 3, 20, 7, roofBlock, 4);
        this.addBlock(world, 3, 21, 4, roofBlock, 4);
        this.addBlock(world, 3, 21, 5, roofBlock, 4);
        this.addBlock(world, 3, 21, 6, roofBlock, 4);
        this.addBlock(world, 4, 0, 1, mainBlock, 1);
        this.addBlock(world, 4, 0, 2, mainBlock, 1);
        this.addBlock(world, 4, 0, 3, mainBlock, 1);
        this.addBlock(world, 4, 0, 4, mainBlock, 1);
        this.addBlock(world, 4, 0, 5, mainBlock, 1);
        this.addBlock(world, 4, 0, 6, mainBlock, 1);
        this.addBlock(world, 4, 0, 7, mainBlock, 1);
        this.addBlock(world, 4, 0, 8, mainBlock, 1);
        this.addBlock(world, 4, 0, 9, stairBlock, i);
        this.addBlock(world, 4, 1, 1, mainBlock, 1);
        this.addBlock(world, 4, 1, 2, 0, 0);
        this.addBlock(world, 4, 1, 3, 0, 0);
        this.addBlock(world, 4, 1, 4, 0, 0);
        this.addBlock(world, 4, 1, 5, 0, 0);
        this.addBlock(world, 4, 1, 6, 0, 0);
        this.addBlock(world, 4, 1, 7, 0, 0);
        this.addBlock(world, 4, 1, 8, 0, 0);
        this.addBlock(world, 4, 1, 9, 0, 0);
        this.addBlock(world, 4, 2, 0, stairBlock, j1);
        this.addBlock(world, 4, 2, 1, mainBlock, 1);
        this.addBlock(world, 4, 2, 2, 0, 0);
        this.addBlock(world, 4, 2, 3, 0, 0);
        this.addBlock(world, 4, 2, 4, 0, 0);
        this.addBlock(world, 4, 2, 5, 0, 0);
        this.addBlock(world, 4, 2, 6, 0, 0);
        this.addBlock(world, 4, 2, 7, 0, 0);
        this.addBlock(world, 4, 2, 8, 0, 0);
        this.addBlock(world, 4, 2, 9, 0, 0);
        this.addBlock(world, 4, 3, 1, mainBlock, 1);
        this.addBlock(world, 4, 3, 2, 0, 0);
        this.addBlock(world, 4, 3, 3, 0, 0);
        this.addBlock(world, 4, 3, 4, 0, 0);
        this.addBlock(world, 4, 3, 5, 0, 0);
        this.addBlock(world, 4, 3, 6, 0, 0);
        this.addBlock(world, 4, 3, 7, 0, 0);
        this.addBlock(world, 4, 3, 8, 0, 0);
        this.addBlock(world, 4, 3, 9, slabBlock, 9);
        this.addBlock(world, 4, 4, 1, mainBlock, 1);
        this.addBlock(world, 4, 4, 2, 0, 0);
        this.addBlock(world, 4, 4, 3, 0, 0);
        this.addBlock(world, 4, 4, 4, 0, 0);
        this.addBlock(world, 4, 4, 5, 0, 0);
        this.addBlock(world, 4, 4, 6, 0, 0);
        this.addBlock(world, 4, 4, 7, 0, 0);
        this.addBlock(world, 4, 4, 8, 0, 0);
        this.addBlock(world, 4, 4, 9, mainBlock, 1);
        this.addBlock(world, 4, 5, 1, mainBlock, 1);
        this.addBlock(world, 4, 5, 2, slabBlock, 1);
        this.addBlock(world, 4, 5, 3, slabBlock, 9);
        this.addBlock(world, 4, 5, 4, 0, 0);
        this.addBlock(world, 4, 5, 5, 0, 0);
        this.addBlock(world, 4, 5, 6, 0, 0);
        this.addBlock(world, 4, 5, 7, 0, 0);
        this.addBlock(world, 4, 5, 8, 0, 0);
        this.addBlock(world, 4, 5, 9, mainBlock, 1);
        this.addBlock(world, 4, 5, 10, stairBlock, i1);
        this.addBlock(world, 4, 6, 1, mainBlock, 1);
        this.addBlock(world, 4, 6, 2, 0, 0);
        this.addBlock(world, 4, 6, 3, 0, 0);
        this.addBlock(world, 4, 6, 4, 0, 0);
        this.addBlock(world, 4, 6, 5, 0, 0);
        this.addBlock(world, 4, 6, 6, 0, 0);
        this.addBlock(world, 4, 6, 7, 0, 0);
        this.addBlock(world, 4, 6, 8, 0, 0);
        this.addBlock(world, 4, 6, 9, mainBlock, 1);
        this.addBlock(world, 4, 7, 0, stairBlock, j1);
        this.addBlock(world, 4, 7, 1, mainBlock, 1);
        this.addBlock(world, 4, 7, 2, 0, 0);
        this.addBlock(world, 4, 7, 3, 0, 0);
        this.addBlock(world, 4, 7, 4, 0, 0);
        this.addBlock(world, 4, 7, 5, 0, 0);
        this.addBlock(world, 4, 7, 6, 0, 0);
        this.addBlock(world, 4, 7, 7, 0, 0);
        this.addBlock(world, 4, 7, 8, 0, 0);
        this.addBlock(world, 4, 7, 9, mainBlock, 1);
        this.addBlock(world, 4, 8, 1, mainBlock, 1);
        this.addBlock(world, 4, 8, 2, mainBlock, 1);
        this.addBlock(world, 4, 8, 3, 0, 0);
        this.addBlock(world, 4, 8, 4, mainBlock, 1);
        this.addBlock(world, 4, 8, 5, mainBlock, 1);
        this.addBlock(world, 4, 8, 6, mainBlock, 1);
        this.addBlock(world, 4, 8, 7, mainBlock, 1);
        this.addBlock(world, 4, 8, 8, mainBlock, 1);
        this.addBlock(world, 4, 8, 9, mainBlock, 1);
        this.addBlock(world, 4, 9, 1, mainBlock, 1);
        this.addBlock(world, 4, 9, 2, 0, 0);
        this.addBlock(world, 4, 9, 3, 0, 0);
        this.addBlock(world, 4, 9, 4, 0, 0);
        this.addBlock(world, 4, 9, 5, 0, 0);
        this.addBlock(world, 4, 9, 6, 0, 0);
        this.addBlock(world, 4, 9, 7, 0, 0);
        this.addBlock(world, 4, 9, 8, 0, 0);
        this.addBlock(world, 4, 9, 9, mainBlock, 1);
        this.addBlock(world, 4, 10, 0, stairBlock, j1);
        this.addBlock(world, 4, 10, 1, mainBlock, 1);
        this.addBlock(world, 4, 10, 2, 0, 0);
        this.addBlock(world, 4, 10, 3, 0, 0);
        this.addBlock(world, 4, 10, 4, 0, 0);
        this.addBlock(world, 4, 10, 5, 0, 0);
        this.addBlock(world, 4, 10, 6, 0, 0);
        this.addBlock(world, 4, 10, 7, 0, 0);
        this.addBlock(world, 4, 10, 8, 0, 0);
        this.addBlock(world, 4, 10, 9, mainBlock, 1);
        this.addBlock(world, 4, 10, 10, stairBlock, i1);
        this.addBlock(world, 4, 11, 1, mainBlock, 1);
        this.addBlock(world, 4, 11, 2, 0, 0);
        this.addBlock(world, 4, 11, 3, 0, 0);
        this.addBlock(world, 4, 11, 4, 0, 0);
        this.addBlock(world, 4, 11, 5, 0, 0);
        this.addBlock(world, 4, 11, 6, 0, 0);
        this.addBlock(world, 4, 11, 7, 0, 0);
        this.addBlock(world, 4, 11, 8, 0, 0);
        this.addBlock(world, 4, 11, 9, mainBlock, 1);
        this.addBlock(world, 4, 12, 1, mainBlock, 1);
        this.addBlock(world, 4, 12, 2, 0, 0);
        this.addBlock(world, 4, 12, 3, 0, 0);
        this.addBlock(world, 4, 12, 4, 0, 0);
        this.addBlock(world, 4, 12, 5, 0, 0);
        this.addBlock(world, 4, 12, 6, 0, 0);
        this.addBlock(world, 4, 12, 7, 0, 0);
        this.addBlock(world, 4, 12, 8, 0, 0);
        this.addBlock(world, 4, 12, 9, mainBlock, 1);
        this.addBlock(world, 4, 13, 1, mainBlock, 1);
        this.addBlock(world, 4, 13, 2, slabBlock, 1);
        this.addBlock(world, 4, 13, 3, slabBlock, 9);
        this.addBlock(world, 4, 13, 4, 0, 0);
        this.addBlock(world, 4, 13, 5, 0, 0);
        this.addBlock(world, 4, 13, 6, 0, 0);
        this.addBlock(world, 4, 13, 7, 0, 0);
        this.addBlock(world, 4, 13, 8, 0, 0);
        this.addBlock(world, 4, 13, 9, mainBlock, 1);
        this.addBlock(world, 4, 14, 1, mainBlock, 1);
        this.addBlock(world, 4, 14, 2, 0, 0);
        this.addBlock(world, 4, 14, 3, 0, 0);
        this.addBlock(world, 4, 14, 4, 0, 0);
        this.addBlock(world, 4, 14, 5, 0, 0);
        this.addBlock(world, 4, 14, 6, 0, 0);
        this.addBlock(world, 4, 14, 7, 0, 0);
        this.addBlock(world, 4, 14, 8, 0, 0);
        this.addBlock(world, 4, 14, 9, mainBlock, 1);
        this.addBlock(world, 4, 15, 0, stairBlock, j1);
        this.addBlock(world, 4, 15, 1, mainBlock, 1);
        this.addBlock(world, 4, 15, 2, 0, 0);
        this.addBlock(world, 4, 15, 3, 0, 0);
        this.addBlock(world, 4, 15, 4, 0, 0);
        this.addBlock(world, 4, 15, 5, 0, 0);
        this.addBlock(world, 4, 15, 6, 0, 0);
        this.addBlock(world, 4, 15, 7, 0, 0);
        this.addBlock(world, 4, 15, 8, 0, 0);
        this.addBlock(world, 4, 15, 9, mainBlock, 1);
        this.addBlock(world, 4, 16, 1, mainBlock, 1);
        this.addBlock(world, 4, 16, 2, mainBlock, 1);
        this.addBlock(world, 4, 16, 3, 0, 0);
        this.addBlock(world, 4, 16, 4, mainBlock, 1);
        this.addBlock(world, 4, 16, 5, mainBlock, 1);
        this.addBlock(world, 4, 16, 6, mainBlock, 1);
        this.addBlock(world, 4, 16, 7, mainBlock, 1);
        this.addBlock(world, 4, 16, 8, mainBlock, 1);
        this.addBlock(world, 4, 16, 9, mainBlock, 1);
        this.addBlock(world, 4, 17, 0, roofBlock, 4);
        this.addBlock(world, 4, 17, 1, 0, 0);
        this.addBlock(world, 4, 17, 2, 0, 0);
        this.addBlock(world, 4, 17, 3, 0, 0);
        this.addBlock(world, 4, 17, 4, 0, 0);
        this.addBlock(world, 4, 17, 5, 0, 0);
        this.addBlock(world, 4, 17, 6, 0, 0);
        this.addBlock(world, 4, 17, 7, 0, 0);
        this.addBlock(world, 4, 17, 8, 0, 0);
        this.addBlock(world, 4, 17, 9, 0, 0);
        this.addBlock(world, 4, 17, 10, roofBlock, 4);
        this.addBlock(world, 4, 18, 0, roofBlock, 4);
        this.addBlock(world, 4, 18, 1, 0, 0);
        this.addBlock(world, 4, 18, 2, 0, 0);
        this.addBlock(world, 4, 18, 3, 0, 0);
        this.addBlock(world, 4, 18, 4, 0, 0);
        this.addBlock(world, 4, 18, 5, 0, 0);
        this.addBlock(world, 4, 18, 6, 0, 0);
        this.addBlock(world, 4, 18, 7, 0, 0);
        this.addBlock(world, 4, 18, 8, 0, 0);
        this.addBlock(world, 4, 18, 9, 0, 0);
        this.addBlock(world, 4, 18, 10, roofBlock, 4);
        this.addBlock(world, 4, 19, 1, roofBlock, 4);
        this.addBlock(world, 4, 19, 2, 0, 0);
        this.addBlock(world, 4, 19, 3, 0, 0);
        this.addBlock(world, 4, 19, 4, 0, 0);
        this.addBlock(world, 4, 19, 5, 0, 0);
        this.addBlock(world, 4, 19, 6, 0, 0);
        this.addBlock(world, 4, 19, 7, 0, 0);
        this.addBlock(world, 4, 19, 8, 0, 0);
        this.addBlock(world, 4, 19, 9, roofBlock, 4);
        this.addBlock(world, 4, 20, 2, roofBlock, 4);
        this.addBlock(world, 4, 20, 3, 0, 0);
        this.addBlock(world, 4, 20, 4, 0, 0);
        this.addBlock(world, 4, 20, 5, 0, 0);
        this.addBlock(world, 4, 20, 6, 0, 0);
        this.addBlock(world, 4, 20, 7, 0, 0);
        this.addBlock(world, 4, 20, 8, roofBlock, 4);
        this.addBlock(world, 4, 21, 3, roofBlock, 4);
        this.addBlock(world, 4, 21, 4, 0, 0);
        this.addBlock(world, 4, 21, 5, 0, 0);
        this.addBlock(world, 4, 21, 6, 0, 0);
        this.addBlock(world, 4, 21, 7, roofBlock, 4);
        this.addBlock(world, 4, 22, 4, roofBlock, 4);
        this.addBlock(world, 4, 22, 5, roofBlock, 4);
        this.addBlock(world, 4, 22, 6, roofBlock, 4);
        this.addBlock(world, 4, 23, 5, roofBlock, 4);
        this.addBlock(world, 5, 0, 1, mainBlock, 1);
        this.addBlock(world, 5, 0, 2, mainBlock, 1);
        this.addBlock(world, 5, 0, 3, mainBlock, 1);
        this.addBlock(world, 5, 0, 4, mainBlock, 1);
        this.addBlock(world, 5, 0, 6, mainBlock, 1);
        this.addBlock(world, 5, 0, 7, mainBlock, 1);
        this.addBlock(world, 5, 0, 8, mainBlock, 1);
        this.addBlock(world, 5, 0, 9, stairBlock, i);
        this.addBlock(world, 5, 1, 1, windowBlock, 0);
        this.addBlock(world, 5, 1, 2, 0, 0);
        this.addBlock(world, 5, 1, 3, 0, 0);
        this.addBlock(world, 5, 1, 4, 0, 0);
        this.addBlock(world, 5, 1, 5, 0, 0);
        this.addBlock(world, 5, 1, 6, 0, 0);
        this.addBlock(world, 5, 1, 7, 0, 0);
        this.addBlock(world, 5, 1, 8, 0, 0);
        this.addBlock(world, 5, 1, 9, 0, 0);
        this.addBlock(world, 5, 2, 1, windowBlock, 0);
        this.addBlock(world, 5, 2, 2, 0, 0);
        this.addBlock(world, 5, 2, 3, 0, 0);
        this.addBlock(world, 5, 2, 4, 0, 0);
        this.addBlock(world, 5, 2, 5, 0, 0);
        this.addBlock(world, 5, 2, 6, 0, 0);
        this.addBlock(world, 5, 2, 7, 0, 0);
        this.addBlock(world, 5, 2, 8, 0, 0);
        this.addBlock(world, 5, 2, 9, 0, 0);
        this.addBlock(world, 5, 3, 0, stairBlock, j);
        this.addBlock(world, 5, 3, 1, mainBlock, 1);
        this.addBlock(world, 5, 3, 2, 0, 0);
        this.addBlock(world, 5, 3, 3, 0, 0);
        this.addBlock(world, 5, 3, 4, 0, 0);
        this.addBlock(world, 5, 3, 5, 0, 0);
        this.addBlock(world, 5, 3, 6, 0, 0);
        this.addBlock(world, 5, 3, 7, 0, 0);
        this.addBlock(world, 5, 3, 8, 0, 0);
        this.addBlock(world, 5, 3, 9, slabBlock, 9);
        this.addBlock(world, 5, 4, 1, mainBlock, 1);
        this.addBlock(world, 5, 4, 2, slabBlock, 9);
        this.addBlock(world, 5, 4, 3, 0, 0);
        this.addBlock(world, 5, 4, 4, 0, 0);
        this.addBlock(world, 5, 4, 5, 0, 0);
        this.addBlock(world, 5, 4, 6, 0, 0);
        this.addBlock(world, 5, 4, 7, 0, 0);
        this.addBlock(world, 5, 4, 8, 0, 0);
        this.addBlock(world, 5, 4, 9, windowBlock, 0);
        this.addBlock(world, 5, 5, 1, mainBlock, 1);
        this.addBlock(world, 5, 5, 2, 0, 0);
        this.addBlock(world, 5, 5, 3, 0, 0);
        this.addBlock(world, 5, 5, 4, 0, 0);
        this.addBlock(world, 5, 5, 5, 0, 0);
        this.addBlock(world, 5, 5, 6, 0, 0);
        this.addBlock(world, 5, 5, 7, 0, 0);
        this.addBlock(world, 5, 5, 8, 0, 0);
        this.addBlock(world, 5, 5, 9, windowBlock, 0);
        this.addBlock(world, 5, 6, 1, windowBlock, 0);
        this.addBlock(world, 5, 6, 2, 0, 0);
        this.addBlock(world, 5, 6, 3, 0, 0);
        this.addBlock(world, 5, 6, 4, 0, 0);
        this.addBlock(world, 5, 6, 5, 0, 0);
        this.addBlock(world, 5, 6, 6, 0, 0);
        this.addBlock(world, 5, 6, 7, 0, 0);
        this.addBlock(world, 5, 6, 8, 0, 0);
        this.addBlock(world, 5, 6, 9, mainBlock, 1);
        this.addBlock(world, 5, 6, 10, stairBlock, i);
        this.addBlock(world, 5, 7, 1, windowBlock, 0);
        this.addBlock(world, 5, 7, 2, 0, 0);
        this.addBlock(world, 5, 7, 3, 0, 0);
        this.addBlock(world, 5, 7, 4, 0, 0);
        this.addBlock(world, 5, 7, 5, 0, 0);
        this.addBlock(world, 5, 7, 6, 0, 0);
        this.addBlock(world, 5, 7, 7, 0, 0);
        this.addBlock(world, 5, 7, 8, 0, 0);
        this.addBlock(world, 5, 7, 9, mainBlock, 1);
        this.addBlock(world, 5, 8, 0, stairBlock, j);
        this.addBlock(world, 5, 8, 1, mainBlock, 1);
        this.addBlock(world, 5, 8, 2, mainBlock, 1);
        this.addBlock(world, 5, 8, 3, mainBlock, 1);
        this.addBlock(world, 5, 8, 4, mainBlock, 1);
        this.addBlock(world, 5, 8, 6, mainBlock, 1);
        this.addBlock(world, 5, 8, 7, mainBlock, 1);
        this.addBlock(world, 5, 8, 8, mainBlock, 1);
        this.addBlock(world, 5, 8, 9, mainBlock, 1);
        this.addBlock(world, 5, 9, 1, windowBlock, 0);
        this.addBlock(world, 5, 9, 2, 0, 0);
        this.addBlock(world, 5, 9, 3, 0, 0);
        this.addBlock(world, 5, 9, 4, 0, 0);
        this.addBlock(world, 5, 9, 5, 0, 0);
        this.addBlock(world, 5, 9, 6, 0, 0);
        this.addBlock(world, 5, 9, 7, 0, 0);
        this.addBlock(world, 5, 9, 8, 0, 0);
        this.addBlock(world, 5, 9, 9, windowBlock, 0);
        this.addBlock(world, 5, 10, 1, windowBlock, 0);
        this.addBlock(world, 5, 10, 2, 0, 0);
        this.addBlock(world, 5, 10, 3, 0, 0);
        this.addBlock(world, 5, 10, 4, 0, 0);
        this.addBlock(world, 5, 10, 5, 0, 0);
        this.addBlock(world, 5, 10, 6, 0, 0);
        this.addBlock(world, 5, 10, 7, 0, 0);
        this.addBlock(world, 5, 10, 8, 0, 0);
        this.addBlock(world, 5, 10, 9, windowBlock, 0);
        this.addBlock(world, 5, 11, 0, stairBlock, j);
        this.addBlock(world, 5, 11, 1, mainBlock, 1);
        this.addBlock(world, 5, 11, 2, 0, 0);
        this.addBlock(world, 5, 11, 3, 0, 0);
        this.addBlock(world, 5, 11, 4, 0, 0);
        this.addBlock(world, 5, 11, 5, 0, 0);
        this.addBlock(world, 5, 11, 6, 0, 0);
        this.addBlock(world, 5, 11, 7, 0, 0);
        this.addBlock(world, 5, 11, 8, 0, 0);
        this.addBlock(world, 5, 11, 9, mainBlock, 1);
        this.addBlock(world, 5, 11, 10, stairBlock, i);
        this.addBlock(world, 5, 12, 1, mainBlock, 1);
        this.addBlock(world, 5, 12, 2, slabBlock, 9);
        this.addBlock(world, 5, 12, 3, 0, 0);
        this.addBlock(world, 5, 12, 4, 0, 0);
        this.addBlock(world, 5, 12, 5, 0, 0);
        this.addBlock(world, 5, 12, 6, 0, 0);
        this.addBlock(world, 5, 12, 7, 0, 0);
        this.addBlock(world, 5, 12, 8, 0, 0);
        this.addBlock(world, 5, 12, 9, mainBlock, 1);
        this.addBlock(world, 5, 13, 1, mainBlock, 1);
        this.addBlock(world, 5, 13, 2, 0, 0);
        this.addBlock(world, 5, 13, 3, 0, 0);
        this.addBlock(world, 5, 13, 4, 0, 0);
        this.addBlock(world, 5, 13, 5, 0, 0);
        this.addBlock(world, 5, 13, 6, 0, 0);
        this.addBlock(world, 5, 13, 7, 0, 0);
        this.addBlock(world, 5, 13, 8, 0, 0);
        this.addBlock(world, 5, 13, 9, mainBlock, 1);
        this.addBlock(world, 5, 14, 1, windowBlock, 0);
        this.addBlock(world, 5, 14, 2, 0, 0);
        this.addBlock(world, 5, 14, 3, 0, 0);
        this.addBlock(world, 5, 14, 4, 0, 0);
        this.addBlock(world, 5, 14, 5, 0, 0);
        this.addBlock(world, 5, 14, 6, 0, 0);
        this.addBlock(world, 5, 14, 7, 0, 0);
        this.addBlock(world, 5, 14, 8, 0, 0);
        this.addBlock(world, 5, 14, 9, mainBlock, 1);
        this.addBlock(world, 5, 15, 1, windowBlock, 0);
        this.addBlock(world, 5, 15, 2, 0, 0);
        this.addBlock(world, 5, 15, 3, 0, 0);
        this.addBlock(world, 5, 15, 4, 0, 0);
        this.addBlock(world, 5, 15, 5, 0, 0);
        this.addBlock(world, 5, 15, 6, 0, 0);
        this.addBlock(world, 5, 15, 7, 0, 0);
        this.addBlock(world, 5, 15, 8, 0, 0);
        this.addBlock(world, 5, 15, 9, mainBlock, 1);
        this.addBlock(world, 5, 16, 0, stairBlock, j);
        this.addBlock(world, 5, 16, 1, mainBlock, 1);
        this.addBlock(world, 5, 16, 2, mainBlock, 1);
        this.addBlock(world, 5, 16, 3, mainBlock, 1);
        this.addBlock(world, 5, 16, 4, mainBlock, 1);
        this.addBlock(world, 5, 16, 6, mainBlock, 1);
        this.addBlock(world, 5, 16, 7, mainBlock, 1);
        this.addBlock(world, 5, 16, 8, mainBlock, 1);
        this.addBlock(world, 5, 16, 9, mainBlock, 1);
        this.addBlock(world, 5, 17, 0, roofBlock, 4);
        this.addBlock(world, 5, 17, 2, 0, 0);
        this.addBlock(world, 5, 17, 3, 0, 0);
        this.addBlock(world, 5, 17, 4, 0, 0);
        this.addBlock(world, 5, 17, 5, 0, 0);
        this.addBlock(world, 5, 17, 6, 0, 0);
        this.addBlock(world, 5, 17, 7, 0, 0);
        this.addBlock(world, 5, 17, 8, 0, 0);
        this.addBlock(world, 5, 17, 10, roofBlock, 4);
        this.addBlock(world, 5, 18, 0, roofBlock, 4);
        this.addBlock(world, 5, 18, 1, 0, 0);
        this.addBlock(world, 5, 18, 2, 0, 0);
        this.addBlock(world, 5, 18, 3, 0, 0);
        this.addBlock(world, 5, 18, 4, 0, 0);
        this.addBlock(world, 5, 18, 5, 0, 0);
        this.addBlock(world, 5, 18, 6, 0, 0);
        this.addBlock(world, 5, 18, 7, 0, 0);
        this.addBlock(world, 5, 18, 8, 0, 0);
        this.addBlock(world, 5, 18, 9, 0, 0);
        this.addBlock(world, 5, 18, 10, roofBlock, 4);
        this.addBlock(world, 5, 19, 1, roofBlock, 4);
        this.addBlock(world, 5, 19, 2, 0, 0);
        this.addBlock(world, 5, 19, 3, 0, 0);
        this.addBlock(world, 5, 19, 4, 0, 0);
        this.addBlock(world, 5, 19, 5, 0, 0);
        this.addBlock(world, 5, 19, 6, 0, 0);
        this.addBlock(world, 5, 19, 7, 0, 0);
        this.addBlock(world, 5, 19, 8, 0, 0);
        this.addBlock(world, 5, 19, 9, roofBlock, 4);
        this.addBlock(world, 5, 20, 2, roofBlock, 4);
        this.addBlock(world, 5, 20, 3, 0, 0);
        this.addBlock(world, 5, 20, 4, 0, 0);
        this.addBlock(world, 5, 20, 5, 0, 0);
        this.addBlock(world, 5, 20, 6, 0, 0);
        this.addBlock(world, 5, 20, 7, 0, 0);
        this.addBlock(world, 5, 20, 8, roofBlock, 4);
        this.addBlock(world, 5, 21, 3, roofBlock, 4);
        this.addBlock(world, 5, 21, 4, 0, 0);
        this.addBlock(world, 5, 21, 5, 0, 0);
        this.addBlock(world, 5, 21, 6, 0, 0);
        this.addBlock(world, 5, 21, 7, roofBlock, 4);
        this.addBlock(world, 5, 22, 4, roofBlock, 4);
        this.addBlock(world, 5, 22, 5, lightBlock, 0);
        this.addBlock(world, 5, 22, 6, roofBlock, 4);
        this.addBlock(world, 5, 23, 4, roofBlock, 4);
        this.addBlock(world, 5, 23, 5, roofBlock, 4);
        this.addBlock(world, 5, 23, 6, roofBlock, 4);
        this.addBlock(world, 5, 24, 5, lightBlock, 0);
        this.addBlock(world, 6, 0, 1, mainBlock, 1);
        this.addBlock(world, 6, 0, 2, mainBlock, 1);
        this.addBlock(world, 6, 0, 3, mainBlock, 1);
        this.addBlock(world, 6, 0, 4, mainBlock, 1);
        this.addBlock(world, 6, 0, 5, mainBlock, 1);
        this.addBlock(world, 6, 0, 6, mainBlock, 1);
        this.addBlock(world, 6, 0, 7, mainBlock, 1);
        this.addBlock(world, 6, 0, 8, mainBlock, 1);
        this.addBlock(world, 6, 0, 9, stairBlock, i);
        this.addBlock(world, 6, 1, 1, mainBlock, 1);
        this.addBlock(world, 6, 1, 2, 0, 0);
        this.addBlock(world, 6, 1, 3, 0, 0);
        this.addBlock(world, 6, 1, 4, 0, 0);
        this.addBlock(world, 6, 1, 5, 0, 0);
        this.addBlock(world, 6, 1, 6, 0, 0);
        this.addBlock(world, 6, 1, 7, 0, 0);
        this.addBlock(world, 6, 1, 8, 0, 0);
        this.addBlock(world, 6, 1, 9, 0, 0);
        this.addBlock(world, 6, 2, 0, stairBlock, j1);
        this.addBlock(world, 6, 2, 1, mainBlock, 1);
        this.addBlock(world, 6, 2, 2, 0, 0);
        this.addBlock(world, 6, 2, 3, 0, 0);
        this.addBlock(world, 6, 2, 4, 0, 0);
        this.addBlock(world, 6, 2, 5, 0, 0);
        this.addBlock(world, 6, 2, 6, 0, 0);
        this.addBlock(world, 6, 2, 7, 0, 0);
        this.addBlock(world, 6, 2, 8, 0, 0);
        this.addBlock(world, 6, 2, 9, 0, 0);
        this.addBlock(world, 6, 3, 1, mainBlock, 1);
        this.addBlock(world, 6, 3, 2, 0, 0);
        this.addBlock(world, 6, 3, 3, slabBlock, 9);
        this.addBlock(world, 6, 3, 4, 0, 0);
        this.addBlock(world, 6, 3, 5, 0, 0);
        this.addBlock(world, 6, 3, 6, 0, 0);
        this.addBlock(world, 6, 3, 7, 0, 0);
        this.addBlock(world, 6, 3, 8, 0, 0);
        this.addBlock(world, 6, 3, 9, slabBlock, 9);
        this.addBlock(world, 6, 4, 1, mainBlock, 1);
        this.addBlock(world, 6, 4, 2, slabBlock, 1);
        this.addBlock(world, 6, 4, 3, 0, 0);
        this.addBlock(world, 6, 4, 4, 0, 0);
        this.addBlock(world, 6, 4, 5, 0, 0);
        this.addBlock(world, 6, 4, 6, 0, 0);
        this.addBlock(world, 6, 4, 7, 0, 0);
        this.addBlock(world, 6, 4, 8, 0, 0);
        this.addBlock(world, 6, 4, 9, mainBlock, 1);
        this.addBlock(world, 6, 5, 1, mainBlock, 1);
        this.addBlock(world, 6, 5, 2, 0, 0);
        this.addBlock(world, 6, 5, 3, 0, 0);
        this.addBlock(world, 6, 5, 4, 0, 0);
        this.addBlock(world, 6, 5, 5, 0, 0);
        this.addBlock(world, 6, 5, 6, 0, 0);
        this.addBlock(world, 6, 5, 7, 0, 0);
        this.addBlock(world, 6, 5, 8, 0, 0);
        this.addBlock(world, 6, 5, 9, mainBlock, 1);
        this.addBlock(world, 6, 5, 10, stairBlock, i1);
        this.addBlock(world, 6, 6, 1, mainBlock, 1);
        this.addBlock(world, 6, 6, 2, 0, 0);
        this.addBlock(world, 6, 6, 3, 0, 0);
        this.addBlock(world, 6, 6, 4, 0, 0);
        this.addBlock(world, 6, 6, 5, 0, 0);
        this.addBlock(world, 6, 6, 6, 0, 0);
        this.addBlock(world, 6, 6, 7, 0, 0);
        this.addBlock(world, 6, 6, 8, 0, 0);
        this.addBlock(world, 6, 6, 9, mainBlock, 1);
        this.addBlock(world, 6, 7, 0, stairBlock, j1);
        this.addBlock(world, 6, 7, 1, mainBlock, 1);
        this.addBlock(world, 6, 7, 2, 0, 0);
        this.addBlock(world, 6, 7, 3, 0, 0);
        this.addBlock(world, 6, 7, 4, 0, 0);
        this.addBlock(world, 6, 7, 5, 0, 0);
        this.addBlock(world, 6, 7, 6, 0, 0);
        this.addBlock(world, 6, 7, 7, 0, 0);
        this.addBlock(world, 6, 7, 8, 0, 0);
        this.addBlock(world, 6, 7, 9, mainBlock, 1);
        this.addBlock(world, 6, 8, 1, mainBlock, 1);
        this.addBlock(world, 6, 8, 2, mainBlock, 1);
        this.addBlock(world, 6, 8, 3, mainBlock, 1);
        this.addBlock(world, 6, 8, 4, mainBlock, 1);
        this.addBlock(world, 6, 8, 5, mainBlock, 1);
        this.addBlock(world, 6, 8, 6, mainBlock, 1);
        this.addBlock(world, 6, 8, 7, mainBlock, 1);
        this.addBlock(world, 6, 8, 8, mainBlock, 1);
        this.addBlock(world, 6, 8, 9, mainBlock, 1);
        this.addBlock(world, 6, 9, 1, mainBlock, 1);
        this.addBlock(world, 6, 9, 2, 0, 0);
        this.addBlock(world, 6, 9, 3, 0, 0);
        this.addBlock(world, 6, 9, 4, 0, 0);
        this.addBlock(world, 6, 9, 5, 0, 0);
        this.addBlock(world, 6, 9, 6, 0, 0);
        this.addBlock(world, 6, 9, 7, 0, 0);
        this.addBlock(world, 6, 9, 8, 0, 0);
        this.addBlock(world, 6, 9, 9, mainBlock, 1);
        this.addBlock(world, 6, 10, 0, stairBlock, j1);
        this.addBlock(world, 6, 10, 1, mainBlock, 1);
        this.addBlock(world, 6, 10, 2, 0, 0);
        this.addBlock(world, 6, 10, 3, 0, 0);
        this.addBlock(world, 6, 10, 4, 0, 0);
        this.addBlock(world, 6, 10, 5, 0, 0);
        this.addBlock(world, 6, 10, 6, 0, 0);
        this.addBlock(world, 6, 10, 7, 0, 0);
        this.addBlock(world, 6, 10, 8, 0, 0);
        this.addBlock(world, 6, 10, 9, mainBlock, 1);
        this.addBlock(world, 6, 10, 10, stairBlock, i1);
        this.addBlock(world, 6, 11, 1, mainBlock, 1);
        this.addBlock(world, 6, 11, 2, 0, 0);
        this.addBlock(world, 6, 11, 3, slabBlock, 9);
        this.addBlock(world, 6, 11, 4, 0, 0);
        this.addBlock(world, 6, 11, 5, 0, 0);
        this.addBlock(world, 6, 11, 6, 0, 0);
        this.addBlock(world, 6, 11, 7, 0, 0);
        this.addBlock(world, 6, 11, 8, 0, 0);
        this.addBlock(world, 6, 11, 9, mainBlock, 1);
        this.addBlock(world, 6, 12, 1, mainBlock, 1);
        this.addBlock(world, 6, 12, 2, slabBlock, 1);
        this.addBlock(world, 6, 12, 3, 0, 0);
        this.addBlock(world, 6, 12, 4, 0, 0);
        this.addBlock(world, 6, 12, 5, 0, 0);
        this.addBlock(world, 6, 12, 6, 0, 0);
        this.addBlock(world, 6, 12, 7, 0, 0);
        this.addBlock(world, 6, 12, 8, 0, 0);
        this.addBlock(world, 6, 12, 9, mainBlock, 1);
        this.addBlock(world, 6, 13, 1, mainBlock, 1);
        this.addBlock(world, 6, 13, 2, 0, 0);
        this.addBlock(world, 6, 13, 3, 0, 0);
        this.addBlock(world, 6, 13, 4, 0, 0);
        this.addBlock(world, 6, 13, 5, 0, 0);
        this.addBlock(world, 6, 13, 6, 0, 0);
        this.addBlock(world, 6, 13, 7, 0, 0);
        this.addBlock(world, 6, 13, 8, 0, 0);
        this.addBlock(world, 6, 13, 9, mainBlock, 1);
        this.addBlock(world, 6, 14, 1, mainBlock, 1);
        this.addBlock(world, 6, 14, 2, 0, 0);
        this.addBlock(world, 6, 14, 3, 0, 0);
        this.addBlock(world, 6, 14, 4, 0, 0);
        this.addBlock(world, 6, 14, 5, 0, 0);
        this.addBlock(world, 6, 14, 6, 0, 0);
        this.addBlock(world, 6, 14, 7, 0, 0);
        this.addBlock(world, 6, 14, 8, 0, 0);
        this.addBlock(world, 6, 14, 9, mainBlock, 1);
        this.addBlock(world, 6, 15, 0, stairBlock, j1);
        this.addBlock(world, 6, 15, 1, mainBlock, 1);
        this.addBlock(world, 6, 15, 2, 0, 0);
        this.addBlock(world, 6, 15, 3, 0, 0);
        this.addBlock(world, 6, 15, 4, 0, 0);
        this.addBlock(world, 6, 15, 5, 0, 0);
        this.addBlock(world, 6, 15, 6, 0, 0);
        this.addBlock(world, 6, 15, 7, 0, 0);
        this.addBlock(world, 6, 15, 8, 0, 0);
        this.addBlock(world, 6, 15, 9, mainBlock, 1);
        this.addBlock(world, 6, 16, 1, mainBlock, 1);
        this.addBlock(world, 6, 16, 2, mainBlock, 1);
        this.addBlock(world, 6, 16, 3, mainBlock, 1);
        this.addBlock(world, 6, 16, 4, mainBlock, 1);
        this.addBlock(world, 6, 16, 5, mainBlock, 1);
        this.addBlock(world, 6, 16, 6, mainBlock, 1);
        this.addBlock(world, 6, 16, 7, mainBlock, 1);
        this.addBlock(world, 6, 16, 8, mainBlock, 1);
        this.addBlock(world, 6, 16, 9, mainBlock, 1);
        this.addBlock(world, 6, 17, 0, roofBlock, 4);
        this.addBlock(world, 6, 17, 1, 0, 0);
        this.addBlock(world, 6, 17, 2, 0, 0);
        this.addBlock(world, 6, 17, 3, 0, 0);
        this.addBlock(world, 6, 17, 4, 0, 0);
        this.addBlock(world, 6, 17, 5, 0, 0);
        this.addBlock(world, 6, 17, 6, 0, 0);
        this.addBlock(world, 6, 17, 7, 0, 0);
        this.addBlock(world, 6, 17, 8, 0, 0);
        this.addBlock(world, 6, 17, 9, 0, 0);
        this.addBlock(world, 6, 17, 10, roofBlock, 4);
        this.addBlock(world, 6, 18, 0, roofBlock, 4);
        this.addBlock(world, 6, 18, 1, 0, 0);
        this.addBlock(world, 6, 18, 2, 0, 0);
        this.addBlock(world, 6, 18, 3, 0, 0);
        this.addBlock(world, 6, 18, 4, 0, 0);
        this.addBlock(world, 6, 18, 5, 0, 0);
        this.addBlock(world, 6, 18, 6, 0, 0);
        this.addBlock(world, 6, 18, 7, 0, 0);
        this.addBlock(world, 6, 18, 8, 0, 0);
        this.addBlock(world, 6, 18, 9, 0, 0);
        this.addBlock(world, 6, 18, 10, roofBlock, 4);
        this.addBlock(world, 6, 19, 1, roofBlock, 4);
        this.addBlock(world, 6, 19, 2, 0, 0);
        this.addBlock(world, 6, 19, 3, 0, 0);
        this.addBlock(world, 6, 19, 4, 0, 0);
        this.addBlock(world, 6, 19, 5, 0, 0);
        this.addBlock(world, 6, 19, 6, 0, 0);
        this.addBlock(world, 6, 19, 7, 0, 0);
        this.addBlock(world, 6, 19, 8, 0, 0);
        this.addBlock(world, 6, 19, 9, roofBlock, 4);
        this.addBlock(world, 6, 20, 2, roofBlock, 4);
        this.addBlock(world, 6, 20, 3, 0, 0);
        this.addBlock(world, 6, 20, 4, 0, 0);
        this.addBlock(world, 6, 20, 5, 0, 0);
        this.addBlock(world, 6, 20, 6, 0, 0);
        this.addBlock(world, 6, 20, 7, 0, 0);
        this.addBlock(world, 6, 20, 8, roofBlock, 4);
        this.addBlock(world, 6, 21, 3, roofBlock, 4);
        this.addBlock(world, 6, 21, 4, 0, 0);
        this.addBlock(world, 6, 21, 5, 0, 0);
        this.addBlock(world, 6, 21, 6, 0, 0);
        this.addBlock(world, 6, 21, 7, roofBlock, 4);
        this.addBlock(world, 6, 22, 4, roofBlock, 4);
        this.addBlock(world, 6, 22, 5, roofBlock, 4);
        this.addBlock(world, 6, 22, 6, roofBlock, 4);
        this.addBlock(world, 6, 23, 5, roofBlock, 4);
        this.addBlock(world, 7, 0, 2, mainBlock, 1);
        this.addBlock(world, 7, 0, 3, mainBlock, 1);
        this.addBlock(world, 7, 0, 4, mainBlock, 1);
        this.addBlock(world, 7, 0, 5, mainBlock, 1);
        this.addBlock(world, 7, 0, 6, mainBlock, 1);
        this.addBlock(world, 7, 0, 7, mainBlock, 1);
        this.addBlock(world, 7, 0, 8, mainBlock, 1);
        this.addBlock(world, 7, 0, 9, lightBlock, 0);
        this.addBlock(world, 7, 1, 2, mainBlock, 1);
        this.addBlock(world, 7, 1, 3, 0, 0);
        this.addBlock(world, 7, 1, 4, 0, 0);
        this.addBlock(world, 7, 1, 5, 0, 0);
        this.addBlock(world, 7, 1, 6, 0, 0);
        this.addBlock(world, 7, 1, 7, 0, 0);
        this.addBlock(world, 7, 1, 8, mainBlock, 1);
        this.addBlock(world, 7, 1, 9, windowBlock, 0);
        this.addBlock(world, 7, 2, 2, mainBlock, 1);
        this.addBlock(world, 7, 2, 3, 0, 0);
        this.addBlock(world, 7, 2, 4, slabBlock, 9);
        this.addBlock(world, 7, 2, 5, 0, 0);
        this.addBlock(world, 7, 2, 6, 0, 0);
        this.addBlock(world, 7, 2, 7, 0, 0);
        this.addBlock(world, 7, 2, 8, mainBlock, 1);
        this.addBlock(world, 7, 2, 9, windowBlock, 0);
        this.addBlock(world, 7, 3, 2, mainBlock, 1);
        this.addBlock(world, 7, 3, 3, slabBlock, 1);
        this.addBlock(world, 7, 3, 4, 0, 0);
        this.addBlock(world, 7, 3, 5, 0, 0);
        this.addBlock(world, 7, 3, 6, 0, 0);
        this.addBlock(world, 7, 3, 7, 0, 0);
        this.addBlock(world, 7, 3, 8, mainBlock, 1);
        this.addBlock(world, 7, 3, 9, windowBlock, 0);
        this.addBlock(world, 7, 4, 2, mainBlock, 1);
        this.addBlock(world, 7, 4, 3, 0, 0);
        this.addBlock(world, 7, 4, 4, 0, 0);
        this.addBlock(world, 7, 4, 5, 0, 0);
        this.addBlock(world, 7, 4, 6, 0, 0);
        this.addBlock(world, 7, 4, 7, 0, 0);
        this.addBlock(world, 7, 4, 8, mainBlock, 1);
        this.addBlock(world, 7, 5, 2, mainBlock, 1);
        this.addBlock(world, 7, 5, 3, 0, 0);
        this.addBlock(world, 7, 5, 4, 0, 0);
        this.addBlock(world, 7, 5, 5, 0, 0);
        this.addBlock(world, 7, 5, 6, 0, 0);
        this.addBlock(world, 7, 5, 7, 0, 0);
        this.addBlock(world, 7, 5, 8, mainBlock, 1);
        this.addBlock(world, 7, 6, 2, mainBlock, 1);
        this.addBlock(world, 7, 6, 3, 0, 0);
        this.addBlock(world, 7, 6, 4, 0, 0);
        this.addBlock(world, 7, 6, 5, 0, 0);
        this.addBlock(world, 7, 6, 6, 0, 0);
        this.addBlock(world, 7, 6, 7, 0, 0);
        this.addBlock(world, 7, 6, 8, mainBlock, 1);
        this.addBlock(world, 7, 7, 2, mainBlock, 1);
        this.addBlock(world, 7, 7, 3, 0, 0);
        this.addBlock(world, 7, 7, 4, 0, 0);
        this.addBlock(world, 7, 7, 5, 0, 0);
        this.addBlock(world, 7, 7, 6, 0, 0);
        this.addBlock(world, 7, 7, 7, 0, 0);
        this.addBlock(world, 7, 7, 8, mainBlock, 1);
        this.addBlock(world, 7, 8, 2, mainBlock, 1);
        this.addBlock(world, 7, 8, 3, mainBlock, 1);
        this.addBlock(world, 7, 8, 4, mainBlock, 1);
        this.addBlock(world, 7, 8, 5, mainBlock, 1);
        this.addBlock(world, 7, 8, 6, mainBlock, 1);
        this.addBlock(world, 7, 8, 7, mainBlock, 1);
        this.addBlock(world, 7, 8, 8, mainBlock, 1);
        this.addBlock(world, 7, 9, 2, mainBlock, 1);
        this.addBlock(world, 7, 9, 3, 0, 0);
        this.addBlock(world, 7, 9, 4, 0, 0);
        this.addBlock(world, 7, 9, 5, 0, 0);
        this.addBlock(world, 7, 9, 6, 0, 0);
        this.addBlock(world, 7, 9, 7, 0, 0);
        this.addBlock(world, 7, 9, 8, mainBlock, 1);
        this.addBlock(world, 7, 10, 2, mainBlock, 1);
        this.addBlock(world, 7, 10, 3, 0, 0);
        this.addBlock(world, 7, 10, 4, slabBlock, 9);
        this.addBlock(world, 7, 10, 5, 0, 0);
        this.addBlock(world, 7, 10, 6, 0, 0);
        this.addBlock(world, 7, 10, 7, 0, 0);
        this.addBlock(world, 7, 10, 8, mainBlock, 1);
        this.addBlock(world, 7, 11, 2, mainBlock, 1);
        this.addBlock(world, 7, 11, 3, slabBlock, 1);
        this.addBlock(world, 7, 11, 4, 0, 0);
        this.addBlock(world, 7, 11, 5, 0, 0);
        this.addBlock(world, 7, 11, 6, 0, 0);
        this.addBlock(world, 7, 11, 7, 0, 0);
        this.addBlock(world, 7, 11, 8, mainBlock, 1);
        this.addBlock(world, 7, 12, 2, mainBlock, 1);
        this.addBlock(world, 7, 12, 3, 0, 0);
        this.addBlock(world, 7, 12, 4, 0, 0);
        this.addBlock(world, 7, 12, 5, 0, 0);
        this.addBlock(world, 7, 12, 6, 0, 0);
        this.addBlock(world, 7, 12, 7, 0, 0);
        this.addBlock(world, 7, 12, 8, mainBlock, 1);
        this.addBlock(world, 7, 13, 2, mainBlock, 1);
        this.addBlock(world, 7, 13, 3, 0, 0);
        this.addBlock(world, 7, 13, 4, 0, 0);
        this.addBlock(world, 7, 13, 5, 0, 0);
        this.addBlock(world, 7, 13, 6, 0, 0);
        this.addBlock(world, 7, 13, 7, 0, 0);
        this.addBlock(world, 7, 13, 8, mainBlock, 1);
        this.addBlock(world, 7, 14, 2, mainBlock, 1);
        this.addBlock(world, 7, 14, 3, 0, 0);
        this.addBlock(world, 7, 14, 4, 0, 0);
        this.addBlock(world, 7, 14, 5, 0, 0);
        this.addBlock(world, 7, 14, 6, 0, 0);
        this.addBlock(world, 7, 14, 7, 0, 0);
        this.addBlock(world, 7, 14, 8, mainBlock, 1);
        this.addBlock(world, 7, 15, 2, mainBlock, 1);
        this.addBlock(world, 7, 15, 3, 0, 0);
        this.addBlock(world, 7, 15, 4, 0, 0);
        this.addBlock(world, 7, 15, 5, 0, 0);
        this.addBlock(world, 7, 15, 6, 0, 0);
        this.addBlock(world, 7, 15, 7, 0, 0);
        this.addBlock(world, 7, 15, 8, mainBlock, 1);
        this.addBlock(world, 7, 16, 2, mainBlock, 1);
        this.addBlock(world, 7, 16, 3, mainBlock, 1);
        this.addBlock(world, 7, 16, 4, mainBlock, 1);
        this.addBlock(world, 7, 16, 5, mainBlock, 1);
        this.addBlock(world, 7, 16, 6, mainBlock, 1);
        this.addBlock(world, 7, 16, 7, mainBlock, 1);
        this.addBlock(world, 7, 16, 8, mainBlock, 1);
        this.addBlock(world, 7, 17, 0, roofBlock, 4);
        this.addBlock(world, 7, 17, 1, roofBlock, 4);
        this.addBlock(world, 7, 17, 2, 0, 0);
        this.addBlock(world, 7, 17, 3, 0, 0);
        this.addBlock(world, 7, 17, 4, 0, 0);
        this.addBlock(world, 7, 17, 5, 0, 0);
        this.addBlock(world, 7, 17, 6, 0, 0);
        this.addBlock(world, 7, 17, 7, 0, 0);
        this.addBlock(world, 7, 17, 8, 0, 0);
        this.addBlock(world, 7, 17, 9, roofBlock, 4);
        this.addBlock(world, 7, 17, 10, roofBlock, 4);
        this.addBlock(world, 7, 18, 1, roofBlock, 4);
        this.addBlock(world, 7, 18, 2, 0, 0);
        this.addBlock(world, 7, 18, 3, 0, 0);
        this.addBlock(world, 7, 18, 4, 0, 0);
        this.addBlock(world, 7, 18, 5, 0, 0);
        this.addBlock(world, 7, 18, 6, 0, 0);
        this.addBlock(world, 7, 18, 7, 0, 0);
        this.addBlock(world, 7, 18, 8, 0, 0);
        this.addBlock(world, 7, 18, 9, roofBlock, 4);
        this.addBlock(world, 7, 19, 2, roofBlock, 4);
        this.addBlock(world, 7, 19, 3, 0, 0);
        this.addBlock(world, 7, 19, 4, 0, 0);
        this.addBlock(world, 7, 19, 5, 0, 0);
        this.addBlock(world, 7, 19, 6, 0, 0);
        this.addBlock(world, 7, 19, 7, 0, 0);
        this.addBlock(world, 7, 19, 8, roofBlock, 4);
        this.addBlock(world, 7, 20, 3, roofBlock, 4);
        this.addBlock(world, 7, 20, 4, 0, 0);
        this.addBlock(world, 7, 20, 5, 0, 0);
        this.addBlock(world, 7, 20, 6, 0, 0);
        this.addBlock(world, 7, 20, 7, roofBlock, 4);
        this.addBlock(world, 7, 21, 4, roofBlock, 4);
        this.addBlock(world, 7, 21, 5, roofBlock, 4);
        this.addBlock(world, 7, 21, 6, roofBlock, 4);
        this.addBlock(world, 8, 0, 3, mainBlock, 1);
        this.addBlock(world, 8, 0, 4, mainBlock, 1);
        this.addBlock(world, 8, 0, 5, mainBlock, 1);
        this.addBlock(world, 8, 0, 6, mainBlock, 1);
        this.addBlock(world, 8, 0, 7, mainBlock, 1);
        this.addBlock(world, 8, 1, 3, mainBlock, 1);
        this.addBlock(world, 8, 1, 4, 0, 0);
        this.addBlock(world, 8, 1, 5, slabBlock, 9);
        this.addBlock(world, 8, 1, 6, slabBlock, 1);
        this.addBlock(world, 8, 1, 7, mainBlock, 1);
        this.addBlock(world, 8, 2, 3, mainBlock, 1);
        this.addBlock(world, 8, 2, 4, slabBlock, 1);
        this.addBlock(world, 8, 2, 5, 0, 0);
        this.addBlock(world, 8, 2, 6, 0, 0);
        this.addBlock(world, 8, 2, 7, mainBlock, 1);
        this.addBlock(world, 8, 3, 3, mainBlock, 1);
        this.addBlock(world, 8, 3, 4, 0, 0);
        this.addBlock(world, 8, 3, 5, 0, 0);
        this.addBlock(world, 8, 3, 6, 0, 0);
        this.addBlock(world, 8, 3, 7, mainBlock, 1);
        this.addBlock(world, 8, 4, 3, mainBlock, 1);
        this.addBlock(world, 8, 4, 4, 0, 0);
        this.addBlock(world, 8, 4, 5, 0, 0);
        this.addBlock(world, 8, 4, 6, 0, 0);
        this.addBlock(world, 8, 4, 7, mainBlock, 1);
        this.addBlock(world, 8, 5, 3, mainBlock, 1);
        this.addBlock(world, 8, 5, 4, 0, 0);
        this.addBlock(world, 8, 5, 5, 0, 0);
        this.addBlock(world, 8, 5, 6, 0, 0);
        this.addBlock(world, 8, 5, 7, mainBlock, 1);
        this.addBlock(world, 8, 6, 3, mainBlock, 1);
        this.addBlock(world, 8, 6, 4, 0, 0);
        this.addBlock(world, 8, 6, 5, 0, 0);
        this.addBlock(world, 8, 6, 6, 0, 0);
        this.addBlock(world, 8, 6, 7, mainBlock, 1);
        this.addBlock(world, 8, 7, 3, mainBlock, 1);
        this.addBlock(world, 8, 7, 4, 0, 0);
        this.addBlock(world, 8, 7, 5, 0, 0);
        this.addBlock(world, 8, 7, 6, 0, 0);
        this.addBlock(world, 8, 7, 7, mainBlock, 1);
        this.addBlock(world, 8, 8, 3, mainBlock, 1);
        this.addBlock(world, 8, 8, 4, mainBlock, 1);
        this.addBlock(world, 8, 8, 5, mainBlock, 1);
        this.addBlock(world, 8, 8, 6, mainBlock, 1);
        this.addBlock(world, 8, 8, 7, mainBlock, 1);
        this.addBlock(world, 8, 9, 3, mainBlock, 1);
        this.addBlock(world, 8, 9, 4, 0, 0);
        this.addBlock(world, 8, 9, 5, slabBlock, 9);
        this.addBlock(world, 8, 9, 6, slabBlock, 1);
        this.addBlock(world, 8, 9, 7, mainBlock, 1);
        this.addBlock(world, 8, 10, 3, mainBlock, 1);
        this.addBlock(world, 8, 10, 4, slabBlock, 1);
        this.addBlock(world, 8, 10, 5, 0, 0);
        this.addBlock(world, 8, 10, 6, 0, 0);
        this.addBlock(world, 8, 10, 7, mainBlock, 1);
        this.addBlock(world, 8, 11, 3, mainBlock, 1);
        this.addBlock(world, 8, 11, 4, 0, 0);
        this.addBlock(world, 8, 11, 5, 0, 0);
        this.addBlock(world, 8, 11, 6, 0, 0);
        this.addBlock(world, 8, 11, 7, mainBlock, 1);
        this.addBlock(world, 8, 12, 3, mainBlock, 1);
        this.addBlock(world, 8, 12, 4, 0, 0);
        this.addBlock(world, 8, 12, 5, 0, 0);
        this.addBlock(world, 8, 12, 6, 0, 0);
        this.addBlock(world, 8, 12, 7, mainBlock, 1);
        this.addBlock(world, 8, 13, 3, mainBlock, 1);
        this.addBlock(world, 8, 13, 4, 0, 0);
        this.addBlock(world, 8, 13, 5, 0, 0);
        this.addBlock(world, 8, 13, 6, 0, 0);
        this.addBlock(world, 8, 13, 7, mainBlock, 1);
        this.addBlock(world, 8, 14, 3, mainBlock, 1);
        this.addBlock(world, 8, 14, 4, 0, 0);
        this.addBlock(world, 8, 14, 5, 0, 0);
        this.addBlock(world, 8, 14, 6, 0, 0);
        this.addBlock(world, 8, 14, 7, mainBlock, 1);
        this.addBlock(world, 8, 15, 3, mainBlock, 1);
        this.addBlock(world, 8, 15, 4, 0, 0);
        this.addBlock(world, 8, 15, 5, 0, 0);
        this.addBlock(world, 8, 15, 6, 0, 0);
        this.addBlock(world, 8, 15, 7, mainBlock, 1);
        this.addBlock(world, 8, 16, 3, mainBlock, 1);
        this.addBlock(world, 8, 16, 4, mainBlock, 1);
        this.addBlock(world, 8, 16, 5, mainBlock, 1);
        this.addBlock(world, 8, 16, 6, mainBlock, 1);
        this.addBlock(world, 8, 16, 7, mainBlock, 1);
        this.addBlock(world, 8, 17, 1, roofBlock, 4);
        this.addBlock(world, 8, 17, 2, roofBlock, 4);
        this.addBlock(world, 8, 17, 3, 0, 0);
        this.addBlock(world, 8, 17, 4, 0, 0);
        this.addBlock(world, 8, 17, 5, 0, 0);
        this.addBlock(world, 8, 17, 6, 0, 0);
        this.addBlock(world, 8, 17, 7, 0, 0);
        this.addBlock(world, 8, 17, 8, roofBlock, 4);
        this.addBlock(world, 8, 17, 9, roofBlock, 4);
        this.addBlock(world, 8, 18, 2, roofBlock, 4);
        this.addBlock(world, 8, 18, 3, 0, 0);
        this.addBlock(world, 8, 18, 4, 0, 0);
        this.addBlock(world, 8, 18, 5, 0, 0);
        this.addBlock(world, 8, 18, 6, 0, 0);
        this.addBlock(world, 8, 18, 7, 0, 0);
        this.addBlock(world, 8, 18, 8, roofBlock, 4);
        this.addBlock(world, 8, 19, 3, roofBlock, 4);
        this.addBlock(world, 8, 19, 4, 0, 0);
        this.addBlock(world, 8, 19, 5, 0, 0);
        this.addBlock(world, 8, 19, 6, 0, 0);
        this.addBlock(world, 8, 19, 7, roofBlock, 4);
        this.addBlock(world, 8, 20, 4, roofBlock, 4);
        this.addBlock(world, 8, 20, 5, roofBlock, 4);
        this.addBlock(world, 8, 20, 6, roofBlock, 4);
        this.addBlock(world, 9, 0, 4, mainBlock, 1);
        this.addBlock(world, 9, 0, 5, mainBlock, 1);
        this.addBlock(world, 9, 0, 6, mainBlock, 1);
        this.addBlock(world, 9, 1, 4, mainBlock, 1);
        this.addBlock(world, 9, 1, 5, mainBlock, 1);
        this.addBlock(world, 9, 1, 6, mainBlock, 1);
        this.addBlock(world, 9, 2, 4, mainBlock, 1);
        this.addBlock(world, 9, 2, 5, mainBlock, 1);
        this.addBlock(world, 9, 2, 6, mainBlock, 1);
        this.addBlock(world, 9, 3, 4, mainBlock, 1);
        this.addBlock(world, 9, 3, 5, windowBlock, 0);
        this.addBlock(world, 9, 3, 6, mainBlock, 1);
        this.addBlock(world, 9, 4, 4, mainBlock, 1);
        this.addBlock(world, 9, 4, 5, windowBlock, 0);
        this.addBlock(world, 9, 4, 6, mainBlock, 1);
        this.addBlock(world, 9, 5, 4, mainBlock, 1);
        this.addBlock(world, 9, 5, 5, mainBlock, 1);
        this.addBlock(world, 9, 5, 6, mainBlock, 1);
        this.addBlock(world, 9, 6, 4, mainBlock, 1);
        this.addBlock(world, 9, 6, 5, mainBlock, 1);
        this.addBlock(world, 9, 6, 6, mainBlock, 1);
        this.addBlock(world, 9, 7, 4, mainBlock, 1);
        this.addBlock(world, 9, 7, 5, mainBlock, 1);
        this.addBlock(world, 9, 7, 6, mainBlock, 1);
        this.addBlock(world, 9, 8, 4, mainBlock, 1);
        this.addBlock(world, 9, 8, 5, mainBlock, 1);
        this.addBlock(world, 9, 8, 6, mainBlock, 1);
        this.addBlock(world, 9, 9, 4, mainBlock, 1);
        this.addBlock(world, 9, 9, 5, mainBlock, 1);
        this.addBlock(world, 9, 9, 6, mainBlock, 1);
        this.addBlock(world, 9, 10, 4, mainBlock, 1);
        this.addBlock(world, 9, 10, 5, mainBlock, 1);
        this.addBlock(world, 9, 10, 6, mainBlock, 1);
        this.addBlock(world, 9, 11, 4, mainBlock, 1);
        this.addBlock(world, 9, 11, 5, windowBlock, 0);
        this.addBlock(world, 9, 11, 6, mainBlock, 1);
        this.addBlock(world, 9, 12, 4, mainBlock, 1);
        this.addBlock(world, 9, 12, 5, windowBlock, 0);
        this.addBlock(world, 9, 12, 6, mainBlock, 1);
        this.addBlock(world, 9, 13, 4, mainBlock, 1);
        this.addBlock(world, 9, 13, 5, mainBlock, 1);
        this.addBlock(world, 9, 13, 6, mainBlock, 1);
        this.addBlock(world, 9, 14, 4, mainBlock, 1);
        this.addBlock(world, 9, 14, 5, mainBlock, 1);
        this.addBlock(world, 9, 14, 6, mainBlock, 1);
        this.addBlock(world, 9, 15, 4, mainBlock, 1);
        this.addBlock(world, 9, 15, 5, mainBlock, 1);
        this.addBlock(world, 9, 15, 6, mainBlock, 1);
        this.addBlock(world, 9, 16, 4, mainBlock, 1);
        this.addBlock(world, 9, 16, 5, mainBlock, 1);
        this.addBlock(world, 9, 16, 6, mainBlock, 1);
        this.addBlock(world, 9, 17, 2, roofBlock, 4);
        this.addBlock(world, 9, 17, 3, roofBlock, 4);
        this.addBlock(world, 9, 17, 4, 0, 0);
        this.addBlock(world, 9, 17, 6, 0, 0);
        this.addBlock(world, 9, 17, 7, roofBlock, 4);
        this.addBlock(world, 9, 17, 8, roofBlock, 4);
        this.addBlock(world, 9, 18, 3, roofBlock, 4);
        this.addBlock(world, 9, 18, 4, 0, 0);
        this.addBlock(world, 9, 18, 5, 0, 0);
        this.addBlock(world, 9, 18, 6, 0, 0);
        this.addBlock(world, 9, 18, 7, roofBlock, 4);
        this.addBlock(world, 9, 19, 4, roofBlock, 4);
        this.addBlock(world, 9, 19, 5, roofBlock, 4);
        this.addBlock(world, 9, 19, 6, roofBlock, 4);
        this.addBlock(world, 10, 4, 4, stairBlock, l1);
        this.addBlock(world, 10, 4, 6, stairBlock, l1);
        this.addBlock(world, 10, 5, 5, stairBlock, l);
        this.addBlock(world, 10, 12, 4, stairBlock, l1);
        this.addBlock(world, 10, 12, 6, stairBlock, l1);
        this.addBlock(world, 10, 13, 5, stairBlock, l);
        this.addBlock(world, 10, 17, 3, roofBlock, 4);
        this.addBlock(world, 10, 17, 4, roofBlock, 4);
        this.addBlock(world, 10, 17, 5, roofBlock, 4);
        this.addBlock(world, 10, 17, 6, roofBlock, 4);
        this.addBlock(world, 10, 17, 7, roofBlock, 4);
        this.addBlock(world, 10, 18, 4, roofBlock, 4);
        this.addBlock(world, 10, 18, 5, roofBlock, 4);
        this.addBlock(world, 10, 18, 6, roofBlock, 4);
        this.addBlock(world, 5, 25, 5, cannonBlock, -1);
        Class<EntityUnderworldSkeleton> e = EntityUnderworldSkeleton.class;
        this.addSpawner(world, 5, 0, 5, e);
        this.addSpawner(world, 5, 8, 5, e);
        this.addSpawner(world, 5, 16, 5, e);
        int c0 = LCMisc.getMetadataWithOffsetChest(this.func_186165_e(), 5);
        int c1 = LCMisc.getMetadataWithOffsetChest(this.func_186165_e(), 3);
        int c2 = LCMisc.getMetadataWithOffsetChest(this.func_186165_e(), 2);
        int c3 = LCMisc.getMetadataWithOffsetChest(this.func_186165_e(), 4);
        this.lootChests.setChestPlaced(0, this.generateStructureChestContents(world, box, rand, 1, 17, 5, c0));
        this.lootChests.setChestPlaced(1, this.generateStructureChestContents(world, box, rand, 5, 17, 1, c1));
        this.lootChests.setChestPlaced(2, this.generateStructureChestContents(world, box, rand, 5, 17, 9, c2));
        this.lootChests.setChestPlaced(3, this.generateStructureChestContents(world, box, rand, 9, 17, 5, c3));
        return true;
    }

    static {
        roofBlock = mainBlock = LCBlocks.stoneBlock;
        lightBlock = LCBlocks.lightBlock;
        windowBlock = Blocks.field_150411_aY;
        slabBlock = LCBlocks.slabBlock;
        cannonBlock = LCBlocks.lightningCannon;
    }
}

