/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.blocks;

import com.lightningcraft.blocks.BlockContainerLCMeta;
import com.lightningcraft.items.blocks.ItemBlockWireless;
import com.lightningcraft.main.LightningCraft;
import com.lightningcraft.tiles.TileEntityLightningReceiver;
import com.lightningcraft.tiles.TileEntityLightningTransmitter;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockWireless
extends BlockContainerLCMeta {
    public static final int nTransmitters = 3;
    public static final int nReceivers = 3;
    public static final int nSubBlocks = 6;

    public BlockWireless() {
        super(Blocks.field_150339_S, 6, 5.0f, 30.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        WirelessSpecs params = new WirelessSpecs();
        if (this.getTileEntityPerformance(meta, params)) {
            return new TileEntityLightningTransmitter(params.range, params.quality);
        }
        return new TileEntityLightningReceiver(params.rolloff);
    }

    public boolean getTileEntityPerformance(int meta, WirelessSpecs params) {
        if (meta < 3) {
            switch (meta) {
                case 0: {
                    params.range = 32.0;
                    params.quality = 0.45;
                    break;
                }
                case 1: {
                    params.range = 48.0;
                    params.quality = 0.65;
                    break;
                }
                case 2: {
                    params.range = 64.0;
                    params.quality = 0.95;
                    break;
                }
                default: {
                    params.range = 0.0;
                    params.quality = 1.0;
                }
            }
            return true;
        }
        switch (meta - 3) {
            case 0: {
                params.rolloff = 2.5E-4;
                break;
            }
            case 1: {
                params.rolloff = 1.5E-4;
                break;
            }
            case 2: {
                params.rolloff = 7.5E-5;
                break;
            }
            default: {
                params.rolloff = 1.0;
            }
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 6; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack s, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.func_176201_c(state) >= 3) {
            player.openGui((Object)LightningCraft.modInstance, 6, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    @Override
    public Class getItemClass() {
        return ItemBlockWireless.class;
    }

    public static class WirelessSpecs {
        public double range;
        public double quality;
        public double rolloff;
    }
}

