/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import com.lightningcraft.blocks.IFurnace;
import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.recipes.LightningCrusherRecipes;
import com.lightningcraft.tiles.ISidedInventoryLC;
import com.lightningcraft.tiles.TileEntityLightningUser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLightningCrusher
extends TileEntityLightningUser
implements ISidedInventoryLC {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{1};
    private static final int[] slotsSides = new int[]{0};
    public static final int burnTime = 160;
    public static final double energyUsage = 5.0;
    private ItemStack[] crusherItemStacks = new ItemStack[2];
    public int crusherBurnTime;
    public int crusherCookTime;
    public int currentBurnTime;
    private String crusherName;

    public void furnaceName(String string) {
        this.crusherName = string;
    }

    public int func_70302_i_() {
        return this.crusherItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.crusherItemStacks[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.crusherItemStacks[par1] != null) {
            if (this.crusherItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.crusherItemStacks[par1];
                this.crusherItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.crusherItemStacks[par1].func_77979_a(par2);
            if (this.crusherItemStacks[par1].field_77994_a == 0) {
                this.crusherItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.crusherItemStacks[slot] != null) {
            ItemStack itemstack = this.crusherItemStacks[slot];
            this.crusherItemStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.crusherItemStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.crusherName : LCBlocks.lightningCrusher.func_149732_F();
    }

    public boolean func_145818_k_() {
        return this.crusherName != null && this.crusherName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.crusherCookTime * par1 / 80;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 80;
        }
        return this.crusherBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.crusherBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.crusherCookTime > 0;
        boolean dosave = false;
        if (this.crusherBurnTime > 0) {
            --this.crusherBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.crusherBurnTime == 0 && this.canCrush()) {
                this.crusherBurnTime = 160;
                this.currentBurnTime = 160;
                if (this.crusherBurnTime > 0) {
                    dosave = true;
                    this.drawCellPower(5.0);
                }
            }
            if (this.isBurning() && this.canCrush()) {
                ++this.crusherCookTime;
                if (this.crusherCookTime == 80) {
                    this.crusherCookTime = 0;
                    this.crushItem();
                    dosave = true;
                }
            } else {
                this.crusherCookTime = 0;
            }
            if (burning != this.crusherCookTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.crusherCookTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    private boolean canCrush() {
        if (!this.hasLPCell() || !this.canDrawCellPower(5.0)) {
            return false;
        }
        if (this.crusherItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = LightningCrusherRecipes.instance().getCrushingResult(this.crusherItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.crusherItemStacks[1] == null) {
            return true;
        }
        if (!this.crusherItemStacks[1].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.crusherItemStacks[1].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.crusherItemStacks[1].func_77976_d();
    }

    private void crushItem() {
        if (this.canCrush()) {
            ItemStack itemstack = LightningCrusherRecipes.instance().getCrushingResult(this.crusherItemStacks[0]);
            if (this.crusherItemStacks[1] == null) {
                this.crusherItemStacks[1] = itemstack.func_77946_l();
            } else if (this.crusherItemStacks[1].func_77973_b() == itemstack.func_77973_b()) {
                this.crusherItemStacks[1].field_77994_a += itemstack.field_77994_a;
            }
            --this.crusherItemStacks[0].field_77994_a;
            if (this.crusherItemStacks[0].field_77994_a <= 0) {
                this.crusherItemStacks[0] = null;
            }
        }
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return par1 != 1;
    }

    public int[] func_180463_a(EnumFacing facing) {
        int par1 = facing.func_176745_a();
        return par1 == 0 ? slotsBottom : (par1 == 1 ? slotsSides : slotsTop);
    }

    public boolean func_180462_a(int par1, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(par1, itemstack);
    }

    public boolean func_180461_b(int par1, ItemStack itemstack, EnumFacing facing) {
        return facing.func_176745_a() != 0 || par1 == 1 || itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.crusherItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.crusherItemStacks.length) continue;
            this.crusherItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
        this.crusherBurnTime = tagCompound.func_74765_d("BurnTime");
        this.crusherCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = 160;
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.crusherName = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.crusherBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.crusherBurnTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.crusherItemStacks.length; ++i) {
            if (this.crusherItemStacks[i] == null) continue;
            NBTTagCompound tagCompound1 = new NBTTagCompound();
            tagCompound1.func_74774_a("Slot", (byte)i);
            this.crusherItemStacks[i].func_77955_b(tagCompound1);
            tagList.func_74742_a((NBTBase)tagCompound1);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.crusherName);
        }
    }
}

