/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.tiles;

import com.lightningcraft.blocks.IFurnace;
import com.lightningcraft.blocks.LCBlocks;
import com.lightningcraft.recipes.LightningInfusionRecipes;
import com.lightningcraft.tiles.ISidedInventoryLC;
import com.lightningcraft.tiles.TileEntityLightningUser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLightningInfuser
extends TileEntityLightningUser
implements ISidedInventoryLC {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{5};
    private static final int[] slotsSides = new int[]{1, 2, 3, 4};
    public static final int burnTime = 600;
    private ItemStack[] infuserItemStacks = new ItemStack[6];
    public int infuserBurnTime;
    public int infuserCookTime;
    public int currentBurnTime;
    private String infuserName;
    public int infusionCost;

    public void infuserName(String string) {
        this.infuserName = string;
    }

    public int func_70302_i_() {
        return this.infuserItemStacks.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.infuserItemStacks[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.infuserItemStacks[par1] != null) {
            if (this.infuserItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.infuserItemStacks[par1];
                this.infuserItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.infuserItemStacks[par1].func_77979_a(par2);
            if (this.infuserItemStacks[par1].field_77994_a == 0) {
                this.infuserItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.infuserItemStacks[slot] != null) {
            ItemStack itemstack = this.infuserItemStacks[slot];
            this.infuserItemStacks[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.infuserItemStacks[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.infuserName : LCBlocks.lightningInfuser.func_149732_F();
    }

    public boolean func_145818_k_() {
        return this.infuserName != null && this.infuserName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getInfusionProgressScaled(int par1) {
        return this.infuserCookTime * par1 / 600;
    }

    @SideOnly(value=Side.CLIENT)
    public int getInfusionTimeRemainingScaled(int par1) {
        if (this.currentBurnTime == 0) {
            this.currentBurnTime = 600;
        }
        return this.infuserBurnTime * par1 / this.currentBurnTime;
    }

    public boolean isBurning() {
        return this.infuserBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burning = this.infuserCookTime > 0;
        boolean dosave = false;
        if (this.infuserBurnTime > 0) {
            --this.infuserBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.infuserBurnTime == 0 && this.canInfuse()) {
                this.infuserBurnTime = 600;
                this.currentBurnTime = 600;
                if (this.infuserBurnTime > 0) {
                    dosave = true;
                }
            }
            if (this.isBurning() && this.canInfuse()) {
                ++this.infuserCookTime;
                if (this.infuserCookTime == 600) {
                    this.infuserCookTime = 0;
                    this.infuseItem();
                    dosave = true;
                }
            } else {
                this.infuserCookTime = 0;
            }
            if (burning != this.infuserCookTime > 0) {
                dosave = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                ((IFurnace)state.func_177230_c()).setBurning(state, (IBlockAccess)this.field_145850_b, this.field_174879_c, this.infuserCookTime > 0);
            }
        }
        if (dosave) {
            this.func_70296_d();
        }
    }

    private boolean canInfuse() {
        this.infusionCost = 0;
        if (!this.hasLPCell()) {
            return false;
        }
        if (this.infuserItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = LightningInfusionRecipes.instance().getInfusionResult(this.infuserItemStacks[0], this.infuserItemStacks[1], this.infuserItemStacks[2], this.infuserItemStacks[3], this.infuserItemStacks[4]);
        this.infusionCost = LightningInfusionRecipes.instance().getLastResultCost();
        if (itemstack == null) {
            return false;
        }
        if (this.infusionCost <= 0) {
            return false;
        }
        if (!this.canDrawCellPower(this.infusionCost)) {
            return false;
        }
        if (this.infuserItemStacks[5] == null) {
            return true;
        }
        if (!this.infuserItemStacks[5].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.infuserItemStacks[5].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.infuserItemStacks[5].func_77976_d();
    }

    private void infuseItem() {
        if (this.canInfuse()) {
            ItemStack itemstack = LightningInfusionRecipes.instance().getInfusionResult(this.infuserItemStacks[0], this.infuserItemStacks[1], this.infuserItemStacks[2], this.infuserItemStacks[3], this.infuserItemStacks[4]);
            int cost = LightningInfusionRecipes.instance().getLastResultCost();
            this.drawCellPower(cost);
            if (this.infuserItemStacks[5] == null) {
                this.infuserItemStacks[5] = itemstack.func_77946_l();
            } else if (this.infuserItemStacks[5].func_77973_b() == itemstack.func_77973_b()) {
                this.infuserItemStacks[5].field_77994_a += itemstack.field_77994_a;
            }
            for (int i = 0; i < 5; ++i) {
                if (this.infuserItemStacks[i] == null) continue;
                --this.infuserItemStacks[i].field_77994_a;
                if (this.infuserItemStacks[i].field_77994_a > 0) continue;
                this.infuserItemStacks[i] = null;
            }
        }
    }

    public boolean func_94041_b(int par1, ItemStack itemstack) {
        return par1 != 5;
    }

    public int[] func_180463_a(EnumFacing facing) {
        int par1 = facing.func_176745_a();
        return par1 == 0 ? slotsBottom : (par1 == 1 ? slotsSides : slotsTop);
    }

    public boolean func_180462_a(int par1, ItemStack itemstack, EnumFacing facing) {
        return this.func_94041_b(par1, itemstack);
    }

    public boolean func_180461_b(int par1, ItemStack itemstack, EnumFacing facing) {
        return facing.func_176745_a() != 0 || par1 == 5 || itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
        this.infuserItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.infuserItemStacks.length) continue;
            this.infuserItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
        this.infuserBurnTime = tagCompound.func_74765_d("BurnTime");
        this.infuserCookTime = tagCompound.func_74765_d("CookTime");
        this.currentBurnTime = 600;
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.infuserName = tagCompound.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.infuserBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.infuserBurnTime);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.infuserItemStacks.length; ++i) {
            if (this.infuserItemStacks[i] == null) continue;
            NBTTagCompound tagCompound1 = new NBTTagCompound();
            tagCompound1.func_74774_a("Slot", (byte)i);
            this.infuserItemStacks[i].func_77955_b(tagCompound1);
            tagList.func_74742_a((NBTBase)tagCompound1);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.infuserName);
        }
    }
}

