/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.worldgen.structure;

import com.lightningcraft.util.WorldUtils;
import com.lightningcraft.worldgen.structure.LootChestGroup;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class Feature
extends StructureComponent {
    protected LootChestGroup lootChests;
    protected int scatteredFeatureSizeX;
    protected int scatteredFeatureSizeY;
    protected int scatteredFeatureSizeZ;
    protected int structY = -1;
    protected int spawnMinY;
    protected int spawnMaxY;

    public Feature() {
    }

    protected Feature(Random rand, int x, int y, int z, int sx, int sy, int sz, boolean useRandomCoordBaseMode) {
        super(0);
        this.scatteredFeatureSizeX = sx;
        this.scatteredFeatureSizeY = sy;
        this.scatteredFeatureSizeZ = sz;
        if (useRandomCoordBaseMode) {
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        } else {
            this.func_186164_a(EnumFacing.SOUTH);
        }
        switch (this.func_186165_e()) {
            case NORTH: 
            case SOUTH: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sx - 1, y + sy - 1, z + sz - 1);
                break;
            }
            default: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sz - 1, y + sy - 1, z + sx - 1);
            }
        }
    }

    protected Feature(Random rand, int x, int y, int z, int sx, int sy, int sz) {
        this(rand, x, y, z, sx, sy, sz, true);
    }

    protected void func_143012_a(NBTTagCompound tag) {
        tag.func_74768_a("Width", this.scatteredFeatureSizeX);
        tag.func_74768_a("Height", this.scatteredFeatureSizeY);
        tag.func_74768_a("Depth", this.scatteredFeatureSizeZ);
        tag.func_74768_a("HPos", this.structY);
        this.lootChests.writeToNBT(tag);
    }

    protected void func_143011_b(NBTTagCompound tag) {
        this.scatteredFeatureSizeX = tag.func_74762_e("Width");
        this.scatteredFeatureSizeY = tag.func_74762_e("Height");
        this.scatteredFeatureSizeZ = tag.func_74762_e("Depth");
        this.structY = tag.func_74762_e("HPos");
        this.lootChests.readFromNBT(tag);
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta, int chestIndex) {
        return this.generateStructureChestContents(world, box, rand, x, y, z, meta, this.lootChests.getChestContents(chestIndex), this.lootChests.getStackCount(rand, chestIndex), this.lootChests.getIsTrapped(chestIndex));
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta) {
        return this.generateStructureChestContents(world, box, rand, x, y, z, meta, this.lootChests.getChestContents(), this.lootChests.getStackCount(rand), false);
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta, List<WeightedRandomChestContent> chest, int count, boolean isTrapped) {
        int i1 = this.func_74865_a(x, z);
        int j1 = this.func_74862_a(y);
        int k1 = this.func_74873_b(x, z);
        BlockPos pos = new BlockPos(i1, j1, k1);
        Object chestBlock = isTrapped ? Blocks.field_150447_bR : Blocks.field_150486_ae;
        if (world.func_180495_p(pos).func_177230_c() != chestBlock) {
            IBlockState iblockstate = chestBlock.func_176203_a(meta);
            world.func_180501_a(pos, iblockstate, 2);
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof TileEntityChest) {
                WorldUtils.generateChestContents(rand, chest, (TileEntityChest)tileentity, count);
            }
            return true;
        }
        return false;
    }

    protected boolean generateStructureChestContents(World world, StructureBoundingBox box, Random rand, int x, int y, int z, int meta, List<WeightedRandomChestContent> chest, int count) {
        return this.generateStructureChestContents(world, box, rand, x, y, z, meta, chest, count, false);
    }

    protected void addBlock(World world, int x, int y, int z, Block block, int meta) {
        boolean ignoreBox = false;
        if (meta < 0) {
            meta = 0;
            ignoreBox = true;
        }
        this.placeBlockAtCurrentPosition(world, block, meta, x, y, z, this.field_74887_e, ignoreBox);
    }

    protected void addBlock(World world, int x, int y, int z, int block, int meta) {
        this.placeBlockAtCurrentPosition(world, Block.func_149729_e((int)block), meta, x, y, z, this.field_74887_e, false);
    }

    protected void placeBlockAtCurrentPosition(World world, Block b, int meta, int x, int y, int z, StructureBoundingBox box, boolean ignoreBox) {
        int k1;
        int j1;
        int i1 = this.func_74865_a(x, z);
        if (box.func_175898_b(new Vec3i(i1, j1 = this.func_74862_a(y), k1 = this.func_74873_b(x, z))) || ignoreBox) {
            IBlockState state = b.func_176203_a(meta);
            world.func_180501_a(new BlockPos(i1, j1, k1), state, 2);
        }
    }

    protected void addSpawner(World world, int x, int y, int z, Class<? extends Entity> entityClass) {
        this.addBlock(world, x, y, z, Blocks.field_150474_ac, -1);
        int i1 = this.func_74865_a(x, z);
        int j1 = this.func_74862_a(y);
        int k1 = this.func_74873_b(x, z);
        BlockPos pos = new BlockPos(i1, j1, k1);
        TileEntityMobSpawner tile = (TileEntityMobSpawner)world.func_175625_s(pos);
        tile.func_145881_a().func_98272_a((String)EntityList.field_75626_c.get(entityClass));
    }

    protected abstract boolean findSpawnPosition(World var1, StructureBoundingBox var2, int var3);
}

