/*
 * Decompiled with CFR 0.152.
 */
package com.lightningcraft.worldgen.structure;

import com.lightningcraft.util.IntList;
import com.lightningcraft.util.JointList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;

public class LootChestGroup {
    private int numChests;
    private JointList<Boolean> isPlaced = new JointList();
    private JointList<Boolean> isTrapped = new JointList();
    private JointList<WeightedRandomChestContent> defaultContents = new JointList();
    private JointList<JointList<WeightedRandomChestContent>> chestContents = new JointList();
    private IntList minChestStacks = new IntList();
    private IntList maxChestStacks = new IntList();
    private int minDefaultStacks;
    private int maxDefaultStacks;

    public LootChestGroup(int numChests, int minStacks, int maxStacks, WeightedRandomChestContent[] chestContents) {
        this.numChests = numChests;
        this.isPlaced.join(false, numChests);
        this.minDefaultStacks = minStacks;
        this.minChestStacks.join(Integer.valueOf(this.minDefaultStacks), numChests);
        this.maxDefaultStacks = maxStacks;
        this.maxChestStacks.join(Integer.valueOf(this.maxDefaultStacks), numChests);
        this.defaultContents = new JointList<WeightedRandomChestContent>().join(chestContents);
        this.chestContents.join(this.defaultContents, numChests);
        this.isTrapped.join(false, numChests);
    }

    public void setChestContents(WeightedRandomChestContent[] chestContents) {
        this.defaultContents = new JointList<WeightedRandomChestContent>().join(chestContents);
    }

    public void setChestContents(int index, WeightedRandomChestContent[] chestContents) {
        JointList<WeightedRandomChestContent> singleContents = new JointList<WeightedRandomChestContent>().join(chestContents);
        this.chestContents.set(index, singleContents);
    }

    public List<WeightedRandomChestContent> getChestContents() {
        return this.defaultContents;
    }

    public List<WeightedRandomChestContent> getChestContents(int index) {
        return (List)this.chestContents.get(index);
    }

    public void setChestPlaced(int index, boolean status) {
        if (index < this.isPlaced.size()) {
            this.isPlaced.set(index, status);
        }
    }

    public boolean getChestPlaced(int index) {
        if (index < this.isPlaced.size()) {
            return (Boolean)this.isPlaced.get(index);
        }
        return false;
    }

    public void setStackMinMax(int index, int min, int max) {
        this.minChestStacks.set(index, min);
        this.maxChestStacks.set(index, max);
    }

    public int getStackCount(Random rand, int index) {
        return rand.nextInt((Integer)this.maxChestStacks.get(index) - (Integer)this.minChestStacks.get(index) + 1) + (Integer)this.minChestStacks.get(index);
    }

    public int getStackCount(Random rand) {
        return rand.nextInt(this.maxDefaultStacks - this.minDefaultStacks + 1) + this.minDefaultStacks;
    }

    public boolean getIsTrapped(int index) {
        return (Boolean)this.isTrapped.get(index);
    }

    public void setIsTrapped(int index, boolean status) {
        this.isTrapped.set(index, status);
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.numChests; ++i) {
            tag.func_74757_a("placedChest" + i, ((Boolean)this.isPlaced.get(i)).booleanValue());
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.numChests; ++i) {
            this.isPlaced.set(i, tag.func_74767_n("placedChest" + i));
        }
    }
}

