# 组件
> diboot组件基于Ant Design Vue进行二次封装和业务调整，搭配devtools后端接口服务，**一键生成交互代码**，减少您的学习成本。 
::: tip
以下内容为组件概述，实际开发时，建议直接使用devtools生成前端代码。
:::
## import组件
> 路径：src/components/diboot/components/import/**.vue
>
> 功能：提供excel导入、示例下载、数据预览等功能

- 属性

| 名称             | 说明          | 类型	|默认值 | 必填|
| -------------   |:-------------| -----| -----| -----|
| exampleUrl   |示例文件地址| string| -| Y|
| uploadUrl   |上传地址| string| -| Y|
| previewUrl   |预览地址| string| -| Y|
| previewSaveUrl   |预览后保存地址| string| -| Y|
| fieldsRequired   |提交时候必须的参数| object| {}| N|
- 事件

| 名称             | 说明          |
| -------------   |:-------------|
| finishedUpload   |数据上传至数据库成功后触发|

- 示例
```vue
<a-drawer
   title="数据上传"
   :width="720"
   @close="close"
   :visible="visible"
   :body-style="{ paddingBottom: '80px' }"
>
    <excel-import
      v-if="visible"
      :example-url="`${baseApi}/downloadExample/room-example.xlsx`"
      :upload-url="`${baseApi}/upload`"
      :preview-url="`${baseApi}/preview`"
      :preview-save-url="`${baseApi}/previewSave`"
      @finishedUpload="handleFinishedUpload"
    ></excel-import>
    <div class="drawer-footer">
        <a-button @click="close">关闭</a-button>
    </div>
</a-drawer>

<script>
import ExcelImport from '@/components/diboot/components/import/ExcelImport'
export default {
  name: 'ImportExample',
  data() {
    return {
      baseApi: '/importExample/excel',
      visible: false
    }
  },
  methods: {
    open() {
      this.visible = true
    },
    /**
     * 刷新数据
     */
    handleFinishedUpload() {
      //触发上传完成，告知list组件
      this.$emit('complete')
      this.visible = false
    },
    close() {
      this.visible = false
    }
  },
  components: {
    ExcelImport
  }
}
</script>
```

## richText组件
> 概述：富文本组件基于quill封装，提供简单的富文本功能
>
> 路径：src/components/diboot/components/richText/**.vue
>
> 功能：**QuillEditor.vue(富文本组件)** 和 **QuillHtmlRender.vue(渲染富文本组件)**

- QuillEditor.vue属性

| 名称             | 说明          | 类型	|
| -------------   |:-------------| -----|
| value   |v-decorator绑定的值| string|
| placeholder   |富文本框的提示| string|

- QuillEditor.vue事件

| 名称             | 说明          |
| -------------   |:-------------|
| change   |直接使用v-decorator绑定属性值即可|

- QuillEditor.vue示例
```html
<!--v-if主要为了强制刷新富文本子组件，否则在打开更新的时候不会更新字段值-->
<quill-editor
  v-if="state.visible"
  placeholder="请输入富文本编辑"
  v-decorator="[
    'richText',
    {
      initialValue: model.richText
    }
  ]"
></quill-editor>
```
- QuillHtmlRender.vue属性

| 名称             | 说明          | 类型	|
| -------------   |:-------------| -----|
| content   |富文本内容| string|

- QuillEditor.vue示例
```html
<quill-html-render :content="model.richText"></quill-html-render>
```
## upload组件
> 概述：基于Ant Design Vue的upload组件封装，更加贴合diboot接口服务
>
> 路径：src/components/diboot/components/upload/Upload.vue
>
> 功能：增加图片form校验、增强与后端接口交互，简化代码流程

- 属性

| 名称             | 说明          | 类型	|默认值 | 必填|
| -------------   |:-------------| -----| -----| -----|
| prefix   |地址前缀（axios的baseUrl），用于图片回显| string| -| N|
| action   |向后端发送的请求地址| string| -| Y|
| relObjType   |绑定的业务对象类名| string| -| Y|
| relObjField   |绑定业务对象的属性| string| -| Y|
| fileList   |文件存储位置| array| -| Y|
| listType   |上传列表的内建样式，支持text/picture-card| string| text(isImage为true时，使用picture-card)| N|
| limitCount   |上传数量限制）| number| 1| N|
| limitType   |上传类型限制，不传默认所有文件，限制多个使用','分割| string| -| N|
| limitSize   |单个文件上传大小(M)| number| 2| N|
| isImage   |是否是图片，默认不是图片类型（主要用户上传后构建值）| boolean| false| N|
| uploadText   |上传框里面的文本| string| 上传| N|
| value   |v-decorator绑定的值| string| -| Y|


- 事件

| 名称             | 说明          |
| -------------   |:-------------|
| change   |直接使用v-decorator绑定属性值即可|

- 示例
```vue
<el-form-item label="轮播图" >
  <upload
    v-if="state.visible"
    :prefix="filePrefix"
    :action="fileAction"
    :file-list="fileWrapper.slideshowImgsList"
    :rel-obj-type="relObjType"
    rel-obj-field="slideshowImgs"
    :limit-count="9"
    :is-image="true"
    list-type="picture-card"
    v-decorator="[
       'slideshowImgs',
       {
         initialValue: model.slideshowImgs
       }
     ]"
  ></upload>
</el-form-item>

<el-form-item label="附件" >
  <upload
    v-if="state.visible"
    :prefix="filePrefix"
    :action="fileAction"
    :file-list="fileWrapper.attachmentList"
    :rel-obj-type="relObjType"
    rel-obj-field="attachment"
    :limit-count="1"
    v-decorator="[
       'attachment',
       {
         initialValue: model.attachment
       }
     ]"
  ></upload>
</el-form-item>
<script>
import form from '@/components/diboot/mixins/form'
import Upload from '@/components/diboot/components/upload/Upload'
import { dibootApi } from '@/utils/request'
export default {
  name: 'UploadExampleForm',
  components: {
    Upload
  },
  mixins: [form],
  data() {
    return {
      baseApi: '/uploadExample',
      filePrefix: '/api',
      fileAction: '/uploadFile/upload/dto',
      //当前业务对象类名
      relObjType: 'UploadExample',
      fileWrapper: {
        //轮播图存放位置
        slideshowImgsList: [],
        //附件存放位置
        attachmentList: [],
      },
      isUpload: true
    }
  },
  methods: {
    enhance(values) {
      // 设置文件uuid
      this.__setFileUuidList__(values)
    },
    /**
     * 打开表单之后的操作， 加载
     * @param id
     */
    afterOpen(id) {
      if (id) {
        // 更新的时候加载上传的轮播图
        dibootApi.get(`/uploadFile/getList/${id}/${this.relObjType}/slideshowImgs`).then(res => {
          if (res.code === 0) {
            if (res.data && res.data.length > 0) {
              res.data.forEach(data => {
                this.fileWrapper.slideshowImgsList.push(this.fileFormatter(data, true))
              })
            }
          }
        })
        // 更新的时候加载上传 附件
        dibootApi.get(`/uploadFile/getList/${id}/${this.relObjType}/attachment`).then(res => {
          if (res.code === 0) {
            if (res.data && res.data.length > 0) {
              res.data.forEach(data => {
                this.fileWrapper.attachmentList.push(this.fileFormatter(data))
              })
            }
          }
        })
      }
    },
    /**
     * 数据转化
     */
    fileFormatter (data, isImage) {
      const file = {
        uid: data.uuid, // 文件唯一标识，建议设置为负数，防止和内部产生的 id 冲突
        name: data.fileName || ' ', // 文件名
        status: 'done', // 状态有：uploading done error removed
        response: '{"status": "success"}', // 服务端响应内容
        filePath: data.accessUrl
      }
      if (isImage) {
        Object.assign(file, {
          url: `${this.filePrefix}${data.accessUrl}/image`,
          thumbUrl: `${this.filePrefix}${data.accessUrl}/image`
        })
      }
      return file
    }
  },
}
</script>
```