# IAM-base: 身份认证与访问控制组件 (基础版)

## 组件特性
* 开箱即用的RBAC角色权限模型
* 基于JWT的认证授权，支持申请token、刷新token
* 简化的BindPermission注解，支持兼容shiro的简化权限绑定与自动鉴权
* 简化的Log注解记录操作日志
* 自动提取需要验证的后端接口, 借助前端功能方便绑定前后端菜单按钮权限
* 预置用户名密码登录(密码带盐加密), 并支持多种登录方式扩展
* 预置默认用户实体，并支持灵活替换用户类型
* 默认启用内存缓存，并支持自定义缓存实现类
* starter启动自动安装依赖的数据表，启用devtools，还可一键生成初始controller代码到本地

## 角色权限模型说明

![角色权限模型](./images/iam-base.png)
基于“用户-角色-权限”的基础模型扩展“账号”实体，以支持多种登录方式。

> 组件包含了与此模型相关的后端代码，且依赖的数据结构在组件starter初次启动时将自动初始化。

> 配套的前端基础框架有antd、element-ui，前端代码参考: diboot-antd-admin 及 diboot-element-admin