# IAM-base 使用说明

## 1、引入依赖
Gradle:
~~~gradle
compile("com.diboot:diboot-iam-base-spring-boot-starter:{latestVersion}")
~~~
或Maven
~~~xml
<dependency>
    <groupId>com.diboot</groupId>
    <artifactId>diboot-iam-base-spring-boot-starter</artifactId>
    <version>{latestVersion}</version>
</dependency>
~~~

> 配置了数据库连接，初次启动时iam-base starter组件会自初始化，生成相关的表及初始数据。

> 如果使用diboot-devtools，还需要引入devtools相关依赖，可一键生成iam-base相关的controller。

注: iam初始化的账号密码为: **admin/123456** ，启动成功后请及时修改密码。

## 2、参数配置：

* 注解配置：
请确保您的启动类或者配置类上配置了**@EnableTransactionManagement**注解，如：

```java
@EnableTransactionManagement
@SpringBootApplication
public class Application {
	public static void main(String[] args) {
		SpringApplication.run(Application.class, args);
	}
}
```

* 配置文件配置项：
```properties

#JWT的签名key，需自定义
diboot.iam.jwt-signkey=xxx
#JWT的token过期时间（分），默认为60分钟
diboot.iam.jwt-token-expires-minutes=60

#Shiro的匿名urls，用逗号分隔
diboot.iam.anon-urls=/test/**,/abc/**

#是否开启权限检查，默认true。改为false后结合anno-urls=/**配置，可忽略权限检查，便于开发环境调试
diboot.iam.enable-permission-check=true

#缓存实现类，默认为: org.apache.shiro.cache.MemoryConstrainedCacheManager
diboot.iam.cache-manager-class=org.apache.shiro.cache.MemoryConstrainedCacheManager
```

> IAM-base组件

## 3、认证与授权
* 登录/申请token（后端）: 
~~~java
PwdCredential credential = new PwdCredential("admin", "123456"); //默认预置管理员的账号密码
String authtoken = AuthServiceFactory.getAuthService(Cons.DICTCODE_AUTH_TYPE.PWD.name()).applyToken(credential);
~~~
* 前端登录拿到token后缓存并将其加入每次请求的header中，属性名为: **authtoken**

* 当token的有效期剩余不足1/4时，组件会自动生成新的token写入response的header中，属性名同样为: **authtoken**。
前端检查response的header如果有新的authtoken，则替换本地的缓存值。


## 4、BindPermission注解使用
* 支持在Controller的类及方法上添加，权限识别码支持类似Spring @RequestMapping注解的“类+方法”拼接功能，
方法上的注解支持自动鉴权，同时可被继承。如：
~~~java
@RequestMapping("/user")
@BindPermission(name = "用户") // code可选,默认自动识别; sortId可选
//继承类支持自动识别code为当前entity类名："IamUser"
public class IamUserController extends BaseCrudRestController<IamUser> {
    @GetMapping("/test")
    @BindPermission(name = "自定义", code = "test") // 拼接后的code=IamUser:test
    // 以上注解支持自动鉴权，与 @RequiresPermissions(values={"IamUser:test"}) 等效，省掉前缀以简化及继承。
    public JsonResult custom(){
    }
}
~~~

* * BindPermission注解支持自动提取需要认证的接口列表，提供给前端进行快捷绑定。

## 5、Log操作日志注解使用
> @Log 注解支持自动记录操作日志至iam_operation_log表，Log注解支持在RequestMapping方法上直接添加。
* 支持在Controller的类及方法上添加，支持类似Spring @RequestMapping注解的“类+方法”拼接功能，如：
~~~java
public class XxUserController extends BaseCrudRestController<IamUser> {
    // 使用示例1
    @Log(operation = "修改个人信息") // businessObj可选, 默认自动识别为Controller的第1个泛型参数。此例操作日志将记录为: businessObj = "IamUser"，operation = "修改个人信息"
    @PostMapping("/updateUserInfo")
    public JsonResult updateUserInfo(){
    }
    
    // 使用示例2
    @Log(businessObj = "系统用户", operation = "修改头像") // 指定businessObj+operation
    @PostMapping("/updateAvatar")
    public JsonResult updateAvatar(){
    }
}
~~~

## 6、登录/注册/退出
* 登录：
~~~java
// PwdCredential credential = ...; // 登录页提交账号密码认证凭证
String authtoken = AuthServiceFactory.getAuthService(Cons.DICTCODE_AUTH_TYPE.PWD.name()).applyToken(credential);
return new JsonResult(authtoken);
~~~
* 退出：
~~~java 
IamSecurityUtils.logout();
~~~
* 注册账号
~~~java 
IamAccount account = new IamAccount();// 创建账号
... 
iamAccountService.createEntity(account);
~~~
* 获取当前用户对象:
~~~java
IamUser currentUser = IamSecurityUtils.getCurrentUser();
// 多种类型的用户
BaseLoginUser loginUser = IamSecurityUtils.getCurrentUser();
// 转型
~~~

## 6、样例参考 - [diboot-iam-example](https://github.com/dibo-software/diboot-example/diboot-iam-example)

> 使用过程中遇到问题，可加群交流。