--[[ **********************************************************************************************

 Mod Name: Max Stacks
by tehMugwump
 v5.4 Rewritten by tehMug to exclude all the prefabs
 Version: 0.5.1 - updated for Caves by tehMugwump -Traps..
 Release Date: March 28, 2013


 Created by: LoudAssCrow

 Features:
	Stack all Stackable Items to 99.
	Make non-stackable items stackable

 Known Issues:
	Items with Durability (Weapons, Tools, Armor, etc) cannot be stacked
	User-made (custom) Items are not supported
	Modded Non-stackable items when dropped will be treated like 1 item
		(example: dropping a stack of rabbits and killing them will only yield 1 morsel)

 Disclaimer:
	Many Items have not been tested, back-up your save files before using
	If you encounter a problem, or I missed an item, please notify me via the Klei Forums


*********************************************************************************************** ]]


-- Define functions

function stackPrefabPostInit(inst)

	inst.components.stackable.maxsize = 99

end

function makestackablePrefabPostInit(inst)

	inst:AddComponent("stackable")
		inst.components.stackable.maxsize = 99

end

TUNING.STACK_SIZE_LARGEITEM = 99
TUNING.STACK_SIZE_MEDITEM = 99
TUNING.STACK_SIZE_SMALLITEM = 99


AddPrefabPostInit("crow", makestackablePrefabPostInit)
AddPrefabPostInit("rabbit", makestackablePrefabPostInit)
AddPrefabPostInit("robin", makestackablePrefabPostInit)
AddPrefabPostInit("robin_winter", makestackablePrefabPostInit)

---------------
--[[
AddPrefabPostInit("trap", makestackablePrefabPostInit)  Enabling this may mess with Traps durability
AddPrefabPostInit("tallbirdegg", makestackablePrefabPostInit)
AddPrefabPostInit("tallbirdegg_cracked", makestackablePrefabPostInit)
AddPrefabPostInit("beemine", makestackablePrefabPostInit)
AddPrefabPostInit("beefalohat", makestackablePrefabPostInit)
AddPrefabPostInit("bushhat", makestackablePrefabPostInit)
AddPrefabPostInit("earmuffshat", makestackablePrefabPostInit)
AddPrefabPostInit("featherhat", makestackablePrefabPostInit)
AddPrefabPostInit("strawhat", makestackablePrefabPostInit)
AddPrefabPostInit("sweatervest", makestackablePrefabPostInit)
AddPrefabPostInit("trunkvest_summer", makestackablePrefabPostInit)
AddPrefabPostInit("trunkvest_winter", makestackablePrefabPostInit)
AddPrefabPostInit("tophat", makestackablePrefabPostInit)
AddPrefabPostInit("walrushat", makestackablePrefabPostInit)
AddPrefabPostInit("winterhat", makestackablePrefabPostInit)
AddPrefabPostInit("chester_eyebone", makestackablePrefabPostInit)
AddPrefabPostInit("heatrock", makestackablePrefabPostInit)
AddPrefabPostInit("razor", makestackablePrefabPostInit)
AddPrefabPostInit("teleportato_box", makestackablePrefabPostInit)
AddPrefabPostInit("teleportato_crank", makestackablePrefabPostInit)
AddPrefabPostInit("teleportato_potato", makestackablePrefabPostInit)
AddPrefabPostInit("teleportato_ring", makestackablePrefabPostInit)
AddPrefabPostInit("deerclops_eyeball", makestackablePrefabPostInit)
--]]
