/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons;

import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.utils.CommandDimDungeons;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class PlayerDungeonEvents {
    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        CommandDimDungeons.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.level.f_46443_) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (DungeonUtils.isDimensionDungeon(event.level)) {
            DungeonData.get(event.level).tick(event.level);
        }
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof Player && ((Player)event.getEntity()).m_5833_()) {
            return;
        }
        if (DungeonUtils.isDimensionPersonalBuild(event.getEntity().m_9236_())) {
            if (!DungeonUtils.isPersonalBuildChunk(event.getEntity().m_20183_())) {
                ChunkPos chunk = new ChunkPos(event.getEntity().m_20183_());
                int nx = (chunk.f_45578_ - 4) % 32;
                int nz = (chunk.f_45579_ - 4) % 32;
                if (nx < -1 || nx > 8 && nx < 31 || nz < -1 || nz > 8 && nz < 31) {
                    DungeonUtils.sendEntityHomeInBuildWorld((Entity)event.getEntity());
                    return;
                }
            }
            if (event.getEntity().m_20182_().f_82480_ < 1.0) {
                DungeonUtils.sendEntityHomeInBuildWorld((Entity)event.getEntity());
                return;
            }
        }
    }

    @SubscribeEvent
    public void explosionStart(ExplosionEvent.Start event) {
    }

    @SubscribeEvent
    public void explosionModify(ExplosionEvent.Detonate event) {
        if (!DungeonUtils.isDimensionDungeon(event.getLevel())) {
            return;
        }
        ArrayList crackedBricks = Lists.newArrayList();
        for (int i = 0; i < event.getAffectedBlocks().size(); ++i) {
            if (event.getLevel().m_8055_((BlockPos)event.getAffectedBlocks().get(i)).m_60734_().m_204297_().m_205785_().m_135782_().m_135815_().equals("cracked_stone_bricks")) {
                crackedBricks.add((BlockPos)event.getAffectedBlocks().get(i));
            }
            if (event.getLevel().m_8055_((BlockPos)event.getAffectedBlocks().get(i)).m_60734_().m_204297_().m_205785_().m_135782_().m_135815_().equals("trapped_chest")) {
                crackedBricks.add((BlockPos)event.getAffectedBlocks().get(i));
            }
            if (!event.getLevel().m_8055_((BlockPos)event.getAffectedBlocks().get(i)).m_60734_().m_204297_().m_205785_().m_135782_().m_135815_().equals("tnt")) continue;
            crackedBricks.add((BlockPos)event.getAffectedBlocks().get(i));
        }
        event.getExplosion().m_46080_();
        event.getAffectedBlocks().addAll(crackedBricks);
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((Level)event.getLevel())) {
            return;
        }
        BlockState targetBlock = event.getLevel().m_8055_(event.getPos());
        if (DungeonConfig.blockBreakWhitelist.contains(targetBlock.m_60734_())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockPlace(BlockEvent.EntityPlaceEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((Level)event.getLevel())) {
            return;
        }
        String whatBlock = event.getPlacedBlock().m_60734_().m_204297_().m_205785_().m_135782_().m_135815_();
        String whyBlock = event.getBlockSnapshot().getReplacedBlock().m_60734_().m_204297_().m_205785_().m_135782_().m_135815_();
        if ("water".equals(whatBlock) && "water".equals(whyBlock)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockMultiPlace(BlockEvent.EntityMultiPlaceEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild((Level)event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon((Level)event.getLevel())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void fillBucket(FillBucketEvent event) {
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getLevel())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void anythingDestroyBlock(LivingDestroyBlockEvent event) {
        if (DungeonUtils.isDimensionPersonalBuild(event.getEntity().m_9236_()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getEntity().m_9236_())) {
            return;
        }
        BlockState targetBlock = event.getEntity().m_9236_().m_8055_(event.getPos());
        if (DungeonConfig.blockBreakWhitelist.contains(targetBlock.m_60734_())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (DungeonUtils.isDimensionPersonalBuild(event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getEntity().m_9236_())) {
            return;
        }
        BlockState targetBlock = event.getEntity().m_9236_().m_8055_(event.getPos());
        if (DungeonConfig.blockBreakWhitelist.contains(targetBlock.m_60734_())) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState targetBlock = event.getLevel().m_8055_(event.getPos());
        if (DungeonUtils.isDimensionPersonalBuild(event.getLevel()) && !DungeonUtils.isPersonalBuildChunk(event.getPos())) {
            if (event.getSide() == LogicalSide.CLIENT || event.getHand() != InteractionHand.MAIN_HAND) {
                return;
            }
            if (targetBlock.m_60734_() == BlockRegistrar.BLOCK_GOLD_PORTAL.get()) {
                ItemStack itemInHand = event.getItemStack();
                if (itemInHand == null || itemInHand.m_41619_()) {
                    DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.help_1");
                } else {
                    Player player = event.getEntity();
                    if (itemInHand.m_41720_() == Items.f_42516_) {
                        if (itemInHand.m_41788_()) {
                            String playerName = itemInHand.m_41611_().getString();
                            playerName = playerName.replace("[", "");
                            playerName = playerName.replace("]", "");
                            playerName = playerName.replace(" ", "");
                            if (PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).getBlacklistMode(player)) {
                                boolean wasAdded = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).toggleNameOnGuestList(player, playerName);
                                if (wasAdded) {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_added_blacklist", playerName);
                                } else {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_removed_blacklist", playerName);
                                }
                            } else {
                                boolean wasAdded = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).toggleNameOnGuestList(player, playerName);
                                if (wasAdded) {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_added_whitelist", playerName);
                                } else {
                                    DungeonUtils.notifyGuestListChange(event.getEntity(), "security.dimdungeons.player_removed_whitelist", playerName);
                                }
                            }
                        } else {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_paper");
                        }
                    }
                    if (itemInHand.m_41720_() == Items.f_42517_) {
                        ArrayList<String> guests = PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).getGuestListForPlayer(player);
                        DungeonUtils.displayGuestList(player, guests);
                        if (PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).getBlacklistMode(player)) {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_blacklist");
                        } else {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_whitelist");
                        }
                    }
                    if (itemInHand.m_41720_() == Items.f_42773_) {
                        DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_grindstone");
                        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).clearGuestListForPlayer(player);
                        if (PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).getBlacklistMode(player)) {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_blacklist");
                        } else {
                            DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.status_whitelist");
                        }
                    }
                    if (itemInHand.m_41720_() == Items.f_42535_) {
                        DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_white");
                        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).changeBlacklistMode(player, false);
                    }
                    if (itemInHand.m_41720_() == Items.f_42498_) {
                        DungeonUtils.giveSecuritySystemPrompt(event.getEntity(), "security.dimdungeons.use_black");
                        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(event.getLevel().m_7654_())).changeBlacklistMode(player, true);
                    }
                }
            }
            event.setCanceled(true);
            return;
        }
        if (!DungeonConfig.globalBlockProtection) {
            return;
        }
        if (!DungeonUtils.isDimensionDungeon(event.getLevel())) {
            return;
        }
        if (DungeonConfig.blockInteractBlacklist.contains(targetBlock.m_60734_())) {
            event.setCanceled(true);
            return;
        }
        ItemStack itemInHand = event.getItemStack();
        if (itemInHand != null && !itemInHand.m_41619_()) {
            if (itemInHand.m_41720_() instanceof BlockItem) {
                event.setCanceled(true);
            }
            return;
        }
    }

    @SubscribeEvent
    public void teleportStart(EntityTeleportEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer) || DungeonUtils.isDimensionDungeon(event.getEntity().m_20193_())) {
            // empty if block
        }
        if ((event.getEntity() instanceof EnderMan || event.getEntity() instanceof Shulker) && DungeonUtils.isDimensionDungeon(event.getEntity().m_20193_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChorusTeleport(EntityTeleportEvent.ChorusFruit event) {
        if (DungeonUtils.isDimensionDungeon(event.getEntity().m_20193_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent.Start event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
    }
}

