/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import com.catastrophe573.dimdungeons.DimDungeons;
import com.catastrophe573.dimdungeons.DungeonConfig;
import com.catastrophe573.dimdungeons.block.BlockPortalKeyhole;
import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityGoldPortal;
import com.catastrophe573.dimdungeons.block.TileEntityLocalTeleporter;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonDesigner;
import com.catastrophe573.dimdungeons.structure.DungeonDesignerTeleporterHub;
import com.catastrophe573.dimdungeons.structure.DungeonDesignerThemeOpen;
import com.catastrophe573.dimdungeons.structure.DungeonPlacementDebug;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonGenData;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class DungeonPlacement {
    public static int SIGN_Y = 49;

    public static boolean beginDesignAndBuild(ServerLevel world, long x, long z, DungeonGenData genData) {
        DungeonDesigner dbl;
        long entranceChunkZ;
        long entranceChunkX = DungeonPlacement.getEntranceX(x);
        if (!DungeonPlacement.isEntranceChunk(entranceChunkX, entranceChunkZ = DungeonPlacement.getEntranceZ(z))) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: incorrect entrance chunk chosen: " + x + ", " + z);
            return false;
        }
        DimDungeons.logMessageInfo("DIMDUNGEONS START STRUCTURE at chunk: " + x + ", " + z);
        int dungeonSize = 25;
        DungeonDesigner.DungeonType dungeonType = DungeonDesigner.DungeonType.BASIC;
        boolean useLarge = false;
        if (DungeonConfig.enableDebugCheats && DungeonUtils.doesKeyMatchDebugCheat(genData) > 0) {
            return DungeonPlacementDebug.place(world, x, z, DungeonUtils.doesKeyMatchDebugCheat(genData), genData);
        }
        if (genData.dungeonTheme == 2) {
            dungeonType = DungeonDesigner.DungeonType.THEME_OPEN;
            dbl = new DungeonDesignerThemeOpen(world.m_213780_(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
            dungeonSize = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeDungeonSize;
        } else if (genData.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
            dungeonType = DungeonDesigner.DungeonType.ADVANCED;
            dbl = new DungeonDesigner(world.m_213780_(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
            dungeonSize = 46;
            useLarge = true;
        } else if (genData.dungeonType == DungeonDesigner.DungeonType.TELEPORTER_HUB) {
            dungeonType = DungeonDesigner.DungeonType.TELEPORTER_HUB;
            dbl = new DungeonDesignerTeleporterHub(world.m_213780_(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
        } else {
            dungeonType = DungeonDesigner.DungeonType.BASIC;
            dbl = new DungeonDesigner(world.m_213780_(), entranceChunkX, entranceChunkZ, dungeonType, genData.dungeonTheme);
            if (genData.dungeonTheme > 0) {
                dungeonSize = DungeonConfig.themeSettings.get((int)(genData.dungeonTheme - 1)).themeDungeonSize;
            }
        }
        dbl.calculateDungeonShape(dungeonSize, useLarge);
        DungeonData.get((Level)world).registerNewRooms(dbl, x, z);
        return true;
    }

    public static boolean buildRoomAtChunk(ServerLevel world, ChunkPos cpos) {
        BlockPos bpos = new BlockPos(cpos.m_45604_(), SIGN_Y, cpos.m_45605_());
        DungeonRoom nextRoom = DungeonData.get((Level)world).getRoomAtPos(cpos);
        if (nextRoom == null || DungeonPlacement.wasRoomBuiltAtChunk((Level)world, cpos)) {
            return false;
        }
        world.m_46597_(bpos.m_7495_().m_7495_(), Blocks.f_50752_.m_49966_());
        if (nextRoom.roomType == DungeonDesigner.RoomType.LARGE) {
            if (!DungeonPlacement.putLargeRoomHere(cpos, world, nextRoom)) {
                DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE ***LARGE*** STRUCTURE: " + nextRoom.structure);
                return false;
            }
            if (nextRoom.dungeonType != DungeonDesigner.DungeonType.TELEPORTER_HUB) {
                DungeonPlacement.closeDoorsOnLargeRoom(cpos, world, nextRoom);
                DungeonPlacement.closeDoorsOnLargeRoom(new ChunkPos(cpos.f_45578_ + 1, cpos.f_45579_), world, nextRoom);
                DungeonPlacement.closeDoorsOnLargeRoom(new ChunkPos(cpos.f_45578_, cpos.f_45579_ + 1), world, nextRoom);
                DungeonPlacement.closeDoorsOnLargeRoom(new ChunkPos(cpos.f_45578_ + 1, cpos.f_45579_ + 1), world, nextRoom);
            }
        } else if (nextRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY && !DungeonPlacement.putRoomHere(cpos, world, nextRoom)) {
            DimDungeons.logMessageError("DIMDUNGEONS ERROR UNABLE TO PLACE STRUCTURE: " + nextRoom.structure);
        }
        return true;
    }

    public static boolean wasRoomBuiltAtChunk(Level world, ChunkPos cpos) {
        BlockPos bpos;
        ServerLevel dungeonDim = DungeonUtils.getDungeonWorld(world.m_7654_());
        return dungeonDim.m_8055_(bpos = new BlockPos(cpos.m_45604_(), SIGN_Y - 2, cpos.m_45605_())).m_60734_() == Blocks.f_50752_;
    }

    public static boolean isDungeonChunk(long x, long z) {
        if (x < 0L) {
            return false;
        }
        if (z >= 0L) {
            long plotX = x % 16L;
            long plotZ = z % 16L;
            return plotX > 3L && plotX < 12L && plotZ > 3L && plotZ < 12L;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX > 3L && plotX < 12L && plotZ < -4L && plotZ > -13L;
    }

    public static boolean isEntranceChunk(long x, long z) {
        if (x < 0L) {
            return false;
        }
        if (z >= 0L) {
            long plotX = x % 16L;
            long plotZ = z % 16L;
            return plotX == 8L && plotZ == 11L;
        }
        long plotX = x % 16L;
        long plotZ = z % 16L;
        return plotX == 8L && plotZ == -5L;
    }

    public static long getEntranceX(long chunkX) {
        return chunkX / 16L + 8L;
    }

    public static long getEntranceZ(long chunkZ) {
        if (chunkZ >= 0L) {
            return chunkZ / 16L + 11L;
        }
        return chunkZ / 16L + 11L;
    }

    public static boolean putLargeRoomHere(ChunkPos cpos, ServerLevel world, DungeonRoom room) {
        MinecraftServer minecraftserver = world.m_7654_();
        StructureTemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).m_215082_();
        StructureTemplate template = templatemanager.m_230359_(new ResourceLocation(room.structure));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(false);
        placementsettings.m_74379_(Rotation.NONE);
        placementsettings.m_74381_(new BoundingBox(cpos.f_45578_ * 16, 0, cpos.f_45579_ * 16, cpos.f_45578_ * 16 + 32 - 1, 255, cpos.f_45579_ * 16 + 32 - 1));
        BlockPos position = new BlockPos(cpos.m_45604_(), 50, cpos.m_45605_());
        BlockPos sizeRange = new BlockPos(32, 13, 32);
        if (template == null) {
            DimDungeons.logMessageError("DIMDUNGEONS FATAL ERROR: LARGE structure does not exist (" + room.structure + ")");
            return false;
        }
        DimDungeons.logMessageInfo("Placing a large room: " + room.structure);
        boolean success = template.m_230328_((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.m_213780_(), 2);
        for (StructureTemplate.StructureBlockInfo template$blockinfo : template.m_74603_(position, placementsettings, Blocks.f_50677_)) {
            StructureMode structuremode;
            if (template$blockinfo.f_74677_() == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.f_74677_().m_128461_("mode"))) != StructureMode.DATA) continue;
            DungeonPlacement.handleDataBlock(template$blockinfo.f_74677_().m_128461_("metadata"), template$blockinfo.f_74675_(), world, world.m_213780_(), placementsettings.m_74409_(), room);
        }
        return success;
    }

    public static void closeDoorsOnLargeRoom(ChunkPos cpos, ServerLevel world, DungeonRoom room) {
        BlockState fillBlock = Blocks.f_50222_.m_49966_();
        BlockState airBlock = Blocks.f_50016_.m_49966_();
        BlockState redBlock = Blocks.f_50504_.m_49966_();
        BlockPos startPos = new BlockPos(cpos.m_45604_(), 55, cpos.m_45605_());
        int x = cpos.f_45578_;
        int z = cpos.f_45579_;
        ChunkPos west = new ChunkPos(x - 1, z);
        ChunkPos east = new ChunkPos(x + 1, z);
        ChunkPos north = new ChunkPos(x, z - 1);
        ChunkPos south = new ChunkPos(x, z + 1);
        DungeonRoom westRoom = DungeonData.get((Level)world).getRoomAtPos(west);
        DungeonRoom eastRoom = DungeonData.get((Level)world).getRoomAtPos(east);
        DungeonRoom northRoom = DungeonData.get((Level)world).getRoomAtPos(north);
        DungeonRoom southRoom = DungeonData.get((Level)world).getRoomAtPos(south);
        if (westRoom == null) {
            world.m_7731_(startPos.m_122020_(7).m_122030_(0).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(1).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(0).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(1).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(0).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(1).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(0).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(1).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(0).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(1).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(0).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(1).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(0).m_6630_(7), airBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(0).m_6630_(7), airBlock, 2);
        } else if (westRoom.roomType != DungeonDesigner.RoomType.LARGE && westRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.m_7731_(startPos.m_122020_(7).m_122030_(1).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(1).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(2).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(2).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(3).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(3).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(4).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(4).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(5).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(5).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(6).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(6).m_6630_(7), redBlock, 2);
        }
        if (eastRoom == null) {
            world.m_7731_(startPos.m_122020_(7).m_122030_(14).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(15).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(14).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(15).m_6630_(0), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(14).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(15).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(14).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(15).m_6630_(1), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(14).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(15).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(14).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(15).m_6630_(2), fillBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(15).m_6630_(7), airBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(15).m_6630_(7), airBlock, 2);
        } else if (eastRoom.roomType != DungeonDesigner.RoomType.LARGE && eastRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.m_7731_(startPos.m_122020_(7).m_122030_(14).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(14).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(13).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(13).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(12).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(12).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(11).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(11).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(10).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(10).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(7).m_122030_(9).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(8).m_122030_(9).m_6630_(7), redBlock, 2);
        }
        if (northRoom != null && northRoom.roomType != DungeonDesigner.RoomType.LARGE && northRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.m_7731_(startPos.m_122020_(1).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(1).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(2).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(2).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(3).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(3).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(4).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(4).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(5).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(5).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(6).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(6).m_122030_(8).m_6630_(7), redBlock, 2);
        }
        if (southRoom != null && southRoom.roomType != DungeonDesigner.RoomType.LARGE && southRoom.roomType != DungeonDesigner.RoomType.LARGE_DUMMY) {
            world.m_7731_(startPos.m_122020_(14).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(14).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(13).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(13).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(12).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(12).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(11).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(11).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(10).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(10).m_122030_(8).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(9).m_122030_(7).m_6630_(7), redBlock, 2);
            world.m_7731_(startPos.m_122020_(9).m_122030_(8).m_6630_(7), redBlock, 2);
        }
    }

    public static boolean putRoomHere(ChunkPos cpos, ServerLevel world, DungeonRoom room) {
        MinecraftServer minecraftserver = world.m_7654_();
        StructureTemplateManager templatemanager = DungeonUtils.getDungeonWorld(minecraftserver).m_215082_();
        StructureTemplate template = templatemanager.m_230359_(new ResourceLocation(room.structure));
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74379_(Rotation.NONE).m_74392_(false);
        placementsettings.m_74381_(placementsettings.m_74409_());
        placementsettings.m_74379_(room.rotation);
        BlockPos position = new BlockPos(cpos.m_45604_(), 50, cpos.m_45605_());
        BlockPos sizeRange = new BlockPos(16, 13, 16);
        if (template == null) {
            DimDungeons.logMessageInfo("DIMDUNGEONS FATAL ERROR: Structure does not exist (" + room.structure + ")");
            return false;
        }
        if (room.rotation == Rotation.COUNTERCLOCKWISE_90) {
            placementsettings.m_74379_(Rotation.COUNTERCLOCKWISE_90);
            position = position.m_7918_(0, 0, template.m_163801_().m_123343_() - 1);
        } else if (room.rotation == Rotation.CLOCKWISE_90) {
            placementsettings.m_74379_(Rotation.CLOCKWISE_90);
            position = position.m_7918_(template.m_163801_().m_123341_() - 1, 0, 0);
        } else if (room.rotation == Rotation.CLOCKWISE_180) {
            placementsettings.m_74379_(Rotation.CLOCKWISE_180);
            position = position.m_7918_(template.m_163801_().m_123341_() - 1, 0, template.m_163801_().m_123343_() - 1);
        } else {
            placementsettings.m_74379_(Rotation.NONE);
        }
        boolean success = template.m_230328_((ServerLevelAccessor)world, position, sizeRange, placementsettings, world.m_213780_(), 2);
        for (StructureTemplate.StructureBlockInfo template$blockinfo : template.m_74603_(position, placementsettings, Blocks.f_50677_)) {
            StructureMode structuremode;
            if (template$blockinfo.f_74677_() == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.f_74677_().m_128461_("mode"))) != StructureMode.DATA) continue;
            DungeonPlacement.handleDataBlock(template$blockinfo.f_74677_().m_128461_("metadata"), template$blockinfo.f_74675_(), world, world.m_213780_(), placementsettings.m_74409_(), room);
        }
        if (room.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
            for (StructureTemplate.StructureBlockInfo info : template.m_74603_(position, placementsettings, Blocks.f_50350_)) {
                world.m_7731_(info.f_74675_(), Blocks.f_50349_.m_49966_(), 3);
            }
        }
        return success;
    }

    public void printMap(DungeonDesigner dbl) {
        for (int j = 0; j < 8; ++j) {
            Object dungeonRowShape = "";
            for (int i = 0; i < 8; ++i) {
                dungeonRowShape = (String)dungeonRowShape + (dbl.finalLayout[i][j].hasRoom() ? "*" : ".");
            }
            System.out.println((String)dungeonRowShape);
        }
    }

    protected static void handleDataBlock(String name, BlockPos pos, ServerLevel world, RandomSource rand, BoundingBox bb, DungeonRoom room) {
        if ("ReturnPortal".equals(name)) {
            world.m_7731_(pos, ((Block)BlockRegistrar.BLOCK_GOLD_PORTAL.get()).m_49966_(), 2);
            TileEntityGoldPortal te = (TileEntityGoldPortal)world.m_7702_(pos);
            if (te != null) {
                te.setDestination(0.0, -10000.0, 0.0, "minecraft:overworld", Direction.NORTH);
            }
        } else if ("BackToEntrance".equals(name)) {
            world.m_7731_(pos, ((Block)BlockRegistrar.BLOCK_LOCAL_TELEPORTER.get()).m_49966_(), 2);
            TileEntityLocalTeleporter te = (TileEntityLocalTeleporter)world.m_7702_(pos);
            if (te != null) {
                double topLeftX = Math.floor(pos.m_123341_() / 256);
                double entranceX = topLeftX * 256.0 + 136.0;
                double topLeftZ = Math.floor(pos.m_123343_() / 256);
                double entranceZ = topLeftZ * 256.0 + 188.5;
                te.setDestination(entranceX, 55.1, entranceZ, 0.0, 180.0);
            }
        } else if ("LockItStoneBrick".equals(name)) {
            world.m_7731_(pos, Blocks.f_50222_.m_49966_(), 2);
        } else if (!"LockIt".equals(name)) {
            if ("FortuneTeller".equals(name)) {
                world.m_7731_(pos, Blocks.f_50222_.m_49966_(), 2);
                BlockEntity te = world.m_7702_(pos.m_7495_());
                if (te instanceof DispenserBlockEntity) {
                    ((DispenserBlockEntity)te).m_6211_();
                    ItemStack message = DungeonPlacement.generateLuckyMessage(rand, room.dungeonType);
                    ((DispenserBlockEntity)te).m_59237_(message);
                }
            } else if ("ChestLoot1".equals(name) || "SetTrappedLoot".equals(name) || "BarrelLoot1".equals(name)) {
                String lootType = room.dungeonType == DungeonDesigner.DungeonType.BASIC ? "basic" : "advanced";
                String lootTable = "chests/chestloot_" + lootType + "_easy";
                DungeonPlacement.fillChestBelow(pos, new ResourceLocation("dimdungeons:" + lootTable), (LevelAccessor)world, rand);
            } else if ("ChestLoot2".equals(name)) {
                String lootType = room.dungeonType == DungeonDesigner.DungeonType.BASIC ? "basic" : "advanced";
                String lootTable = "chests/chestloot_" + lootType + "_hard";
                DungeonPlacement.fillChestBelow(pos, new ResourceLocation("dimdungeons:" + lootTable), (LevelAccessor)world, rand);
            } else if ("ChestLootKit".equals(name)) {
                String lootTable = "chests/kit_random";
                DungeonPlacement.fillChestBelow(pos, new ResourceLocation("dimdungeons:" + lootTable), (LevelAccessor)world, rand);
            } else if ("ChestLootLucky".equals(name)) {
                int lucky = rand.m_188503_(100);
                if (lucky < 30) {
                    if (room.dungeonType == DungeonDesigner.DungeonType.BASIC) {
                        DungeonPlacement.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_lucky"), (LevelAccessor)world, rand);
                    } else {
                        DungeonPlacement.fillChestBelow(pos, new ResourceLocation("dimdungeons:chests/chestloot_crazy"), (LevelAccessor)world, rand);
                    }
                } else {
                    if (DungeonConfig.isModInstalled("artifacts") && lucky < 40) {
                        DungeonPlacement.spawnEnemyHere(pos, "artifacts:mimic", world, room.theme, room.dungeonType);
                    }
                    world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                    world.m_7731_(pos.m_7495_(), Blocks.f_50016_.m_49966_(), 2);
                }
            } else if ("PlaceL2Key".equals(name)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.m_7702_(pos.m_7495_());
                if (te != null) {
                    te.removeContents();
                    te.setContents(new ItemStack((ItemLike)ItemRegistrar.ITEM_BLANK_ADVANCED_KEY.get()));
                }
            } else if (name.contains("TeleporterKey_")) {
                String tempDoornum = name.replace("TeleporterKey_", "");
                int doornum = Integer.valueOf(tempDoornum);
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                TileEntityPortalKeyhole te = (TileEntityPortalKeyhole)world.m_7702_(pos.m_6625_(2));
                if (te != null) {
                    ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
                    int topLeftX = bb.m_162395_() - 48;
                    int destX = topLeftX / 256;
                    int topLeftZ = bb.m_162398_() - 48;
                    int destZ = topLeftZ / 256;
                    ItemPortalKey.activateKeyForExistingTeleporterHub(world.m_7654_(), newkey, destX, destZ, doornum);
                    te.removeContents();
                    te.setContents(newkey);
                    BlockState state = world.m_8055_(pos.m_6625_(2));
                    BlockState newBlockState = (BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockPortalKeyhole.FACING, (Comparable)((Direction)state.m_61143_((Property)BlockPortalKeyhole.FACING)))).m_61124_((Property)BlockPortalKeyhole.FILLED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockPortalKeyhole.LIT, (Comparable)Boolean.valueOf(false));
                    world.m_46597_(pos.m_6625_(2), newBlockState);
                }
            } else if ("SummonWitch".equals(name)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                DungeonPlacement.spawnEnemyHere(pos, "minecraft:witch", world, room.theme, room.dungeonType);
            } else if ("SummonWaterEnemy".equals(name)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                DungeonPlacement.spawnEnemyHere(pos, "minecraft:guardian", world, room.theme, room.dungeonType);
            } else if ("SummonEnderman".equals(name)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                DungeonPlacement.spawnEnemyHere(pos, "minecraft:enderman", world, room.theme, room.dungeonType);
            } else if ("SummonEnemy1".equals(name)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                int poolSize = DungeonConfig.basicEnemySet1.size();
                String mobid = DungeonConfig.basicEnemySet1.get(rand.m_188503_(poolSize));
                if (room.theme > 0) {
                    poolSize = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet1.size();
                    mobid = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet1.get(rand.m_188503_(poolSize));
                }
                if (room.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
                    poolSize = DungeonConfig.advancedEnemySet1.size();
                    mobid = DungeonConfig.advancedEnemySet1.get(rand.m_188503_(poolSize));
                }
                DungeonPlacement.spawnEnemyHere(pos, mobid, world, room.theme, room.dungeonType);
            } else if ("SummonEnemy2".equals(name)) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
                int poolSize = DungeonConfig.basicEnemySet2.size();
                String mobid = DungeonConfig.basicEnemySet2.get(rand.m_188503_(poolSize));
                if (room.theme > 0) {
                    poolSize = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet2.size();
                    mobid = DungeonConfig.themeSettings.get((int)(room.theme - 1)).themeEnemySet2.get(rand.m_188503_(poolSize));
                }
                if (room.dungeonType == DungeonDesigner.DungeonType.ADVANCED) {
                    poolSize = DungeonConfig.advancedEnemySet2.size();
                    mobid = DungeonConfig.advancedEnemySet2.get(rand.m_188503_(poolSize));
                }
                Entity mob = DungeonPlacement.spawnEnemyHere(pos, mobid, world, room.theme, room.dungeonType);
                AttributeInstance tempHealth = ((Mob)mob).m_21051_(Attributes.f_22276_);
                ((Mob)mob).m_21051_(Attributes.f_22276_).m_22100_(tempHealth.m_22115_() * 1.5);
                ((Mob)mob).m_21153_((float)((Mob)mob).m_21051_(Attributes.f_22276_).m_22115_());
                ((Mob)mob).m_7292_(new MobEffectInstance(MobEffects.f_19607_, 9999999, 1, false, false));
                ((Mob)mob).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 9999999, 1, false, false));
            } else {
                DimDungeons.logMessageWarn("UNHANDLED DATA BLOCK WITH name = " + name);
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }

    private static Entity spawnEnemyHere(BlockPos pos, String resourceLocation, ServerLevel world, int theme, DungeonDesigner.DungeonType type) {
        EntityType entitytype = EntityType.m_20632_((String)resourceLocation).orElse(EntityType.f_20555_);
        Entity mob = entitytype.m_262455_(world, new CompoundTag(), null, pos, MobSpawnType.STRUCTURE, true, true);
        if (mob == null) {
            return null;
        }
        mob.m_20035_(pos, 0.0f, 0.0f);
        String advancedDungeonNames = type == DungeonDesigner.DungeonType.ADVANCED ? "2" : "";
        MutableComponent fancyName = Component.m_237115_((String)("enemy.dimdungeons." + resourceLocation + advancedDungeonNames));
        if (fancyName != null && !fancyName.getString().contains("enemy.dimdungeons.")) {
            mob.m_6593_((Component)fancyName);
        }
        if (mob instanceof Mob) {
            ((Mob)mob).m_21553_(false);
            ((Mob)mob).m_21446_(pos, 8);
            ((Mob)mob).m_21530_();
            double healthScaling = DungeonConfig.basicEnemyHealthScaling;
            if (theme > 0) {
                healthScaling = DungeonConfig.themeSettings.get((int)(theme - 1)).themeEnemyHealthScaling;
            }
            if (type == DungeonDesigner.DungeonType.ADVANCED) {
                healthScaling = DungeonConfig.advancedEnemyHealthScaling;
            }
            AttributeInstance tempHealth = ((Mob)mob).m_21051_(Attributes.f_22276_);
            ((Mob)mob).m_21051_(Attributes.f_22276_).m_22100_(tempHealth.m_22115_() * healthScaling);
            ((Mob)mob).m_21153_((float)((Mob)mob).m_21051_(Attributes.f_22276_).m_22115_());
            int chanceForTheme = DungeonConfig.chanceForThemeKeys;
            if (type == DungeonDesigner.DungeonType.ADVANCED) {
                chanceForTheme /= 2;
            }
            if (world.m_213780_().m_188503_(100) < chanceForTheme && DungeonConfig.themeSettings.size() > 0 && theme < 1 && !((Mob)mob).m_21033_(EquipmentSlot.OFFHAND)) {
                int numThemes = DungeonConfig.themeSettings.size();
                ItemStack stack = new ItemStack((ItemLike)ItemRegistrar.ITEM_PORTAL_KEY.get());
                ((ItemPortalKey)((Object)ItemRegistrar.ITEM_PORTAL_KEY.get())).activateKeyLevel1(world.m_7654_(), stack, world.m_213780_().m_188503_(numThemes) + 1);
                ((Mob)mob).m_21008_(InteractionHand.OFF_HAND, stack);
                ((Mob)mob).m_21409_(EquipmentSlot.OFFHAND, 1.0f);
            }
            if (type == DungeonDesigner.DungeonType.ADVANCED) {
                ((Mob)mob).m_21051_(Attributes.f_22279_).m_22100_((double)0.35f);
                ((Mob)mob).m_7292_(new MobEffectInstance(MobEffects.f_19607_, 9999999, 1, false, false));
                ((Mob)mob).m_7292_(new MobEffectInstance(MobEffects.f_19603_, 9999999, 3, false, false));
                ((Mob)mob).m_7292_(new MobEffectInstance(MobEffects.f_19608_, 9999999, 1, false, false));
            }
        }
        return mob;
    }

    private static void fillChestBelow(BlockPos pos, ResourceLocation lootTable, LevelAccessor world, RandomSource rand) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
        RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)lootTable);
    }

    private static ItemStack generateLuckyMessage(RandomSource rand, DungeonDesigner.DungeonType type) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42615_);
        stack.m_41751_(new CompoundTag());
        int bookType = rand.m_188503_(3);
        if (type == DungeonDesigner.DungeonType.ADVANCED) {
            bookType = 3;
        }
        int messageVariation = rand.m_188503_(8) + 1;
        String title = "";
        String body = "";
        if (bookType == 0) {
            title = Component.m_237115_((String)"book.dimdungeons.title_1").getString();
            body = Component.m_237115_((String)("book.dimdungeons.fun_message_" + messageVariation)).getString();
        } else if (bookType == 1) {
            title = Component.m_237115_((String)"book.dimdungeons.title_2").getString();
            body = Component.m_237115_((String)("book.dimdungeons.helpful_message_" + messageVariation)).getString();
        } else if (bookType == 2) {
            title = Component.m_237115_((String)"book.dimdungeons.title_3").getString();
            body = Component.m_237115_((String)("book.dimdungeons.dangerous_message_" + messageVariation)).getString();
        } else if (bookType == 3) {
            title = Component.m_237115_((String)"book.dimdungeons.title_4").getString();
            body = Component.m_237115_((String)("book.dimdungeons.advanced_message_" + messageVariation)).getString();
        }
        ListTag pages = new ListTag();
        MutableComponent text = Component.m_237115_((String)body);
        String json = Component.Serializer.m_130703_((Component)text);
        pages.add(0, (Tag)StringTag.m_129297_((String)json));
        stack.m_41783_().m_128379_("resolved", false);
        stack.m_41783_().m_128405_("generation", 0);
        stack.m_41783_().m_128365_("pages", (Tag)pages);
        stack.m_41783_().m_128359_("title", title);
        stack.m_41783_().m_128359_("author", Component.m_237115_((String)"book.dimdungeons.author").getString());
        return stack;
    }
}

