"use strict";

var Updater = require('./index').Updater;
var expect = require('expect.js');
var http = require('http');


var TEST_HTTP_PORT = '8181';

describe('Test web content update', function(){

    var _MANIFEST = {};
    
    before(function(){
        return new Promise(function(resolve, reject){
            var server = http.createServer();
            server.on('request', function(request, response){
                var content = JSON.stringify(_MANIFEST) + "\n";
                response.statusCode = 200;
                response.setHeader('Content-Type', 'application/json');
                response.write(content);
                response.end();
            })

            server.listen(TEST_HTTP_PORT, function(err){
                if(err){
                    reject(err);
                }else{
                    resolve();
                }
            })
        })
    })

    it('should update web content if nw is satisfied', function(done){
        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        this.timeout(10000);
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        u.on('web_content_update_success', function(){
            expect(1).to.be(1);
            done();
        })
    })
    
    it('should trigger error info event if cannot query manifest', function(done){
        this.timeout(10000);
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ (TEST_HTTP_PORT - 1) + '/'
        })

        u.on('error_info', function(){
            expect(1).to.be(1);
            done();
        })
    })

    it('should trigger nw_is_not_supported event', function(done){

        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "1.11.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        this.timeout(10000);
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        u.on('nw_is_not_supported', function(){
            expect(1).to.be(1);
            done();
        })
    })
    
    it('should trigger nw_is_not_satisfied event correct', function(done){
        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.11.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        this.timeout(10000);
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.9.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        u.on('nw_is_not_satisfied', function(){
            expect(1).to.be(1);
            done();
        })
        
    })
    
    it('should return no update when update success', function(done){
        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        this.timeout(10000);
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        u.on('web_content_update_success', function(){
            u.detectUpdate().then(function(result){
                expect(result.eventName).to.be('no_update');
                done();
            })
        })
    })


    it('should return no update after set web content ignore version manually', function(){
        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        this.timeout(10000);
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        u.addIgnoreVersion('web_content', '2.17.0');
        return u.detectUpdate().then(function(result){
            expect(result.eventName).to.be('no_update');
        })
    })

    it('should return no update after set nw ignore version manually', function(){
        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.11.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.11.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.11.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.11.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.11.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        this.timeout(10000);
        u.addIgnoreVersion('nw', '1.11.0');
        return u.detectUpdate().then(function(result){
            expect(result.eventName).to.be('no_update');
        })
    })
    
    it('should return web content update fail ( web content url is wrong)  after set web content ignore version manually but force compare', function(){
        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.10.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.10.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        this.timeout(10000);
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        u.addIgnoreVersion('web_content', '2.17.0');
        return u.detectUpdate(true).then(function(result){
            expect(result.eventName).to.be('web_content_need_update');
        })
    })

    it('should return nw_not_satisfied after set nw ignore version manually but force detect', function(){
        _MANIFEST = {
            "mac": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.11.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.11.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/DingTalk_v1.10.0.dmg",
                    "md5": "8e60ff031afa59ea52ddcd551f282bfd",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                }
            },
            "win": {
                "web_content": {
                    "version": "2.17.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/web_content/DingTalk_WebContent_v2.17.0.zip",
                    "md5": "0fbddd82c0e315f306a68506bcc501bb",
                    "require_nw": ">=1.11.0",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "min_version": "0.9.90",
                "install": {
                    "version": "1.11.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/install/Dingtalk_Release_v1.10.0.exe",
                    "md5": "18a1f6c61120a3774dc37f2f5c595511",
                    "description": ["全新钉盘界面改版","下载文件支持取消","管理员可以快速登录管理后台","优化内存，提升性能"]
                },
                "package": {
                    "version": "1.11.0",
                    "url": "http://download.taobaocdn.com/dingtalk-desktop/Release/win_update_packages/Dingtalk_Release_v1.10.0_update.zip",
                    "md5": "f91709fa86b41b18816df7ac88f1c6e2",
                    "need-update": "<1.0.0",
                    "need-reinstall": "<1.10.0",
                    "need-update-v2": "<1.10.0"
                }
            }
        }
        var u = new Updater({
            "web_content":{
                "version": "2.16.0",
            },
            "nw_version":"1.10.0",
            "remoteManifest":"http://localhost:"+ TEST_HTTP_PORT + '/'
        })

        this.timeout(10000);
        u.addIgnoreVersion('nw', '1.11.0');
        return u.detectUpdate(true).then(function(result){
            expect(result.eventName).to.be('nw_is_not_satisfied');
        })
    })

})

// var u = updater.init({
//     "web_content":{
//         "version": "2.7.1-RC.0",
//     },
//     "nw_version":"1.0.0-RC.0",
//     "remoteManifest":"http://s.dingtalk.com/market/dingtalk/destktop_dev_manifest.php"
// })
//
// u.on('web_content_update_success', function(){
//     console.log('web content update success')
//     console.log(arguments);
// })
// u.on('nw_is_not_supported', function(conf){
//     console.log('nw is not supported')
//     console.log(conf);
// })
//
// u.on('nw_is_not_satisfied', function(conf){
//     console.log('nw is not satisfied')
//     console.log(conf);
// })