//
//  Created by dingsu on 1/22/16.
//  Copyright © 2016 dingyuan. All rights reserved.
//
var sqlite3 = require('./sqlite3');

/**
 * @brief ClipBoardProvider offer Native Crypto ability
 */
function ClipBoardProvider() {
	this.clipboard_provider = new sqlite3.DingTalkClipBoardProvider();
}

// 参数：type指剪贴板的数据类型,requestBase64指是否把获得的数据转换成base64再返回(用于二进制数据传输,unicode文本也必须转化成base64再处理)
// 返回值：返回从剪贴板中获得的数据，获取失败返回空字符串
ClipBoardProvider.prototype.getCustomData = function(type, requestBase64) {
  return this.clipboard_provider.get(type);
}

// 参数：返回剪贴板中的文件列表（目前仅Windows系统有效）
// 返回值：返回一个js array，包含文件名列表
ClipBoardProvider.prototype.getFileNames = function() {
  return this.clipboard_provider.getFileNames();
}

// 参数：content指需要写到剪贴板中的数据内容，type指剪贴板的数据类型
// 返回值：无返回值
ClipBoardProvider.prototype.addCustomData = function(content, type) {
  return this.clipboard_provider.set(content, type);
}

module.exports = ClipBoardProvider;
