//
//  Created by dingsu on 1/22/16.
//  Copyright © 2016 miechal. All rights reserved.
//
var sqlite3 = require('./sqlite3');

/**
 * @brief CryptoProvider offer Native Crypto ability
 */
function CryptoProvider() {
	this.crypto_provider = new sqlite3.DingTalkCryptoProvider();
}

// param: key:string, content:string, algostr:str, keyVersion:int, callback:function
// callback(result, content)
CryptoProvider.prototype.encrypt = function(key, content, algostr, keyVersion, callback) {
	this.crypto_provider.encrypt(key, content, algostr, keyVersion, function(err, result) {
		callback && callback(err, result);
	});
}

// param: key:string, algostr:str, keyVersion:int, sourcefile:string, destfile:string, callback:function
// callback(result, content)
CryptoProvider.prototype.encryptFile = function(key, algostr, keyVersion, sourcefile, destfile, callback) {
  this.crypto_provider.encryptFile(key, algostr, keyVersion, sourcefile, destfile, function(err, destfile, reason) {
    callback && callback(err, destfile, reason);
  });
}

//param: content:string, callback:function
CryptoProvider.prototype.decryptHeader = function(content, callback) {
  this.crypto_provider.decryptHeader(content, function(err, keyVersion, algostr) {
    callback && callback(err, keyVersion, algostr);
  });
}

//param: key:string, content:string, algostr:str, callback:function
CryptoProvider.prototype.decrypt = function(key, content, algostr, callback) {
	this.crypto_provider.decrypt(key, content, algostr, function(err, result) {
		callback && callback(err, result);
	});
}

//param: sourcefile:string, callback:function
CryptoProvider.prototype.decryptFileHeader = function(sourcefile, callback) {
  this.crypto_provider.decryptFileHeader(sourcefile, function(err, keyVersion, algostr) {
    callback && callback(err, keyVersion, algostr);
  });
}

//param: key:string, sourcefile:string, destfile:string, callback:function
CryptoProvider.prototype.decryptFile = function(key, sourcefile, destfile, callback) {
  this.crypto_provider.decryptFile(key, sourcefile, destfile, function(err, destfile, reason) {
    callback && callback(err, destfile, reason);
  });
}

/**
 * @brief 
 * param key_type(int) kTestKeyIndex = 1, kProductionKeyIndex = 2
 * param input_content(string) 
 * param callback(output_content(string), error(int)) 
 */
CryptoProvider.prototype.blackboxEncrypt = function(key_type, input_content, callback) {
	this.crypto_provider.blackboxEncrypt(key_type, input_content, function(output_content, error) {
		callback && callback(output_content, error);
	});
}

/**
 * @brief 
 * param key_type(int) kTestKeyIndex = 1, kProductionKeyIndex = 2
 * param input_content(string) 
 * param callback(output_content(string), error(int)) 
 */
CryptoProvider.prototype.blackboxDecrypt = function(key_type, input_content, callback) {
	this.crypto_provider.blackboxDecrypt(key_type, input_content, function(output_content, error) {
		callback && callback(output_content, error);
	});
}

module.exports = CryptoProvider;
