var hostHandles = {};
var HOST_ERRORS = {
    "SERVICE_HAS_REGISTERED" : "service has been registered",
    "NOT_REGISTERED" : "service do not register"
}

function _get(serviceName){
    return hostHandles[serviceName];
}

function _add(serviceName, handler){
    if(hostHandles[serviceName]){
        return new Error(HOST_ERRORS.SERVICE_HAS_REGISTERED+":"+serviceName);
    }else{
        hostHandles[serviceName] = handler;
    }
}

function _clear(serviceName){
    if(serviceName){
        if(getServiceByName(serviceName)){
            delete hostHandles[serviceName];
        }else{
            return new Error(HOST_ERRORS.NOT_REGISTERED+":"+serviceName);
        }
    }else{
        hostHandles = {};
    }
}

module.exports = {
    get : _get,
    add : _add,
    clear: _clear
}