var _hostHandlesCache = require("./_hostHandlesCache");
var CLIENT_ERRORS = {
    "NOT_REGISTER" : "not registered in host"
}
var EventEmitter = require("wolfy87-eventemitter");
var util = require("util");

function Client(name){
    this.name = name;
    EventEmitter.call(this);
    this.emitTimeout = 10000;
}

util.inherits(Client, EventEmitter);

Client.prototype.invoke = function(serviceName){
    var handler = _hostHandlesCache.get(serviceName);
    var args = Array.prototype.slice.call(arguments, 1);
    if(handler && typeof handler === "function"){
        return handler.apply(this,args);
    }else{
        return new Error(CLIENT_ERRORS.NOT_REGISTER);
    }
}

//overwrite emitEvent

// Client.prototype.emitEvent = function emitEvent(evt, args) {
//     var listenersMap = this.getListenersAsObject(evt);
//     var listeners;
//     var listener;
//     var i;
//     var key;
//     var response;
//     var promiseArr = [];
//     for (key in listenersMap) {
//         if (listenersMap.hasOwnProperty(key)) {
//             listeners = listenersMap[key].slice(0);
//             i = listeners.length;

//             while (i--) {
//                 listener = listeners[i];

//                 if (listener.once === true) {
//                     this.removeListener(evt, listener.listener);
//                 }
//                 var defer = this._getDefer();
//                 promiseArr.push(defer.promise);
//                 var argsWithDefer = [defer];
//                 if(args){
//                     argsWithDefer.push(args);
//                 }
//                 response = listener.listener.apply(this, argsWithDefer);

//                 if (response === this._getOnceReturnValue()) {
//                     this.removeListener(evt, listener.listener);
//                 }
//             }
//         }
//     }

//     return Promise.all(promiseArr);
// };

// Client.prototype._getDefer = function(){
//     var _defer = {};
//     _defer.promise = new Promise(function(resolve,reject){
//         _defer.resolve = function(){
//             resolve({
//                 code : 200
//             })
//         }
//         _defer.reject = function(respond){
//             resolve(respond)
//         }
//     });

//     setTimeout(function(){
//         _defer.reject({
//             code : 408,
//             reason : "timeout"
//         });
//     },this.emitTimeout);

//     return _defer;
// }

module.exports = Client;