var _hostHandlesCache = require("./_hostHandlesCache");
var clientManager = require("./clientManager");

function Host(){}

Host.prototype.getServiceByName = function(serviceName){
    return _hostHandlesCache.get(serviceName);
}

Host.prototype.register = function(serviceName, handler){
    return _hostHandlesCache.add(serviceName,handler);
}

Host.prototype.clearRegisters = function(serviceName){
    return _hostHandlesCache.clear(serviceName);
}

Host.prototype.emitToClients = function(event ,clientNames ,args){
    var clients = null;
    if(clientNames){
        clients = clientManager.getClients(clientNames);
    }else{
        clients = clientManager.getAllClients();
    }
    if(clients){
        var emits = clients.map(function(client){
            return client.emit(event, args);
        })   
    }
}

module.exports = new Host();