/*
 * Decompiled with CFR 0.152.
 */
package com.betkekk.earthlifemod;

import com.betkekk.earthlifemod.EarthLife;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static Configuration config;
    private static int casuarSpawnProb;
    private static int giraffeSpawnProb;
    private static int hyraxSpawnProb;
    private static int chimpanzeeSpawnProb;
    private static int monitorSpawnProb;
    private static int flamingoSpawnProb;
    private static int storkSpawnProb;
    private static int deerSpawnProb;
    private static int pandaSpawnProb;
    static final String comments = "Earth Life Mod Config\n Betkekk\n For Minecraft Version  1.10.2 ";
    static final String spawnProbComment = "Spawn Probability\nSet to zero to disable spawning of this entity";

    public static void startConfig(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        ConfigHandler.updateConfigInfo();
    }

    public static void updateConfigInfo() {
        try {
            config.addCustomCategoryComment("general", comments);
            casuarSpawnProb = config.get("general", "casuarSpawnProb", 20, spawnProbComment).getInt();
            giraffeSpawnProb = config.get("general", "giraffeSpawnProb", 15, null).getInt();
            hyraxSpawnProb = config.get("general", "hyraxSpawnProb", 15, null).getInt();
            chimpanzeeSpawnProb = config.get("general", "chimpanzeeSpawnProb", 15, null).getInt();
            monitorSpawnProb = config.get("general", "monitorSpawnProb", 20, null).getInt();
            flamingoSpawnProb = config.get("general", "flamingoSpawnProb", 15, null).getInt();
            storkSpawnProb = config.get("general", "storkSpawnProb", 15, null).getInt();
            deerSpawnProb = config.get("general", "deerSpawnProb", 15, null).getInt();
            pandaSpawnProb = config.get("general", "pandaSpawnProb", 10, null).getInt();
        }
        catch (Exception e) {
            EarthLife.proxy.info("failed to load or read the config file");
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static int getCasuarSpawnProb() {
        return casuarSpawnProb;
    }

    public static int getGiraffeSpawnProb() {
        return giraffeSpawnProb;
    }

    public static int getHyraxSpawnProb() {
        return hyraxSpawnProb;
    }

    public static int getChimpanzeeSpawnProb() {
        return chimpanzeeSpawnProb;
    }

    public static int getMonitorSpawnProb() {
        return monitorSpawnProb;
    }

    public static int getFlamingoSpawnProb() {
        return flamingoSpawnProb;
    }

    public static int getStorkSpawnProb() {
        return storkSpawnProb;
    }

    public static int getDeerSpawnProb() {
        return deerSpawnProb;
    }

    public static int getPandaSpawnProb() {
        return pandaSpawnProb;
    }
}

