local locationByItemByPlayer = {}


local originalISInventoryPaneRefreshContainer = ISInventoryPane.refreshContainer
local originalISInventoryPaneDrawItemDetails = ISInventoryPane.drawItemDetails


function ISInventoryPane:refreshContainer(...)
	local playerObj = getSpecificPlayer(self.player)
	locationByItem = {}
	locationByItemByPlayer[self.player] = locationByItem

	locationByItem[playerObj:getPrimaryHandItem()] = "1stHand"
	locationByItem[playerObj:getSecondaryHandItem()] = "2ndHand"

	local wornItems = playerObj:getWornItems()
	for index = 0, (wornItems:size() - 1) do
		local wornItem = wornItems:get(index)
		locationByItem[wornItem:getItem()] = wornItem:getLocation()
	end


	return originalISInventoryPaneRefreshContainer(self, ...)
end

function ISInventoryPane:drawItemDetails(item, y, xoff, yoff, red, ...)
	local locationByItem = (locationByItemByPlayer[self.player] or {})
	local location = locationByItem[item]
	local itemMetatable = nil
	local originalItemGetName = nil
	if		location ~= nil then
		local nameWithLocation = item:getName().." ["..location.."]"
		itemMetatable = getmetatable(item)
		originalItemGetName = itemMetatable.__index.getName
		function itemMetatable.__index.getName(...)
			return nameWithLocation
		end
	end


	local result = originalISInventoryPaneDrawItemDetails(self, item, y, xoff, yoff, red, ...)


	if		location ~= nil then
		itemMetatable.__index.getName = originalItemGetName
	end


	return result
end
