--------------------------------------------------
---- yiyu
--------------------------------------------------
local require = GLOBAL.require

Assets={

	Asset( "IMAGE", "images/yiyu_palmtree.tex" ),
	Asset( "ATLAS", "images/yiyu_palmtree.xml" ),
	Asset( "IMAGE", "images/yiyu_deciduoustree.tex" ),
	Asset( "ATLAS", "images/yiyu_deciduoustree.xml" ),
	Asset( "IMAGE", "images/yiyu_evergreen.tex" ),
	Asset( "ATLAS", "images/yiyu_evergreen.xml" ),
	Asset( "IMAGE", "images/yiyu_burnt.tex" ),
	Asset( "ATLAS", "images/yiyu_burnt.xml" ),
	Asset( "IMAGE", "images/yiyu_grass.tex" ),
	Asset( "ATLAS", "images/yiyu_grass.xml" ),
	Asset( "IMAGE", "images/yiyu_sapling.tex" ),
	Asset( "ATLAS", "images/yiyu_sapling.xml" ),
	Asset( "IMAGE", "images/yiyu_reeds.tex" ),
	Asset( "ATLAS", "images/yiyu_reeds.xml" ),
	Asset( "IMAGE", "images/yiyu_seaweed_planted.tex" ),
	Asset( "ATLAS", "images/yiyu_seaweed_planted.xml" ),
	Asset( "IMAGE", "images/yiyu_bambootree.tex" ),
	Asset( "ATLAS", "images/yiyu_bambootree.xml" ),

}

PrefabFiles = {"yiyuicons"}

local tree = 
	{
	"palmtree",
	"deciduoustree",
	"evergreen",
	"evergreen_sparse",
	"jungletree",
	}

local grass = 
	{
	"grass",
	"sapling",
	"reeds",
	"seaweed_planted",
	"bambootree",
--	"coralreef",
--	"red_mushroom",
--	"green_mushroom",
--	"blue_mushroom",
--	"flower_cave",
--	"flower_cave_double",
--	"flower_cave_triple",
	}

local function check_stump(inst)
	for k,v in pairs(tree) do
	if inst:HasTag("stump") then
		if inst.prefab == "palmtree" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_palmtree.tex" )
		inst.MiniMapEntity:SetPriority(-1)
		elseif inst.prefab == "deciduoustree" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_deciduoustree.tex" )
		inst.MiniMapEntity:SetPriority(-1)
		elseif inst.prefab == "evergreen" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_evergreen.tex" )
		inst.MiniMapEntity:SetPriority(-1)
		elseif inst.prefab == "evergreen_sparse" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_evergreen.tex" )
		inst.MiniMapEntity:SetPriority(-1)
		elseif inst.prefab == "jungletree" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_evergreen.tex" )
		inst.MiniMapEntity:SetPriority(-1)
		end
	elseif inst:HasTag("burnt") then
		inst.MiniMapEntity:SetIcon("yiyu_burnt.tex")
		inst.MiniMapEntity:SetPriority(0)
	end
end
end


local function check_pick(inst,root)
	if root == nil then
		local c = inst.components
		if c.pickable and c.pickable.canbepicked or c.hackable and c.hackable.canbehacked then
			root=0
		else
			root=1
		end
	end
for k,v in pairs(grass) do
	if root==0 then
		if inst.prefab == "grass" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "grass.png" )
		elseif inst.prefab == "sapling" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "sapling.png" )
		elseif inst.prefab == "reeds" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "reeds.png" )
		elseif inst.prefab == "seaweed_planted" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "seaweed.png" )
		elseif inst.prefab == "bambootree" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "bambootree.png" )
		end
	elseif root==1 then
		if inst.prefab == "grass" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_grass.tex" )
		inst.MiniMapEntity:SetPriority(3)
		elseif inst.prefab == "sapling" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_sapling.tex" )
		inst.MiniMapEntity:SetPriority(3)
		elseif inst.prefab == "reeds" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_reeds.tex" )
		inst.MiniMapEntity:SetPriority(3)
		elseif inst.prefab == "seaweed_planted" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_seaweed_planted.tex" )
		inst.MiniMapEntity:SetPriority(3)
		elseif inst.prefab == "bambootree" then
		inst.entity:AddMiniMapEntity()
		inst.MiniMapEntity:SetIcon( "yiyu_bambootree.tex" )
		inst.MiniMapEntity:SetPriority(3)
		end

	end
end
end

	if GetModConfigData("yiyuicons") == true then
for k,v in pairs(grass) do
		AddPrefabPostInit(v,function(inst)
			if inst.MiniMapEntity==nil then
				inst.entity:AddMiniMapEntity()
			end
			inst:ListenForEvent("picked",function(inst,data)
				check_pick(inst,1)
			end)
			inst:ListenForEvent("hacked",function(inst,data)
				check_pick(inst,1)
			end)
			inst:DoTaskInTime(0,check_pick)
			if type(v) == "string" then
				inst.stump_old_icon = v
			end
		end)
	end


local function Inject(comp,fn_name,fn)
	local old = comp[fn_name]
	comp[fn_name] = function(self,...)
		old(self,...)
		fn(self.inst)
	end
end

local work = require "components/workable"
Inject(work,"SetOnFinishCallback",function(inst)
		inst:DoTaskInTime(0,check_stump)
end)


local pick = require "components/pickable"
Inject(pick,"Regen",function(inst)
check_pick(inst,0)
end)
Inject(pick,"MakeBarren",function(inst)
check_pick(inst,0)
end)
Inject(pick,"MakeEmpty",function(inst)
check_pick(inst,0)
end)

if not GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then
local hack = require "components/hackable"
Inject(hack,"Regen",function(inst)
check_pick(inst,0)
end)
Inject(hack,"MakeBarren",function(inst)
check_pick(inst,0)
end)
Inject(hack,"MakeEmpty",function(inst)
check_pick(inst,0)
end)
end
end

-------------------------------------ͼʾ

function AddMap(prefab)
		table.insert(Assets, Asset("IMAGE", "images/" .. prefab .. ".tex"))
		table.insert(Assets, Asset("ATLAS", "images/" .. prefab .. ".xml"))
		AddMinimapAtlas("images/" .. prefab .. ".xml")
		AddPrefabPostInit(prefab, function(inst)
			inst.entity:AddMiniMapEntity()
			inst.MiniMapEntity:SetIcon(prefab .. ".tex")
		end)
	end

yiyuicons=
{
	"yiyu_palmtree",
	"yiyu_deciduoustree",
	"yiyu_evergreen",
	"yiyu_burnt",
	"yiyu_grass",
	"yiyu_sapling",
	"yiyu_reeds",
	"yiyu_seaweed_planted",
	"yiyu_bambootree",
}

moreicons=
{

	"jellyfish_planted",--ˮĸ
	"solofish",--
	"flup",--Ծ
	"sandhill",--ɳ
	"seashell_beached",--
	"frog",--
	"crabhole",--з
	"bat",--
	"rocky",--ʯϺ
	"snurtle",--
	"worm",--
	"slurper",--ʳ
	"wall_hay",--ǽ
	"wall_moonrock",--ʯǽ
	"wall_ruins",--ǽ
	"wall_stone",--ʯǽ
	"wall_wood",--ľǽ
	"sandbag",--ɳ
	"wall_limestone",--ʯǽ
	"waxwelljournal",--˹־
	"tentacle",--	
	"tentacle_pillar",--
	"crawlinghorror",--Ӱ1
	"crawlingnightmare",--Ӱ2
	"terrorbeak",--Ӱ2
	"nightmarebeak",--Ӱ
	"mosquito_poison",--
	"fireflies",--ө
	"fishinhole",--ȴȺ
	"molehill",--
}

prefabs_to_add =
{

	"flint",--ʯ
	"rock2",--
	"green_mushroom",	--Ģ
	"blue_mushroom",--Ģ
	"red_mushroom",--Ģ
	"carrot_planted",--ܲ
	"rabbithole",--Ӷ
	"whale_blue",--
	"whale_white",--׾
	"magmarock_gold",--ҽ
	"volcanostaff",--ɽȨ
	"livingjungletree",--ľ
	"obsidian",--ʯ
	"knightboat",--ִ
	"bioluminescence",--ӫ
	"ballphin",--ں
	"swordfish",--
	"packim_fishbone",--
	"chester_eyebone",--۹
	"twister",--籩BOSS
	"tigershark",--BOSS	
	"animal_track",--
	"dirtpile",--ɵ
	"whale_bubbles",--
	"flower_cave_double",--Ѩ2
	"flower_cave_triple",--Ѩ3
	"mandrake",--
	"berrybush",--
	"coffeebush",--
	"sharx",--
	"hound",--
	"icehound",--
	"firehound",--
	"houndbone",--
	"snakeden",--
	"pighead",--ͷ
	"scorched_skeleton",--Ǽս
	"skeleton",--Ǽ
	"skeleton_player",--Ǽ
	"teleportato_box",--1
	"teleportato_crank",--2
	"teleportato_potato",--3
	"teleportato_ring",--4
	"teleportato_sw_box",--1
	"teleportato_sw_crank",--2
	"teleportato_sw_potato",--3
	"teleportato_sw_ring",--4
	"koalefant_summer",--7
	"koalefant_winter",--8
	"warg",--
	"krampus",--˹
	"lightninggoat",--ɽ
	"ancient_altar",--Զż̳
	"ancient_altar_broken",--𻵵ļ̳
	"minotaur",--ԶϬţ
	"mossling",--СѼ
	"moose",--±Ѽ
	"mooseegg",--±Ѽ
	"dragonfly",--
	"bearger",--
	"deerclops",--¹
	"knight",--ʿ
	"knight_nightmare",--ʿ2
	"rook",--ս
	"rook_nightmare",--ս2
	"bishop",--
	"bishop_nightmare",--2
	"ghost",--
	"walrus",--
	"littlewalrus",--
	"pigman",--
	"wildbore",--Ұ
	"bunnyman",--
	"mermhouse_fisher",--˷2
	"doydoy",--ˮţ
	"ox",--ˮţ
	"beefalo",--ţ
	"babybeefalo",--Сţ
	"leif",--
	"leif_sparse",--ϡ
	"spiderqueen",--֩Ů
--	"merm",--
--	"pigguard",--
--	"rabbithole",--÷
--	"tallbird",--
--	"mermhouse",--˷
--	"mermfisher",--
--	"marsh_bush",--ľ
}


for k,v in pairs(prefabs_to_add) do
if GetModConfigData("IconState") == true then
		AddMap(v)
	end
end

for k,v in pairs(moreicons) do
	if GetModConfigData("MoreIcons") == true then
		AddMap(v)
end
end

for k,v in pairs(yiyuicons) do
	if GetModConfigData("yiyuicons") == true then
		AddMap(v)
end
end