$(function(){
	var Menu = (function(){
		return {
			make: function(data, modelPath){
				if(!data || !data.menu || !data.menu.length) return false;
				var container = $('#meterialMenu');
					container.html('');
					
				data.hideMenu && data.hideMenu();
				
				$.each(data.menu, function(index, item){
					if(!item) return;
					var linker = $('<a href="#" value="' + data.config.pageRoot+this.value+'&token='+pur5.Cfg.token+'"><span><span class="icon">'+this.name+'</span></span></a>'),
						css = {
							'background-image': 'url(' +data.config.picRoot + this.pic+')'
						};
					container.append(linker);
					linker.find('a').css(css).end().find('span>span').css(css);
					if(item.item && item.item.length){
						linker.append('<ul></ul>');
						for(var i=0; i<item.item.length; i++){
							linker.find('ul').append('<li><a href="#" value="' +data.config.pageRoot + item.item[i][1] + '&token='+pur5.Cfg.token+'">'+item.item[i][0]+'</a></li>');
						}
						linker.find('ul').css({
							width: linker.find('ul').width()
						});
					}
				});
			},
			init: function(){
				$('#meterialMenu')
				.find('a')
				.click(function(){
					var subType;
					if($(this).parent().prop('tagName').toLowerCase() == 'td'){
						subType = $(this).find('span>span').text();
					}else{
						subType = $(this).parents('ul').prev().text();
					}
					if(pur5.Pages.Version.subType != subType){
						pur5.Pages.Version.subType = subType;
						pur5.Pages.setIndexStatus('notice');
					}
					pur5.Pages.iframeTo($(this).attr('value'), true);					
					return false;
				})
				.focus(function(){
					this.blur();
				})
				.end()
				.find('>a')
				.mouseover(function(){
					var self = $(this);
					self.find('>span').andSelf().css({
						'background-position-y': -29,
						'color': '#545454'
					});
					self.find('ul').show();
				})
				.mousedown(function(){
					$(this).find('>span').andSelf().css({
						'background-position-y': -58,
						'color': '#545454'
					});					
				})
				.mouseout(function(){
					$(this).find('>span').andSelf().css({
						'background-position-y': -0,
						'color': '#545454'
					});					
					$(this).find('ul').hide();
				});
			}
		}
	})();			
			
			
	$.include('scripts/', [
		'inc/function.js',
		'inc/jquery.stringify.js'
	], function(){
		var layout =  $('#MeterialMenu'),
			modelPath = layout.attr('modelpath');
					
		$.ajax({
			url: pur5.Cfg.GBHOSTSOFT + 'meterial-data.asp',
			type: 'post',
			dataType: 'json',
			success: function(data){
				this.init(data);				
			},
			error: function(jqXhr, testStatus){
				var data;
				try{
					data = (new Function("return " + $.trim(jqXhr.responseText)))();
				}catch(e){}
				
				this.init(data);
			},
			init: function(data){
				Menu.make(data, modelPath);
				Menu.init();
			}
		});		
	});
});